---
-- The windows event logger object has the following methods:<BR/>
-- <BR/>
-- <B>info(message)</B> : 
-- Send an event at level INFO
-- <BR/>
-- <BR/>
-- <B>warn(message)</B> : 
-- Send an event at level WARN
-- <BR/>
-- <BR/>
-- <B>error(message)</B> : 
-- Send an event at level ERROR
-- <BR/>
-- <BR/>
-- <B>log(level,message)</B> : 
-- Send an event at level level
-- <BR/>
-- <BR/>
-- <B>serialize(name)</B> : 
-- Serialize the logger
-- <BR/>
-- <BR/>
--

MODULE_VERSION = "0.0.1"
MODULE_NAME = "wel"
MODULE_REQUIRE_VERSION = "0.2.8"
MODULE_LICENSE = "GNU/GPL"
MODULE_URL = "http://www.freepops.org/download.php?module=wel.lua"
MODULE_HOMEPAGE = "http://www.freepops.org/"

local maker = require 'wel.core'
local setmetatable = setmetatable

module('wel')

---
-- Cretes a windows event logger.
-- @param app string The application name (optional).
-- @param source string The application module generating the events (optional).
-- @param file string The path to the manifest file (optional).
-- @return windows event logger object.
function new(app,source,file)
	local l = maker.new(app,source,file)
	local o_mt = {
		__index = {
			info = function(_,msg) l('INFO',msg) end,
			warn = function(_,msg) l('WARN',msg) end,
			error = function(_,msg) l('ERROR',msg) end,
			log = function(_,level,msg) l(level,msg) end,
			serialize = function (_,name)
				local s = name .. " = wel.new("
				if app ~= nil then
				  s = s .. '"' .. app .. '"'
				  if source ~= nil then
				    s = s .. ',"' .. source .. '"'
				    if file ~= nil then
				      s = s .. ',"' .. file .. '"'
				    end
				  end
				end
				s = s .. ");"
				return s
			end,
		},
		__tostring = function() return "Windows logger" end,
	}
	local o = {}
	setmetatable(o,o_mt)
	return o
end
