/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.util.Enumeration;
import java.util.Vector;
import opendap.dap.BadSemanticsException;
import opendap.dap.BaseType;

class Util {
    Util() {
    }

    static void uniqueNames(Vector v, String varName, String typeName) throws BadSemanticsException {
        String[] names = Util.sortedNames(v);
        for (int i = 1; i < names.length; ++i) {
            if (!names[i - 1].equals(names[i])) continue;
            throw new BadSemanticsException("The variable `" + names[i] + "' is used more than once in " + typeName + " `" + varName + "'");
        }
    }

    static String[] sortedNames(Vector v) throws BadSemanticsException {
        String[] names = new String[v.size()];
        int count = 0;
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            String tempName = bt.getName();
            if (tempName == null) {
                throw new BadSemanticsException(bt.getClass().getName() + " variable with no name");
            }
            names[count++] = tempName;
        }
        if (count != names.length) {
            throw new IndexOutOfBoundsException("Vector size changed unexpectedly");
        }
        Util.quickSort(names, 0, names.length - 1);
        return names;
    }

    private static void quickSort(String[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            String mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && a[lo].compareTo(mid) < 0) {
                    ++lo;
                }
                while (hi > lo0 && a[hi].compareTo(mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                Util.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                Util.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                Util.quickSort(a, lo, hi0);
            }
        }
    }

    private static void swap(String[] a, int i, int j) {
        String T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    static String escattr(String s) {
        StringBuffer buf = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c >= '!' && c <= '~') {
                buf.append(c);
                continue;
            }
            buf.append('\\');
            String numVal = Integer.toString(c & 0xFF, 8);
            for (int pad = 0; pad < 3 - numVal.length(); ++pad) {
                buf.append('0');
            }
            buf.append(numVal);
        }
        return buf.toString();
    }
}

