# FindSystem match the operating system and set some
# CFLAGS for compile the source code.
#
# The following variables are set:
# CMAKE_C_FLAGS - flags to add to the C compiler for buil arpon
#
# Copyright 2010 <Giuseppe Marco Randazzo> zeld@freaknet.org
#
# Redistribution AND use is allowed according to the terms of the New
# BSD license.

macro( DNETH_DEBIAN_UBUNTU )
  set( ID_RELEASE )
  find_program(LSB_RELEASE NAMES lsb_release PATHS /bin
  /sbin
  /usr/bin
  /usr/sbin
  /usr/local/bin
  /usr/local/sbin)
  if(LSB_RELEASE)
    execute_process(COMMAND ${LSB_RELEASE} -i
      OUTPUT_VARIABLE ID_RELEASE)
    string(REGEX REPLACE ".*:" "" ID_RELEASE "${ID_RELEASE}")

    if(${ID_RELEASE} MATCHES "Ubuntu")
      message(STATUS "Linux Distro: ${ID_RELEASE}")
      set( UBUNTU TRUE )
      add_definitions( -DDEBIAN )
    elseif(${ID_RELEASE} MATCHES "Debian")
      message(STATUS "Linux Distro: ${ID_RELEASE}")
      set( DEBIAN TRUE )
      add_definitions( -DDEBIAN )
    endif(${ID_RELEASE} MATCHES "Ubuntu")

  endif( LSB_RELEASE )
  endmacro( DNETH_DEBIAN_UBUNTU )

macro( SETHEADERNAME )
  if( APPLE OR UNIX)
    set(libnet_h "libnet.h")
    if( UBUNTU OR DEBIAN )
      set(libdnet_h "dumbnet.h")
    else()
      set(libdnet_h "dnet.h")
    endif( UBUNTU OR DEBIAN )

    set(libpcap_h "pcap.h")
    set(libpthread_h "pthread.h")
  elseif( WIN32 )
    message(FATAL_ERROR "Windows Operating System Not Supported")
  else( APPLE OR UNIX )
    message(FATAL_ERROR "Unknown OS! Unable to detect system library.")
  endif( APPLE OR UNIX)
endmacro( SETHEADERNAME )

macro( SETLIBNAME )
  if( APPLE )
    set(libnet "libnet.a")
    set(libdnet "libdnet.a")
    set(libpcap "libpcap.a")
    set(libpthread "libpthread.dylib")
  elseif( UNIX )
    set(libnet "libnet.a")
    set(libpcap "libpcap.a")
    set(libpthread "libpthread.a")
    if( UBUNTU OR DEBIAN )
      set(libdnet "libdumbnet.a")
    else()
      set(libdnet "libdnet.a")
    endif(UBUNTU OR DEBIAN)
  elseif( WIN32 )
    message(FATAL_ERROR "Windows Operating System Not Supported")
  else( APPLE  )
    message(FATAL_ERROR "Unknown OS! Unable to detect system library.")
  endif( APPLE  )
endmacro( SETLIBNAME )

if( APPLE )
  # Mac OS X specific code
  message(STATUS "Operating System Found: OSX")
  SETHEADERNAME()
  SETLIBNAME()
  # include_directories("/opt/local/include")
  # link_directories("/opt/local/lib/")
  #set(INCLUDE_DIR "${INCLUDE_DIR} /opt/local/include/")
  #set(LIB_DIR "${LIB_DIR} /opt/local/lib/")

elseif( UNIX )
  if(${CMAKE_SYSTEM_NAME} MATCHES "FreeBSD")
    # FreeBSD specific code
    message(STATUS "Operating System Found: FreeBSD")
    SETHEADERNAME()
    SETLIBNAME()
  endif(${CMAKE_SYSTEM_NAME} MATCHES "FreeBSD")

  if(${CMAKE_SYSTEM_NAME} MATCHES "NetBSD")
    # NetBSD specific code
    message(STATUS "Operating System Found: NetBSD")
    set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -DNETBSD")
    SETHEADERNAME()
    SETLIBNAME()
  endif(${CMAKE_SYSTEM_NAME} MATCHES "NetBSD")

  if(${CMAKE_SYSTEM_NAME} MATCHES "OpenBSD")
    # OpenBSD specific code
    message(STATUS "Operating System Found: OpenBSD")
    set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -DOPENBSD")
    SETHEADERNAME()
    SETLIBNAME()
  endif(${CMAKE_SYSTEM_NAME} MATCHES "OpenBSD")
  if(${CMAKE_SYSTEM_NAME} MATCHES "Linux")
    # Linux specific code
    message(STATUS "Operating System: GNU/Linux")
    set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -DLINUX")
    DNETH_DEBIAN_UBUNTU()
    SETHEADERNAME()
    SETLIBNAME()
  endif(${CMAKE_SYSTEM_NAME} MATCHES "Linux")
elseif( WIN32 )
  message(FATAL_ERROR "Windows Operating System Not Supported")
else( APPLE )
  message(FATAL_ERROR "Operating System Not Supported")
endif( APPLE )
