#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Coffee Talk
# send your bug reports to contact@dotslashplay.it
###

script_version=20240228.2

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='coffee-talk'
GAME_NAME='Coffee Talk'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

# Archives

## Full game

ARCHIVE_BASE_2_NAME='setup_coffee_talk_1.48_(56192).exe'
ARCHIVE_BASE_2_MD5='480480ca243cb1371aa8160ae04f035d'
ARCHIVE_BASE_2_TYPE='innosetup'
ARCHIVE_BASE_2_SIZE='774504'
ARCHIVE_BASE_2_VERSION='1.48-gog56192'
ARCHIVE_BASE_2_URL='https://www.gog.com/game/coffee_talk'

ARCHIVE_BASE_1_NAME='setup_coffee_talk_1.45_(48679).exe'
ARCHIVE_BASE_1_MD5='d10f2ec8ced1716f90dbc4d940cf232f'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='780000'
ARCHIVE_BASE_1_VERSION='1.45-gog48679'

ARCHIVE_BASE_0_NAME='setup_coffee_talk_1.0.39_(41435).exe'
ARCHIVE_BASE_0_MD5='fd9a907261fce1069e1ffc37938e42d5'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='910000'
ARCHIVE_BASE_0_VERSION='1.0.39-gog41435'

## Demo

ARCHIVE_BASE_DEMO_1_NAME='setup_coffee_talk_demo_1.0.40_(46157).exe'
ARCHIVE_BASE_DEMO_1_MD5='c7d07aa9a162e1ad8d6cf527e8193bbe'
ARCHIVE_BASE_DEMO_1_TYPE='innosetup'
ARCHIVE_BASE_DEMO_1_SIZE='820000'
ARCHIVE_BASE_DEMO_1_VERSION='1.0.40-gog46157'
ARCHIVE_BASE_DEMO_1_URL='https://www.gog.com/game/coffee_talk_demo'

ARCHIVE_BASE_DEMO_0_NAME='setup_coffee_talk_demo_0.92.59_(32093).exe'
ARCHIVE_BASE_DEMO_0_MD5='107cb1767fb8033ad06b5baaeb54e159'
ARCHIVE_BASE_DEMO_0_TYPE='innosetup'
ARCHIVE_BASE_DEMO_0_SIZE='650000'
ARCHIVE_BASE_DEMO_0_VERSION='0.92.59-gog32093'


UNITY3D_NAME='coffeetalk'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME0_DATA_FILES='
cticon.png'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Toge Productions/CoffeeTalk'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ID="$GAME_ID"
PKG_BIN_ID_DEMO="$GAME_ID_DEMO"
PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPS_DEMO="$PKG_DATA_ID_DEMO"
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
video/quicktime, variant=(string)iso'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
