#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2019 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# About Love, Hate and the Other Ones
# send your bug reports to contact@dotslashplay.it
###

script_version=20240603.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='about-love-hate-and-the-other-ones'
GAME_NAME='About Love, Hate and the Other Ones'

ARCHIVE_BASE_0_NAME='aboutloveandhate-1.3.1.deb'
ARCHIVE_BASE_0_MD5='65c314a2a970b5c787d4e7e2a837e211'
ARCHIVE_BASE_0_SIZE='570000'
ARCHIVE_BASE_0_VERSION='1.3.1-humble150312'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/about-love-hate-and-the-other-ones'

CONTENT_PATH_DEFAULT='usr/local/games/loveandhate'
CONTENT_GAME_BIN64_PATH="${CONTENT_PATH_DEFAULT}/bin64"
CONTENT_GAME_BIN64_FILES='
loveandhate'
CONTENT_GAME_BIN32_PATH="${CONTENT_PATH_DEFAULT}/bin32"
CONTENT_GAME_BIN32_FILES='
loveandhate'
CONTENT_GAME_DATA_FILES='
bin'
CONTENT_DOC_DATA_FILES='
README'

FAKE_HOME_PERSISTENT_DIRECTORIES='
.aboutloveandhate'

APP_MAIN_EXE='loveandhate'
APP_MAIN_ICONS_LIST='APP_MAIN_ICON_16 APP_MAIN_ICON_24 APP_MAIN_ICON_32 APP_MAIN_ICON_48 APP_MAIN_ICON_64 APP_MAIN_ICON_128 APP_MAIN_ICON_256'
APP_MAIN_ICON_16='../../../share/icons/hicolor/16x16/apps/loveandhate.png'
APP_MAIN_ICON_24='../../../share/icons/hicolor/24x24/apps/loveandhate.png'
APP_MAIN_ICON_32='../../../share/icons/hicolor/32x32/apps/loveandhate.png'
APP_MAIN_ICON_48='../../../share/icons/hicolor/48x48/apps/loveandhate.png'
APP_MAIN_ICON_64='../../../share/icons/hicolor/64x64/apps/loveandhate.png'
APP_MAIN_ICON_128='../../../share/icons/hicolor/128x128/apps/loveandhate.png'
APP_MAIN_ICON_256='../../../share/icons/hicolor/256x256/apps/loveandhate.png'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN64_DEPS="$PKG_BIN_DEPS"
PKG_BIN32_DEPS="$PKG_BIN_DEPS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libGL.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
libX11.so.6'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
