/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.pairhmm;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.Arrays;
import org.broadinstitute.gatk.utils.QualityUtils;
import org.broadinstitute.gatk.utils.pairhmm.PairHMM;
import org.broadinstitute.gatk.utils.pairhmm.PairHMMModel;

public class ArrayLoglessPairHMM
extends PairHMM {
    private static final double INITIAL_CONDITION = Math.pow(2.0, 1020.0);
    private static final double INITIAL_CONDITION_LOG10 = Math.log10(INITIAL_CONDITION);
    protected static final double TRISTATE_CORRECTION = 3.0;
    protected double[][] transition = null;
    protected double[][] prior = null;
    private double[] currentMatchArray = null;
    private double[] currentDeleteArray = null;
    private double[] currentInsertArray = null;
    private double[] parentMatchArray = null;
    private double[] parentDeleteArray = null;
    private double[] parentInsertArray = null;
    private double[] grandparentMatchArray = null;
    private double[] grandparentDeleteArray = null;
    private double[] grandparentInsertArray = null;
    private double[] matchCacheArray = null;
    private double[] deleteCacheArray = null;
    private double[] insertCacheArray = null;
    private double[] nextMatchCacheArray = null;
    private double[] nextDeleteCacheArray = null;
    private double[] nextInsertCacheArray = null;
    private double partialSum;

    @Override
    public void initialize(int readMaxLength, int haplotypeMaxLength) {
        super.initialize(readMaxLength, haplotypeMaxLength);
        this.transition = PairHMMModel.createTransitionMatrix(this.maxReadLength);
        this.prior = new double[this.paddedMaxReadLength][this.paddedMaxHaplotypeLength];
        this.currentMatchArray = new double[this.paddedMaxReadLength];
        this.currentDeleteArray = new double[this.paddedMaxReadLength];
        this.currentInsertArray = new double[this.paddedMaxReadLength];
        this.parentMatchArray = new double[this.paddedMaxReadLength];
        this.parentDeleteArray = new double[this.paddedMaxReadLength];
        this.parentInsertArray = new double[this.paddedMaxReadLength];
        this.grandparentMatchArray = new double[this.paddedMaxReadLength];
        this.grandparentDeleteArray = new double[this.paddedMaxReadLength];
        this.grandparentInsertArray = new double[this.paddedMaxReadLength];
        this.matchCacheArray = new double[this.paddedMaxReadLength];
        this.deleteCacheArray = new double[this.paddedMaxReadLength];
        this.insertCacheArray = new double[this.paddedMaxReadLength];
        this.nextMatchCacheArray = new double[this.paddedMaxReadLength];
        this.nextDeleteCacheArray = new double[this.paddedMaxReadLength];
        this.nextInsertCacheArray = new double[this.paddedMaxReadLength];
    }

    @Override
    public double subComputeReadLikelihoodGivenHaplotypeLog10(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, int hapStartIndex, boolean recacheReadValues, int nextHapStartIndex) {
        if (!this.constantsAreInitialized) {
            ArrayLoglessPairHMM.initializeProbabilities(this.transition, insertionGOP, deletionGOP, overallGCP);
            this.constantsAreInitialized = true;
        }
        this.initializePriors(haplotypeBases, readBases, readQuals, hapStartIndex);
        if (recacheReadValues) {
            hapStartIndex = 0;
            ArrayLoglessPairHMM.initializeProbabilities(this.transition, insertionGOP, deletionGOP, overallGCP);
            this.constantsAreInitialized = true;
            this.padMatchAndInsertArrays(readBases.length);
        }
        if (hapStartIndex == 0) {
            this.clearPreviouslyCachedInfo(readBases.length);
            this.padDeleteArrays(haplotypeBases.length, readBases.length);
        }
        this.clearArraySolutionPosition();
        int maxDiagonals = readBases.length + haplotypeBases.length - hapStartIndex - 1;
        int cacheSumIndex = nextHapStartIndex - hapStartIndex + readBases.length - 1;
        double finalArraySumProbabilities = this.partialSum;
        for (int i = 1; i <= maxDiagonals; ++i) {
            int startFill = Math.max(readBases.length - i, 0);
            int endFill = Math.min(maxDiagonals - i + 1, readBases.length);
            if (i <= readBases.length) {
                this.applyPreviouslyCachedInfo(startFill);
            }
            this.updateArrays(readBases.length, hapStartIndex, nextHapStartIndex, startFill, endFill, i);
            finalArraySumProbabilities += this.currentInsertArray[0] + this.currentMatchArray[0];
            if (i == cacheSumIndex) {
                this.partialSum = finalArraySumProbabilities;
            }
            this.rotateArrayReferences();
        }
        this.rotateCacheArrays();
        return Math.log10(finalArraySumProbabilities) - INITIAL_CONDITION_LOG10;
    }

    public void initializePriors(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, int startIndex) {
        for (int i = 0; i < readBases.length; ++i) {
            byte x = readBases[i];
            byte qual = readQuals[i];
            for (int j = startIndex; j < haplotypeBases.length; ++j) {
                byte y = haplotypeBases[j];
                this.prior[i + 1][j + 1] = x == y || x == 78 || y == 78 ? QualityUtils.qualToProb(qual) : QualityUtils.qualToErrorProb(qual) / (this.doNotUseTristateCorrection ? 1.0 : 3.0);
            }
        }
    }

    @Requires(value={"insertionGOP != null", "deletionGOP != null", "overallGCP != null"})
    @Ensures(value={"constantsAreInitialized"})
    protected static void initializeProbabilities(double[][] transition, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP) {
        PairHMMModel.qualToTransProbs(transition, insertionGOP, deletionGOP, overallGCP);
    }

    private void padMatchAndInsertArrays(int padPosition) {
        this.grandparentMatchArray[padPosition] = 0.0;
        this.grandparentInsertArray[padPosition] = 0.0;
        this.parentMatchArray[padPosition] = 0.0;
        this.parentInsertArray[padPosition] = 0.0;
        this.currentMatchArray[padPosition] = 0.0;
        this.currentInsertArray[padPosition] = 0.0;
        this.matchCacheArray[padPosition] = 0.0;
        this.insertCacheArray[padPosition] = 0.0;
        this.nextMatchCacheArray[padPosition] = 0.0;
        this.nextInsertCacheArray[padPosition] = 0.0;
    }

    private void padDeleteArrays(int haplotypeLength, int padPosition) {
        double initialValue;
        this.parentDeleteArray[padPosition] = initialValue = INITIAL_CONDITION / (double)haplotypeLength;
        this.grandparentDeleteArray[padPosition] = initialValue;
        this.currentDeleteArray[padPosition] = initialValue;
        this.deleteCacheArray[padPosition] = initialValue;
        this.nextDeleteCacheArray[padPosition] = initialValue;
    }

    private void clearArraySolutionPosition() {
        this.grandparentMatchArray[0] = 0.0;
        this.grandparentInsertArray[0] = 0.0;
        this.parentMatchArray[0] = 0.0;
        this.parentInsertArray[0] = 0.0;
        this.currentMatchArray[0] = 0.0;
        this.currentInsertArray[0] = 0.0;
    }

    private void clearPreviouslyCachedInfo(int fillLength) {
        Arrays.fill(this.matchCacheArray, 0, fillLength, 0.0);
        Arrays.fill(this.deleteCacheArray, 0, fillLength, 0.0);
        Arrays.fill(this.insertCacheArray, 0, fillLength, 0.0);
        this.partialSum = 0.0;
    }

    private void applyPreviouslyCachedInfo(int indK) {
        this.parentMatchArray[indK] = this.matchCacheArray[indK];
        this.parentDeleteArray[indK] = this.deleteCacheArray[indK];
        this.grandparentMatchArray[indK + 1] = this.matchCacheArray[indK + 1];
        this.grandparentDeleteArray[indK + 1] = this.deleteCacheArray[indK + 1];
        this.grandparentInsertArray[indK + 1] = this.insertCacheArray[indK + 1];
    }

    private void recordNewCacheInfo(int indK) {
        this.nextMatchCacheArray[indK] = this.currentMatchArray[indK];
        this.nextDeleteCacheArray[indK] = this.currentDeleteArray[indK];
        this.nextInsertCacheArray[indK] = this.currentInsertArray[indK];
    }

    private void updateArrays(int readLength, int hapStartIndex, int nextHapStartIndex, int startFill, int endFill, int iii) {
        for (int arrayIndex = startFill; arrayIndex < endFill; ++arrayIndex) {
            int matrixRow = readLength - arrayIndex - 1;
            int matrixCol = iii - matrixRow - 1 + hapStartIndex;
            this.updateArrayCell(arrayIndex, this.prior[matrixRow + 1][matrixCol + 1], this.transition[matrixRow + 1]);
            if (matrixCol != nextHapStartIndex - 1) continue;
            this.recordNewCacheInfo(arrayIndex);
        }
    }

    private void updateArrayCell(int indK, double prior, double[] transition) {
        this.currentMatchArray[indK] = prior * (this.grandparentMatchArray[indK + 1] * transition[0] + this.grandparentInsertArray[indK + 1] * transition[1] + this.grandparentDeleteArray[indK + 1] * transition[1]);
        this.currentInsertArray[indK] = this.parentMatchArray[indK + 1] * transition[2] + this.parentInsertArray[indK + 1] * transition[3];
        this.currentDeleteArray[indK] = this.parentMatchArray[indK] * transition[4] + this.parentDeleteArray[indK] * transition[5];
    }

    private void rotateArrayReferences() {
        double[] tempMatchArray = this.grandparentMatchArray;
        double[] tempDeleteArray = this.grandparentDeleteArray;
        double[] tempInsertArray = this.grandparentInsertArray;
        this.grandparentMatchArray = this.parentMatchArray;
        this.grandparentDeleteArray = this.parentDeleteArray;
        this.grandparentInsertArray = this.parentInsertArray;
        this.parentMatchArray = this.currentMatchArray;
        this.parentDeleteArray = this.currentDeleteArray;
        this.parentInsertArray = this.currentInsertArray;
        this.currentMatchArray = tempMatchArray;
        this.currentDeleteArray = tempDeleteArray;
        this.currentInsertArray = tempInsertArray;
    }

    private void rotateCacheArrays() {
        this.matchCacheArray = (double[])this.nextMatchCacheArray.clone();
        this.deleteCacheArray = (double[])this.nextDeleteCacheArray.clone();
        this.insertCacheArray = (double[])this.nextInsertCacheArray.clone();
    }
}

