/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import javax.swing.JSplitPane;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JSplitPaneLocationCalculator;
import org.fest.swing.driver.JSplitPaneSetDividerLocationTask;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.GenericRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSplitPaneDriver
extends JComponentDriver {
    public JSplitPaneDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void moveDividerTo(JSplitPane splitPane, int location) {
        int newLocation = JSplitPaneLocationCalculator.locationToMoveDividerTo(splitPane, location);
        this.simulateMovingDivider(splitPane, newLocation);
        JSplitPaneSetDividerLocationTask.setDividerLocation(splitPane, newLocation);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void simulateMovingDivider(JSplitPane split, int location) {
        if (split.getOrientation() == 0) {
            this.simulateMovingDividerVertically(split, location);
            return;
        }
        this.simulateMovingDividerHorizontally(split, location);
    }

    @RunsInEDT
    private void simulateMovingDividerVertically(JSplitPane splitPane, int location) {
        GenericRange<Point> whereToMove = JSplitPaneDriver.validateAndFindWhereToMoveDividerVertically(splitPane, location);
        this.simulateMovingDivider(splitPane, whereToMove);
    }

    @RunsInEDT
    private static GenericRange<Point> validateAndFindWhereToMoveDividerVertically(final JSplitPane splitPane, final int location) {
        return GuiActionRunner.execute(new GuiQuery<GenericRange<Point>>(){

            @Override
            protected GenericRange<Point> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(splitPane);
                return JSplitPaneDriver.whereToMoveDividerVertically(splitPane, location);
            }
        });
    }

    @RunsInCurrentThread
    private static GenericRange<Point> whereToMoveDividerVertically(JSplitPane splitPane, int location) {
        int x = splitPane.getWidth() / 2;
        int dividerLocation = splitPane.getDividerLocation();
        return new GenericRange<Point>(new Point(x, dividerLocation), new Point(x, location));
    }

    private void simulateMovingDividerHorizontally(JSplitPane splitPane, int location) {
        GenericRange<Point> whereToMove = JSplitPaneDriver.validateAndFindWhereToMoveDividerHorizontally(splitPane, location);
        this.simulateMovingDivider(splitPane, whereToMove);
    }

    @RunsInEDT
    private static GenericRange<Point> validateAndFindWhereToMoveDividerHorizontally(final JSplitPane splitPane, final int location) {
        return GuiActionRunner.execute(new GuiQuery<GenericRange<Point>>(){

            @Override
            protected GenericRange<Point> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(splitPane);
                return JSplitPaneDriver.whereToMoveDividerHorizontally(splitPane, location);
            }
        });
    }

    @RunsInCurrentThread
    private static GenericRange<Point> whereToMoveDividerHorizontally(JSplitPane splitPane, int location) {
        int y = splitPane.getHeight() / 2;
        int dividerLocation = splitPane.getDividerLocation();
        return new GenericRange<Point>(new Point(dividerLocation, y), new Point(location, y));
    }

    @RunsInEDT
    private void simulateMovingDivider(JSplitPane splitPane, GenericRange<Point> range) {
        try {
            this.robot.moveMouse(splitPane, (Point)range.from);
            this.robot.pressMouse(MouseButton.LEFT_BUTTON);
            this.robot.moveMouse(splitPane, (Point)range.to);
            this.robot.releaseMouse(MouseButton.LEFT_BUTTON);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

