--!A cross-platform build utility based on Lua
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--     http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
--
-- Copyright (C) 2015-present, TBOOX Open Source Group.
--
-- @author      ruki
-- @file        deprecated.lua
--

-- define module
local deprecated = deprecated or {}

-- add deprecated entry
function deprecated.add(newformat, oldformat, ...)

    local utils = require("base/utils")
    local old = string.format(oldformat, ...)
    local new = newformat and string.format(newformat, ...) or false
    if new then
        utils.warning("%s is deprecated, please uses %s instead of it", old, new)
    else
        utils.warning("%s is deprecated, please remove it", old)
    end
end

-- return module
return deprecated
