#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""Tests for the Windows shell items parser."""

import unittest

from plaso.parsers.shared import shell_items

from tests.parsers import test_lib


class ShellItemsParserTest(test_lib.ParserTestCase):
  """Tests for the Windows shell items parser."""

  _TEST_DATA = bytes(bytearray([
      0x14, 0x00, 0x1f, 0x50, 0xe0, 0x4f, 0xd0, 0x20, 0xea, 0x3a, 0x69, 0x10,
      0xa2, 0xd8, 0x08, 0x00, 0x2b, 0x30, 0x30, 0x9d, 0x19, 0x00, 0x2f, 0x43,
      0x3a, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0x00, 0x31,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x3c, 0xaa, 0xab, 0x11, 0x00, 0x50,
      0x52, 0x4f, 0x47, 0x52, 0x41, 0x7e, 0x32, 0x00, 0x00, 0x7c, 0x00, 0x08,
      0x00, 0x04, 0x00, 0xef, 0xbe, 0xee, 0x3a, 0x85, 0x1a, 0x3d, 0x3c, 0xaa,
      0xab, 0x2a, 0x00, 0x00, 0x00, 0x12, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x67, 0x00, 0x72,
      0x00, 0x61, 0x00, 0x6d, 0x00, 0x20, 0x00, 0x46, 0x00, 0x69, 0x00, 0x6c,
      0x00, 0x65, 0x00, 0x73, 0x00, 0x20, 0x00, 0x28, 0x00, 0x78, 0x00, 0x38,
      0x00, 0x36, 0x00, 0x29, 0x00, 0x00, 0x00, 0x40, 0x00, 0x73, 0x00, 0x68,
      0x00, 0x65, 0x00, 0x6c, 0x00, 0x6c, 0x00, 0x33, 0x00, 0x32, 0x00, 0x2e,
      0x00, 0x64, 0x00, 0x6c, 0x00, 0x6c, 0x00, 0x2c, 0x00, 0x2d, 0x00, 0x32,
      0x00, 0x31, 0x00, 0x38, 0x00, 0x31, 0x00, 0x37, 0x00, 0x00, 0x00, 0x18,
      0x00, 0x4a, 0x00, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x3c, 0xaa,
      0xab, 0x10, 0x00, 0x4e, 0x65, 0x72, 0x6f, 0x00, 0x00, 0x36, 0x00, 0x08,
      0x00, 0x04, 0x00, 0xef, 0xbe, 0x3d, 0x3c, 0xaa, 0xab, 0x3d, 0x3c, 0xaa,
      0xab, 0x2a, 0x00, 0x00, 0x00, 0xcb, 0x39, 0x01, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x4e, 0x00, 0x65, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x00,
      0x00, 0x14, 0x00, 0x50, 0x00, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d,
      0x3c, 0xc6, 0xab, 0x10, 0x00, 0x4e, 0x45, 0x52, 0x4f, 0x39, 0x7e, 0x31,
      0x00, 0x3a, 0x00, 0x08, 0x00, 0x04, 0x00, 0xef, 0xbe, 0x3d, 0x3c, 0xaa,
      0xab, 0x3d, 0x3c, 0xc6, 0xab, 0x2a, 0x00, 0x00, 0x00, 0xcc, 0x39, 0x01,
      0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0x00, 0x65, 0x00, 0x72,
      0x00, 0x6f, 0x00, 0x20, 0x00, 0x39, 0x00, 0x00, 0x00, 0x16, 0x00, 0x60,
      0x00, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x3c, 0xc6, 0xab, 0x10,
      0x00, 0x4e, 0x45, 0x52, 0x4f, 0x49, 0x4e, 0x7e, 0x31, 0x00, 0x00, 0x48,
      0x00, 0x08, 0x00, 0x04, 0x00, 0xef, 0xbe, 0x3d, 0x3c, 0xc6, 0xab, 0x3d,
      0x3c, 0xc6, 0xab, 0x2a, 0x00, 0x00, 0x00, 0xc1, 0x3d, 0x01, 0x00, 0x00,
      0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0x00, 0x65, 0x00, 0x72, 0x00, 0x6f,
      0x00, 0x20, 0x00, 0x49, 0x00, 0x6e, 0x00, 0x66, 0x00, 0x6f, 0x00, 0x54,
      0x00, 0x6f, 0x00, 0x6f, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x18, 0x00, 0x62,
      0x00, 0x32, 0x00, 0x18, 0xba, 0x46, 0x00, 0xc5, 0x3a, 0xaa, 0xa1, 0x20,
      0x00, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x65, 0x78,
      0x65, 0x00, 0x00, 0x46, 0x00, 0x08, 0x00, 0x04, 0x00, 0xef, 0xbe, 0xc5,
      0x3a, 0xaa, 0xa1, 0x3d, 0x3c, 0xc6, 0xab, 0x2a, 0x00, 0x00, 0x00, 0xc5,
      0x3d, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x00, 0x6e,
      0x00, 0x66, 0x00, 0x6f, 0x00, 0x54, 0x00, 0x6f, 0x00, 0x6f, 0x00, 0x6c,
      0x00, 0x2e, 0x00, 0x65, 0x00, 0x78, 0x00, 0x65, 0x00, 0x00, 0x00, 0x1c,
      0x00, 0x00, 0x00]))

  # TODO: add tests for _GetDateTime
  # TODO: add tests for _GetSanitizedPathString
  # TODO: add tests for _ParseShellItem
  # TODO: add tests for _ParseShellItemPathSegment
  # TODO: add tests for CopyToPath
  # TODO: add tests for GetUpperPathSegment

  def testParseByteStream(self):
    """Tests the ParseByteStream function."""
    storage_writer = self._CreateStorageWriter()
    parser_mediator = self._CreateParserMediator(storage_writer)

    parser = shell_items.ShellItemsParser('test_origin')
    parser.ParseByteStream(parser_mediator, self._TEST_DATA)

    number_of_event_data = storage_writer.GetNumberOfAttributeContainers(
        'event_data')
    self.assertEqual(number_of_event_data, 5)

    number_of_warnings = storage_writer.GetNumberOfAttributeContainers(
        'extraction_warning')
    self.assertEqual(number_of_warnings, 0)

    number_of_warnings = storage_writer.GetNumberOfAttributeContainers(
        'recovery_warning')
    self.assertEqual(number_of_warnings, 0)

    expected_shell_item_path = (
        '<My Computer> C:\\\\Program Files (x86)\\\\Nero\\\\Nero 9\\\\'
        'Nero InfoTool\\\\InfoTool.exe')

    shell_item_path = parser.CopyToPath()
    self.assertEqual(shell_item_path, expected_shell_item_path)

    path_segment = parser.GetUpperPathSegment()
    self.assertEqual(path_segment, 'InfoTool.exe')


if __name__ == '__main__':
  unittest.main()
