; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; Previously a call to @llvm.trap() with following code would cause machine
; verifier issues on MIPS (as TRAP was marked as being a terminator).
; This compiles fine on other architectures, so check we do the same for MIPS.
; RUN: llc -mtriple=mips64-unknown-freebsd -relocation-model=pic -verify-machineinstrs %s -o - | FileCheck %s


declare void @llvm.trap() #0
declare void @widget() #1
define hidden void @eggs() #1 {
; CHECK-LABEL: eggs:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    daddiu $sp, $sp, -16
; CHECK-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd $gp, 0($sp) # 8-byte Folded Spill
; CHECK-NEXT:    lui $1, %hi(%neg(%gp_rel(eggs)))
; CHECK-NEXT:    daddu $1, $1, $25
; CHECK-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(eggs)))
; CHECK-NEXT:    break
; CHECK-NEXT:    ld $25, %call16(widget)($gp)
; CHECK-NEXT:    .reloc .Ltmp0, R_MIPS_JALR, widget
; CHECK-NEXT:  .Ltmp0:
; CHECK-NEXT:    jalr $25
; CHECK-NEXT:    nop
entry:
  call void @llvm.trap()
  call void @widget() #2
  unreachable
}

attributes #0 = { cold noreturn nounwind }
attributes #1 = { nounwind "use-soft-float"="true" }
attributes #2 = { noreturn }
