% GLULXE(1) John Goerzen | Debian Manuals
% Andrew Plotkin, John Goerzen
% October 2019

# NAME

glulxe - execute Glulx interactive fiction

# SYNOPSIS

**glulxe** *filename* [ *options* ]

# OVERVIEW

**glulxe** executes Glulx-format interactive fiction games, which
typically end with .ulx, .gblorb, .glb, .blorb, or .blb.  glulxe
can work with only a terminal.

The only required parameter is the filename of the game to play.  The
remaining parameters are all optional, and come from the glktermw library.
Further information can be found in the libglktermw-dev package in the
directory /usr/share/doc/libglktermw-dev.

# OPTIONS

**-width** *NUM*, **-height** *NUM*
:  Sets the screen width or height.  Normally automatically determined.

**-ml** *BOOL*
:  Enables or disables a message line (default "yes").  This is the bottom line
   of the screen.
   
**-revgrid** *BOOL*
:  Reverse text in grid (status) windows (default "no").

**-historylen** *NUM*
:  Sets the number of commands to keep in the history for each window (default 20).

**-border** *BOOL*
:  Whether or not to force one-character borders between windows.
   The default turns on borders unless the game switches them off.
   Setting to "yes" forces them on at all times, or "no" forces them
   off at all times, ignoring the game's request.
   
**-precise** *BOOL*
:  Whether to use more precise timing for timed input (default "no").

**-version**
:  Display Glk library version.

**-help**
:  Display command-line help.

# ABOUT

glulxe was written by Andrew Plotkin <erkyrath@eblong.com> and can be found at
<https://www.eblong.com/zarf/glulx/>.  glktermw was written by Andrew Plotkin <erkyrath@eblong.com>
and Alexander Beels <arb28@columbia.edu> and can be found at
<https://www.eblong.com/zarf/glk/index.html>.

This manpage was written for Debian by John Goerzen <jgoerzen@complete.org> based
on information in the above locations.
