// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System.Diagnostics;

namespace Aspire.Hosting.ApplicationModel;

/// <summary>
/// Represents an annotation for a container image.
/// </summary>
[DebuggerDisplay("Type = {GetType().Name,nq}, Image = {Image}, Tag = {Tag}, SHA256 = {SHA256}")]
public sealed class ContainerImageAnnotation : IResourceAnnotation
{
    private string? _tag;
    private string? _sha256;

    /// <summary>
    /// Gets or sets the registry for the container image.
    /// </summary>
    public string? Registry { get; set; }

    /// <summary>
    /// Gets or sets the image for the container.
    /// </summary>
    public required string Image { get; set; }

    /// <summary>
    /// Gets or sets the tag for the container image.
    /// </summary>
    public string? Tag
    {
        get
        {
            return _tag;
        }

        set
        {
            // These two properties are mutually exclusive.
            _tag = value;
            _sha256 = null;
        }
    }

    /// <summary>
    /// Gets or sets the SHA256 for the specific image.
    /// </summary>
    public string? SHA256
    {
        get
        {
            return _sha256;
        }

        set
        {
            _sha256 = value;
            _tag = null;
        }
    }
}
