// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System.Diagnostics;

#pragma warning disable SA1001

// This file contains the handling of Windows OS specific culture features.

namespace System.Globalization
{
    internal enum IcuLocaleDataParts
    {
        Lcid = 0,
        AnsiCodePage = 1,
        OemCodePage = 2,
        MacCodePage = 3,
        EbcdicCodePage = 4,
        GeoId = 5,
        DigitSubstitutionOrListSeparator = 6,
        SpecificLocaleIndex = 7,
        ConsoleLocaleIndex = 8
    }

    internal static partial class IcuLocaleData
    {
        private static ReadOnlySpan<byte> CultureNames =>
            "aa-dj"u8 +  // aa, aa-dj
            "aa-er"u8 +  // aa-er
            "aa-et"u8 +  // aa-et
            "af-na"u8 +  // af, af-na
            "af-za"u8 +  // af-za
            "agq-cm"u8 +  // agq, agq-cm
            "ak-gh"u8 +  // ak, ak-gh
            "am-et"u8 +  // am, am-et
            "ar-001"u8 +  // ar, ar-001
            "ar-ae"u8 +  // ar-ae
            "ar-bh"u8 +  // ar-bh
            "ar-dj"u8 +  // ar-dj
            "ar-dz"u8 +  // ar-dz
            "ar-eg"u8 +  // ar-eg
            "ar-er"u8 +  // ar-er
            "ar-il"u8 +  // ar-il
            "ar-iq"u8 +  // ar-iq
            "ar-jo"u8 +  // ar-jo
            "ar-km"u8 +  // ar-km
            "ar-kw"u8 +  // ar-kw
            "ar-lb"u8 +  // ar-lb
            "ar-ly"u8 +  // ar-ly
            "ar-ma"u8 +  // ar-ma
            "ar-mr"u8 +  // ar-mr
            "ar-om"u8 +  // ar-om
            "ar-ps"u8 +  // ar-ps
            "ar-qa"u8 +  // ar-qa
            "ar-sa"u8 +  // ar-sa
            "ar-sd"u8 +  // ar-sd
            "ar-so"u8 +  // ar-so
            "ar-ss"u8 +  // ar-ss
            "ar-sy"u8 +  // ar-sy
            "ar-td"u8 +  // ar-td
            "ar-tn"u8 +  // ar-tn
            "ar-ye"u8 +  // ar-ye
            "arn-cl"u8 +  // arn, arn-cl
            "as-in"u8 +  // as, as-in
            "asa-tz"u8 +  // asa, asa-tz
            "ast-es"u8 +  // ast, ast-es
            "az-cyrl-az"u8 +  // az, az-cyrl, az-cyrl-az
            "az-latn-az"u8 +  // az-latn, az-latn-az
            "ba-ru"u8 +  // ba, ba-ru
            "bas-cm"u8 +  // bas, bas-cm
            "be-by"u8 +  // be, be-by
            "bem-zm"u8 +  // bem, bem-zm
            "bez-tz"u8 +  // bez, bez-tz
            "bg-bg"u8 +  // bg, bg-bg
            "bin-ng"u8 +  // bin, bin-ng
            "bm-latn-ml"u8 +  // bm, bm-latn, bm-latn-ml
            "bn-bd"u8 +  // bn, bn-bd
            "bn-in"u8 +  // bn-in
            "bo-cn"u8 +  // bo, bo-cn
            "bo-in"u8 +  // bo-in
            "br-fr"u8 +  // br, br-fr
            "brx-in"u8 +  // brx, brx-in
            "bs-cyrl-ba"u8 +  // bs, bs-cyrl, bs-cyrl-ba
            "bs-latn-ba"u8 +  // bs-latn, bs-latn-ba
            "byn-er"u8 +  // byn, byn-er
            "ca-ad"u8 +  // ca, ca-ad
            "ca-es-valencia"u8 +  // ca-es, ca-es-valencia
            "ca-fr"u8 +  // ca-fr
            "ca-it"u8 +  // ca-it
            "ce-ru"u8 +  // ce, ce-ru
            "cgg-ug"u8 +  // cgg, cgg-ug
            "chr-cher-us"u8 +  // chr, chr-cher, chr-cher-us
            "co-fr"u8 +  // co, co-fr
            "cs-cz"u8 +  // cs, cs-cz
            "cu-ru"u8 +  // cu, cu-ru
            "cy-gb"u8 +  // cy, cy-gb
            "da-dk"u8 +  // da, da-dk
            "da-gl"u8 +  // da-gl
            "dav-ke"u8 +  // dav, dav-ke
            "de-at"u8 +  // de, de-at
            "de-be"u8 +  // de-be
            "de-ch"u8 +  // de-ch
            "de-de_phoneb"u8 +  // de-de, de-de_phoneb
            "de-it"u8 +  // de-it
            "de-li"u8 +  // de-li
            "de-lu"u8 +  // de-lu
            "dje-ne"u8 +  // dje, dje-ne
            "dsb-de"u8 +  // dsb, dsb-de
            "dua-cm"u8 +  // dua, dua-cm
            "dv-mv"u8 +  // dv, dv-mv
            "dyo-sn"u8 +  // dyo, dyo-sn
            "dz-bt"u8 +  // dz, dz-bt
            "ebu-ke"u8 +  // ebu, ebu-ke
            "ee-gh"u8 +  // ee, ee-gh
            "ee-tg"u8 +  // ee-tg
            "el-cy"u8 +  // el, el-cy
            "el-gr"u8 +  // el-gr
            "en-001"u8 +  // en, en-001
            "en-029"u8 +  // en-029
            "en-150"u8 +  // en-150
            "en-ag"u8 +  // en-ag
            "en-ai"u8 +  // en-ai
            "en-as"u8 +  // en-as
            "en-at"u8 +  // en-at
            "en-au"u8 +  // en-au
            "en-bb"u8 +  // en-bb
            "en-be"u8 +  // en-be
            "en-bi"u8 +  // en-bi
            "en-bm"u8 +  // en-bm
            "en-bs"u8 +  // en-bs
            "en-bw"u8 +  // en-bw
            "en-bz"u8 +  // en-bz
            "en-ca"u8 +  // en-ca
            "en-cc"u8 +  // en-cc
            "en-ch"u8 +  // en-ch
            "en-ck"u8 +  // en-ck
            "en-cm"u8 +  // en-cm
            "en-cx"u8 +  // en-cx
            "en-cy"u8 +  // en-cy
            "en-de"u8 +  // en-de
            "en-dk"u8 +  // en-dk
            "en-dm"u8 +  // en-dm
            "en-er"u8 +  // en-er
            "en-fi"u8 +  // en-fi
            "en-fj"u8 +  // en-fj
            "en-fk"u8 +  // en-fk
            "en-fm"u8 +  // en-fm
            "en-gb"u8 +  // en-gb
            "en-gd"u8 +  // en-gd
            "en-gg"u8 +  // en-gg
            "en-gh"u8 +  // en-gh
            "en-gi"u8 +  // en-gi
            "en-gm"u8 +  // en-gm
            "en-gu"u8 +  // en-gu
            "en-gy"u8 +  // en-gy
            "en-hk"u8 +  // en-hk
            "en-id"u8 +  // en-id
            "en-ie"u8 +  // en-ie
            "en-il"u8 +  // en-il
            "en-im"u8 +  // en-im
            "en-in"u8 +  // en-in
            "en-io"u8 +  // en-io
            "en-je"u8 +  // en-je
            "en-jm"u8 +  // en-jm
            "en-ke"u8 +  // en-ke
            "en-ki"u8 +  // en-ki
            "en-kn"u8 +  // en-kn
            "en-ky"u8 +  // en-ky
            "en-lc"u8 +  // en-lc
            "en-lr"u8 +  // en-lr
            "en-ls"u8 +  // en-ls
            "en-mg"u8 +  // en-mg
            "en-mh"u8 +  // en-mh
            "en-mo"u8 +  // en-mo
            "en-mp"u8 +  // en-mp
            "en-ms"u8 +  // en-ms
            "en-mt"u8 +  // en-mt
            "en-mu"u8 +  // en-mu
            "en-mw"u8 +  // en-mw
            "en-my"u8 +  // en-my
            "en-na"u8 +  // en-na
            "en-nf"u8 +  // en-nf
            "en-ng"u8 +  // en-ng
            "en-nl"u8 +  // en-nl
            "en-nr"u8 +  // en-nr
            "en-nu"u8 +  // en-nu
            "en-nz"u8 +  // en-nz
            "en-pg"u8 +  // en-pg
            "en-ph"u8 +  // en-ph
            "en-pk"u8 +  // en-pk
            "en-pn"u8 +  // en-pn
            "en-pr"u8 +  // en-pr
            "en-pw"u8 +  // en-pw
            "en-rw"u8 +  // en-rw
            "en-sb"u8 +  // en-sb
            "en-sc"u8 +  // en-sc
            "en-sd"u8 +  // en-sd
            "en-se"u8 +  // en-se
            "en-sg"u8 +  // en-sg
            "en-sh"u8 +  // en-sh
            "en-si"u8 +  // en-si
            "en-sl"u8 +  // en-sl
            "en-ss"u8 +  // en-ss
            "en-sx"u8 +  // en-sx
            "en-sz"u8 +  // en-sz
            "en-tc"u8 +  // en-tc
            "en-tk"u8 +  // en-tk
            "en-to"u8 +  // en-to
            "en-tt"u8 +  // en-tt
            "en-tv"u8 +  // en-tv
            "en-tz"u8 +  // en-tz
            "en-ug"u8 +  // en-ug
            "en-um"u8 +  // en-um
            "en-us"u8 +  // en-us
            "en-vc"u8 +  // en-vc
            "en-vg"u8 +  // en-vg
            "en-vi"u8 +  // en-vi
            "en-vu"u8 +  // en-vu
            "en-ws"u8 +  // en-ws
            "en-za"u8 +  // en-za
            "en-zm"u8 +  // en-zm
            "en-zw"u8 +  // en-zw
            "eo-001"u8 +  // eo, eo-001
            "es-419"u8 +  // es, es-419
            "es-ar"u8 +  // es-ar
            "es-bo"u8 +  // es-bo
            "es-br"u8 +  // es-br
            "es-cl"u8 +  // es-cl
            "es-co"u8 +  // es-co
            "es-cr"u8 +  // es-cr
            "es-cu"u8 +  // es-cu
            "es-do"u8 +  // es-do
            "es-ec"u8 +  // es-ec
            "es-es_tradnl"u8 +  // es-es, es-es_tradnl
            "es-gq"u8 +  // es-gq
            "es-gt"u8 +  // es-gt
            "es-hn"u8 +  // es-hn
            "es-mx"u8 +  // es-mx
            "es-ni"u8 +  // es-ni
            "es-pa"u8 +  // es-pa
            "es-pe"u8 +  // es-pe
            "es-ph"u8 +  // es-ph
            "es-pr"u8 +  // es-pr
            "es-py"u8 +  // es-py
            "es-sv"u8 +  // es-sv
            "es-us"u8 +  // es-us
            "es-uy"u8 +  // es-uy
            "es-ve"u8 +  // es-ve
            "et-ee"u8 +  // et, et-ee
            "eu-es"u8 +  // eu, eu-es
            "ewo-cm"u8 +  // ewo, ewo-cm
            "fa-ir"u8 +  // fa, fa-ir
            "ff-cm"u8 +  // ff, ff-cm
            "ff-gn"u8 +  // ff-gn
            "ff-latn-sn"u8 +  // ff-latn, ff-latn-sn
            "ff-mr"u8 +  // ff-mr
            "ff-ng"u8 +  // ff-ng
            "fi-fi"u8 +  // fi, fi-fi
            "fil-ph"u8 +  // fil, fil-ph
            "fo-dk"u8 +  // fo, fo-dk
            "fo-fo"u8 +  // fo-fo
            "fr-029"u8 +  // fr, fr-029
            "fr-be"u8 +  // fr-be
            "fr-bf"u8 +  // fr-bf
            "fr-bi"u8 +  // fr-bi
            "fr-bj"u8 +  // fr-bj
            "fr-bl"u8 +  // fr-bl
            "fr-ca"u8 +  // fr-ca
            "fr-cd"u8 +  // fr-cd
            "fr-cf"u8 +  // fr-cf
            "fr-cg"u8 +  // fr-cg
            "fr-ch"u8 +  // fr-ch
            "fr-ci"u8 +  // fr-ci
            "fr-cm"u8 +  // fr-cm
            "fr-dj"u8 +  // fr-dj
            "fr-dz"u8 +  // fr-dz
            "fr-fr"u8 +  // fr-fr
            "fr-ga"u8 +  // fr-ga
            "fr-gf"u8 +  // fr-gf
            "fr-gn"u8 +  // fr-gn
            "fr-gp"u8 +  // fr-gp
            "fr-gq"u8 +  // fr-gq
            "fr-ht"u8 +  // fr-ht
            "fr-km"u8 +  // fr-km
            "fr-lu"u8 +  // fr-lu
            "fr-ma"u8 +  // fr-ma
            "fr-mc"u8 +  // fr-mc
            "fr-mf"u8 +  // fr-mf
            "fr-mg"u8 +  // fr-mg
            "fr-ml"u8 +  // fr-ml
            "fr-mq"u8 +  // fr-mq
            "fr-mr"u8 +  // fr-mr
            "fr-mu"u8 +  // fr-mu
            "fr-nc"u8 +  // fr-nc
            "fr-ne"u8 +  // fr-ne
            "fr-pf"u8 +  // fr-pf
            "fr-pm"u8 +  // fr-pm
            "fr-re"u8 +  // fr-re
            "fr-rw"u8 +  // fr-rw
            "fr-sc"u8 +  // fr-sc
            "fr-sn"u8 +  // fr-sn
            "fr-sy"u8 +  // fr-sy
            "fr-td"u8 +  // fr-td
            "fr-tg"u8 +  // fr-tg
            "fr-tn"u8 +  // fr-tn
            "fr-vu"u8 +  // fr-vu
            "fr-wf"u8 +  // fr-wf
            "fr-yt"u8 +  // fr-yt
            "fur-it"u8 +  // fur, fur-it
            "fy-nl"u8 +  // fy, fy-nl
            "ga-ie"u8 +  // ga, ga-ie
            "gd-gb"u8 +  // gd, gd-gb
            "gl-es"u8 +  // gl, gl-es
            "gn-py"u8 +  // gn, gn-py
            "gsw-ch"u8 +  // gsw, gsw-ch
            "gsw-fr"u8 +  // gsw-fr
            "gsw-li"u8 +  // gsw-li
            "gu-in"u8 +  // gu, gu-in
            "guz-ke"u8 +  // guz, guz-ke
            "gv-im"u8 +  // gv, gv-im
            "ha-latn-gh"u8 +  // ha, ha-latn, ha-latn-gh
            "ha-latn-ne"u8 +  // ha-latn-ne
            "ha-latn-ng"u8 +  // ha-latn-ng
            "haw-us"u8 +  // haw, haw-us
            "he-il"u8 +  // he, he-il
            "hi-in"u8 +  // hi, hi-in
            "hr-ba"u8 +  // hr, hr-ba
            "hr-hr"u8 +  // hr-hr
            "hsb-de"u8 +  // hsb, hsb-de
            "hu-hu_technl"u8 +  // hu, hu-hu, hu-hu_technl
            "hy-am"u8 +  // hy, hy-am
            "ia-001"u8 +  // ia, ia-001
            "ia-fr"u8 +  // ia-fr
            "ibb-ng"u8 +  // ibb, ibb-ng
            "id-id"u8 +  // id, id-id
            "ig-ng"u8 +  // ig, ig-ng
            "ii-cn"u8 +  // ii, ii-cn
            "is-is"u8 +  // is, is-is
            "it-ch"u8 +  // it, it-ch
            "it-it"u8 +  // it-it
            "it-sm"u8 +  // it-sm
            "iu-cans-ca"u8 +  // iu, iu-cans, iu-cans-ca
            "iu-latn-ca"u8 +  // iu-latn, iu-latn-ca
            "ja-jp_radstr"u8 +  // ja, ja-jp, ja-jp_radstr
            "jgo-cm"u8 +  // jgo, jgo-cm
            "jmc-tz"u8 +  // jmc, jmc-tz
            "jv-java-id"u8 +  // jv, jv-java, jv-java-id
            "jv-latn-id"u8 +  // jv-latn, jv-latn-id
            "ka-ge_modern"u8 +  // ka, ka-ge, ka-ge_modern
            "kab-dz"u8 +  // kab, kab-dz
            "kam-ke"u8 +  // kam, kam-ke
            "kde-tz"u8 +  // kde, kde-tz
            "kea-cv"u8 +  // kea, kea-cv
            "khq-ml"u8 +  // khq, khq-ml
            "ki-ke"u8 +  // ki, ki-ke
            "kk-kz"u8 +  // kk, kk-kz
            "kkj-cm"u8 +  // kkj, kkj-cm
            "kl-gl"u8 +  // kl, kl-gl
            "kln-ke"u8 +  // kln, kln-ke
            "km-kh"u8 +  // km, km-kh
            "kn-in"u8 +  // kn, kn-in
            "ko-kp"u8 +  // ko, ko-kp
            "ko-kr"u8 +  // ko-kr
            "kok-in"u8 +  // kok, kok-in
            "kr-ng"u8 +  // kr, kr-ng
            "ks-arab-in"u8 +  // ks, ks-arab, ks-arab-in
            "ks-deva-in"u8 +  // ks-deva, ks-deva-in
            "ksb-tz"u8 +  // ksb, ksb-tz
            "ksf-cm"u8 +  // ksf, ksf-cm
            "ksh-de"u8 +  // ksh, ksh-de
            "ku-arab-iq"u8 +  // ku, ku-arab, ku-arab-iq
            "ku-arab-ir"u8 +  // ku-arab-ir
            "kw-gb"u8 +  // kw, kw-gb
            "ky-kg"u8 +  // ky, ky-kg
            "la-001"u8 +  // la, la-001
            "lag-tz"u8 +  // lag, lag-tz
            "lb-lu"u8 +  // lb, lb-lu
            "lg-ug"u8 +  // lg, lg-ug
            "lkt-us"u8 +  // lkt, lkt-us
            "ln-ao"u8 +  // ln, ln-ao
            "ln-cd"u8 +  // ln-cd
            "ln-cf"u8 +  // ln-cf
            "ln-cg"u8 +  // ln-cg
            "lo-la"u8 +  // lo, lo-la
            "lrc-iq"u8 +  // lrc, lrc-iq
            "lrc-ir"u8 +  // lrc-ir
            "lt-lt"u8 +  // lt, lt-lt
            "lu-cd"u8 +  // lu, lu-cd
            "luo-ke"u8 +  // luo, luo-ke
            "luy-ke"u8 +  // luy, luy-ke
            "lv-lv"u8 +  // lv, lv-lv
            "mas-ke"u8 +  // mas, mas-ke
            "mas-tz"u8 +  // mas-tz
            "mer-ke"u8 +  // mer, mer-ke
            "mfe-mu"u8 +  // mfe, mfe-mu
            "mg-mg"u8 +  // mg, mg-mg
            "mgh-mz"u8 +  // mgh, mgh-mz
            "mgo-cm"u8 +  // mgo, mgo-cm
            "mi-nz"u8 +  // mi, mi-nz
            "mk-mk"u8 +  // mk, mk-mk
            "ml-in"u8 +  // ml, ml-in
            "mn-cyrl"u8 +  // mn, mn-cyrl
            "mn-mn"u8 +  // mn-mn
            "mn-mong-cn"u8 +  // mn-mong, mn-mong-cn
            "mn-mong-mn"u8 +  // mn-mong-mn
            "mni-in"u8 +  // mni, mni-in
            "moh-ca"u8 +  // moh, moh-ca
            "mr-in"u8 +  // mr, mr-in
            "ms-bn"u8 +  // ms, ms-bn
            "ms-my"u8 +  // ms-my
            "ms-sg"u8 +  // ms-sg
            "mt-mt"u8 +  // mt, mt-mt
            "mua-cm"u8 +  // mua, mua-cm
            "my-mm"u8 +  // my, my-mm
            "mzn-ir"u8 +  // mzn, mzn-ir
            "naq-na"u8 +  // naq, naq-na
            "nb-no"u8 +  // nb, nb-no
            "nb-sj"u8 +  // nb-sj
            "nd-zw"u8 +  // nd, nd-zw
            "nds-de"u8 +  // nds, nds-de
            "nds-nl"u8 +  // nds-nl
            "ne-in"u8 +  // ne, ne-in
            "ne-np"u8 +  // ne-np
            "nl-aw"u8 +  // nl, nl-aw
            "nl-be"u8 +  // nl-be
            "nl-bq"u8 +  // nl-bq
            "nl-cw"u8 +  // nl-cw
            "nl-nl"u8 +  // nl-nl
            "nl-sr"u8 +  // nl-sr
            "nl-sx"u8 +  // nl-sx
            "nmg-cm"u8 +  // nmg, nmg-cm
            "nn-no"u8 +  // nn, nn-no
            "nnh-cm"u8 +  // nnh, nnh-cm
            "no"u8 +  // no
            "nqo-gn"u8 +  // nqo, nqo-gn
            "nr-za"u8 +  // nr, nr-za
            "nso-za"u8 +  // nso, nso-za
            "nus-ss"u8 +  // nus, nus-ss
            "nyn-ug"u8 +  // nyn, nyn-ug
            "oc-fr"u8 +  // oc, oc-fr
            "om-et"u8 +  // om, om-et
            "om-ke"u8 +  // om-ke
            "or-in"u8 +  // or, or-in
            "os-ge"u8 +  // os, os-ge
            "os-ru"u8 +  // os-ru
            "pa-arab-pk"u8 +  // pa, pa-arab, pa-arab-pk
            "pa-in"u8 +  // pa-in
            "pap-029"u8 +  // pap, pap-029
            "pl-pl"u8 +  // pl, pl-pl
            "prg-001"u8 +  // prg, prg-001
            "prs-af"u8 +  // prs, prs-af
            "ps-af"u8 +  // ps, ps-af
            "pt-ao"u8 +  // pt, pt-ao
            "pt-br"u8 +  // pt-br
            "pt-ch"u8 +  // pt-ch
            "pt-cv"u8 +  // pt-cv
            "pt-gq"u8 +  // pt-gq
            "pt-gw"u8 +  // pt-gw
            "pt-lu"u8 +  // pt-lu
            "pt-mo"u8 +  // pt-mo
            "pt-mz"u8 +  // pt-mz
            "pt-pt"u8 +  // pt-pt
            "pt-st"u8 +  // pt-st
            "pt-tl"u8 +  // pt-tl
            "qps-latn-x-sh"u8 +  // qps-latn-x-sh
            "qps-ploca"u8 +  // qps-ploc, qps-ploca
            "qps-plocm"u8 +  // qps-plocm
            "quc-latn-gt"u8 +  // quc, quc-latn, quc-latn-gt
            "quz-bo"u8 +  // quz, quz-bo
            "quz-ec"u8 +  // quz-ec
            "quz-pe"u8 +  // quz-pe
            "rm-ch"u8 +  // rm, rm-ch
            "rn-bi"u8 +  // rn, rn-bi
            "ro-md"u8 +  // ro, ro-md
            "ro-ro"u8 +  // ro-ro
            "rof-tz"u8 +  // rof, rof-tz
            "ru-by"u8 +  // ru, ru-by
            "ru-kg"u8 +  // ru-kg
            "ru-kz"u8 +  // ru-kz
            "ru-md"u8 +  // ru-md
            "ru-ru"u8 +  // ru-ru
            "ru-ua"u8 +  // ru-ua
            "rw-rw"u8 +  // rw, rw-rw
            "rwk-tz"u8 +  // rwk, rwk-tz
            "sa-in"u8 +  // sa, sa-in
            "sah-ru"u8 +  // sah, sah-ru
            "saq-ke"u8 +  // saq, saq-ke
            "sbp-tz"u8 +  // sbp, sbp-tz
            "sd-arab-pk"u8 +  // sd, sd-arab, sd-arab-pk
            "sd-deva-in"u8 +  // sd-deva, sd-deva-in
            "se-fi"u8 +  // se, se-fi
            "se-no"u8 +  // se-no
            "se-se"u8 +  // se-se
            "seh-mz"u8 +  // seh, seh-mz
            "ses-ml"u8 +  // ses, ses-ml
            "sg-cf"u8 +  // sg, sg-cf
            "shi-latn-ma"u8 +  // shi, shi-latn, shi-latn-ma
            "shi-tfng-ma"u8 +  // shi-tfng, shi-tfng-ma
            "si-lk"u8 +  // si, si-lk
            "sk-sk"u8 +  // sk, sk-sk
            "sl-si"u8 +  // sl, sl-si
            "sma-no"u8 +  // sma, sma-no
            "sma-se"u8 +  // sma-se
            "smj-no"u8 +  // smj, smj-no
            "smj-se"u8 +  // smj-se
            "smn-fi"u8 +  // smn, smn-fi
            "sms-fi"u8 +  // sms, sms-fi
            "sn-latn-zw"u8 +  // sn, sn-latn, sn-latn-zw
            "so-dj"u8 +  // so, so-dj
            "so-et"u8 +  // so-et
            "so-ke"u8 +  // so-ke
            "so-so"u8 +  // so-so
            "sq-al"u8 +  // sq, sq-al
            "sq-mk"u8 +  // sq-mk
            "sq-xk"u8 +  // sq-xk
            "sr-cyrl-ba"u8 +  // sr, sr-cyrl, sr-cyrl-ba
            "sr-cyrl-cs"u8 +  // sr-cyrl-cs
            "sr-cyrl-me"u8 +  // sr-cyrl-me
            "sr-cyrl-rs"u8 +  // sr-cyrl-rs
            "sr-cyrl-xk"u8 +  // sr-cyrl-xk
            "sr-latn-ba"u8 +  // sr-latn, sr-latn-ba
            "sr-latn-cs"u8 +  // sr-latn-cs
            "sr-latn-me"u8 +  // sr-latn-me
            "sr-latn-rs"u8 +  // sr-latn-rs
            "sr-latn-xk"u8 +  // sr-latn-xk
            "ss-sz"u8 +  // ss, ss-sz
            "ss-za"u8 +  // ss-za
            "ssy-er"u8 +  // ssy, ssy-er
            "st-ls"u8 +  // st, st-ls
            "st-za"u8 +  // st-za
            "sv-ax"u8 +  // sv, sv-ax
            "sv-fi"u8 +  // sv-fi
            "sv-se"u8 +  // sv-se
            "sw-cd"u8 +  // sw, sw-cd
            "sw-ke"u8 +  // sw-ke
            "sw-tz"u8 +  // sw-tz
            "sw-ug"u8 +  // sw-ug
            "swc-cd"u8 +  // swc, swc-cd
            "syr-sy"u8 +  // syr, syr-sy
            "ta-in"u8 +  // ta, ta-in
            "ta-lk"u8 +  // ta-lk
            "ta-my"u8 +  // ta-my
            "ta-sg"u8 +  // ta-sg
            "te-in"u8 +  // te, te-in
            "teo-ke"u8 +  // teo, teo-ke
            "teo-ug"u8 +  // teo-ug
            "tg-cyrl-tj"u8 +  // tg, tg-cyrl, tg-cyrl-tj
            "th-th"u8 +  // th, th-th
            "ti-er"u8 +  // ti, ti-er
            "ti-et"u8 +  // ti-et
            "tig-er"u8 +  // tig, tig-er
            "tk-tm"u8 +  // tk, tk-tm
            "tn-bw"u8 +  // tn, tn-bw
            "tn-za"u8 +  // tn-za
            "to-to"u8 +  // to, to-to
            "tr-cy"u8 +  // tr, tr-cy
            "tr-tr"u8 +  // tr-tr
            "ts-za"u8 +  // ts, ts-za
            "tt-ru"u8 +  // tt, tt-ru
            "twq-ne"u8 +  // twq, twq-ne
            "tzm-arab-ma"u8 +  // tzm, tzm-arab, tzm-arab-ma
            "tzm-latn-dz"u8 +  // tzm-latn, tzm-latn-dz
            "tzm-latn-ma"u8 +  // tzm-latn-ma
            "tzm-tfng-ma"u8 +  // tzm-tfng, tzm-tfng-ma
            "ug-cn"u8 +  // ug, ug-cn
            "uk-ua"u8 +  // uk, uk-ua
            "ur-in"u8 +  // ur, ur-in
            "ur-pk"u8 +  // ur-pk
            "uz-arab-af"u8 +  // uz, uz-arab, uz-arab-af
            "uz-cyrl-uz"u8 +  // uz-cyrl, uz-cyrl-uz
            "uz-latn-uz"u8 +  // uz-latn, uz-latn-uz
            "vai-latn-lr"u8 +  // vai, vai-latn, vai-latn-lr
            "vai-vaii-lr"u8 +  // vai-vaii, vai-vaii-lr
            "ve-za"u8 +  // ve, ve-za
            "vi-vn"u8 +  // vi, vi-vn
            "vo-001"u8 +  // vo, vo-001
            "vun-tz"u8 +  // vun, vun-tz
            "wae-ch"u8 +  // wae, wae-ch
            "wal-et"u8 +  // wal, wal-et
            "wo-sn"u8 +  // wo, wo-sn
            "x-iv_mathan"u8 +  // x-iv_mathan
            "xh-za"u8 +  // xh, xh-za
            "xog-ug"u8 +  // xog, xog-ug
            "yav-cm"u8 +  // yav, yav-cm
            "yi-001"u8 +  // yi, yi-001
            "yo-bj"u8 +  // yo, yo-bj
            "yo-ng"u8 +  // yo-ng
            "yue-hk"u8 +  // yue, yue-hk
            "zgh-tfng-ma"u8 +  // zgh, zgh-tfng, zgh-tfng-ma
            "zh-chs"u8 +  // zh, zh-chs
            "zh-cht"u8 +  // zh-cht
            "zh-cn_phoneb"u8 +  // zh-cn, zh-cn_phoneb
            "zh-cn_stroke"u8 +  // zh-cn_stroke
            "zh-hans-hk"u8 +  // zh-hans, zh-hans-hk
            "zh-hans-mo"u8 +  // zh-hans-mo
            "zh-hant"u8 +  // zh-hant
            "zh-hk_radstr"u8 +  // zh-hk, zh-hk_radstr
            "zh-mo_radstr"u8 +  // zh-mo, zh-mo_radstr
            "zh-mo_stroke"u8 +  // zh-mo_stroke
            "zh-sg_phoneb"u8 +  // zh-sg, zh-sg_phoneb
            "zh-sg_stroke"u8 +  // zh-sg_stroke
            "zh-tw_pronun"u8 +  // zh-tw, zh-tw_pronun
            "zh-tw_radstr"u8 +  // zh-tw_radstr
            "zu-za"u8;  // zu, zu-za

        private const int CulturesCount = 864;

        // Table which holds index into LocalesNames data and length of the string for each locale
        // Values are binary searched and need to be sorted alphabetically
        //
        // value = index << 4 | length
        // byte0 = value >> 8; byte1 = value & 0xff
        private static ReadOnlySpan<byte> LocalesNamesIndexes => // CulturesCount * 2
        [
            0, 2,     // aa
            0, 5,     // aa-dj
            0, 85,    // aa-er
            0, 165,   // aa-et
            0, 242,   // af
            0, 245,   // af-na
            1, 69,    // af-za
            1, 147,   // agq
            1, 150,   // agq-cm
            1, 242,   // ak
            1, 245,   // ak-gh
            2, 66,    // am
            2, 69,    // am-et
            2, 146,   // ar
            2, 150,   // ar-001
            2, 245,   // ar-ae
            3, 69,    // ar-bh
            3, 149,   // ar-dj
            3, 229,   // ar-dz
            4, 53,    // ar-eg
            4, 133,   // ar-er
            4, 213,   // ar-il
            5, 37,    // ar-iq
            5, 117,   // ar-jo
            5, 197,   // ar-km
            6, 21,    // ar-kw
            6, 101,   // ar-lb
            6, 181,   // ar-ly
            7, 5,     // ar-ma
            7, 85,    // ar-mr
            7, 165,   // ar-om
            7, 245,   // ar-ps
            8, 69,    // ar-qa
            8, 149,   // ar-sa
            8, 229,   // ar-sd
            9, 53,    // ar-so
            9, 133,   // ar-ss
            9, 213,   // ar-sy
            10, 37,   // ar-td
            10, 117,  // ar-tn
            10, 197,  // ar-ye
            11, 19,   // arn
            11, 22,   // arn-cl
            11, 114,  // as
            11, 117,  // as-in
            11, 195,  // asa
            11, 198,  // asa-tz
            12, 35,   // ast
            12, 38,   // ast-es
            12, 130,  // az
            12, 135,  // az-cyrl
            12, 138,  // az-cyrl-az
            13, 39,   // az-latn
            13, 42,   // az-latn-az
            13, 194,  // ba
            13, 197,  // ba-ru
            14, 19,   // bas
            14, 22,   // bas-cm
            14, 114,  // be
            14, 117,  // be-by
            14, 195,  // bem
            14, 198,  // bem-zm
            15, 35,   // bez
            15, 38,   // bez-tz
            15, 130,  // bg
            15, 133,  // bg-bg
            15, 211,  // bin
            15, 214,  // bin-ng
            16, 50,   // bm
            16, 55,   // bm-latn
            16, 58,   // bm-latn-ml
            16, 210,  // bn
            16, 213,  // bn-bd
            17, 37,   // bn-in
            17, 114,  // bo
            17, 117,  // bo-cn
            17, 197,  // bo-in
            18, 18,   // br
            18, 21,   // br-fr
            18, 99,   // brx
            18, 102,  // brx-in
            18, 194,  // bs
            18, 199,  // bs-cyrl
            18, 202,  // bs-cyrl-ba
            19, 103,  // bs-latn
            19, 106,  // bs-latn-ba
            20, 3,    // byn
            20, 6,    // byn-er
            20, 98,   // ca
            20, 101,  // ca-ad
            20, 181,  // ca-es
            20, 190,  // ca-es-valencia
            21, 149,  // ca-fr
            21, 229,  // ca-it
            22, 50,   // ce
            22, 53,   // ce-ru
            22, 131,  // cgg
            22, 134,  // cgg-ug
            22, 227,  // chr
            22, 232,  // chr-cher
            22, 235,  // chr-cher-us
            23, 146,  // co
            23, 149,  // co-fr
            23, 226,  // cs
            23, 229,  // cs-cz
            24, 50,   // cu
            24, 53,   // cu-ru
            24, 130,  // cy
            24, 133,  // cy-gb
            24, 210,  // da
            24, 213,  // da-dk
            25, 37,   // da-gl
            25, 115,  // dav
            25, 118,  // dav-ke
            25, 210,  // de
            25, 213,  // de-at
            26, 37,   // de-be
            26, 117,  // de-ch
            26, 197,  // de-de
            26, 204,  // de-de_phoneb
            27, 133,  // de-it
            27, 213,  // de-li
            28, 37,   // de-lu
            28, 115,  // dje
            28, 118,  // dje-ne
            28, 211,  // dsb
            28, 214,  // dsb-de
            29, 51,   // dua
            29, 54,   // dua-cm
            29, 146,  // dv
            29, 149,  // dv-mv
            29, 227,  // dyo
            29, 230,  // dyo-sn
            30, 66,   // dz
            30, 69,   // dz-bt
            30, 147,  // ebu
            30, 150,  // ebu-ke
            30, 242,  // ee
            30, 245,  // ee-gh
            31, 69,   // ee-tg
            31, 146,  // el
            31, 149,  // el-cy
            31, 229,  // el-gr
            32, 50,   // en
            32, 54,   // en-001
            32, 150,  // en-029
            32, 246,  // en-150
            33, 85,   // en-ag
            33, 165,  // en-ai
            33, 245,  // en-as
            34, 69,   // en-at
            34, 149,  // en-au
            34, 229,  // en-bb
            35, 53,   // en-be
            35, 133,  // en-bi
            35, 213,  // en-bm
            36, 37,   // en-bs
            36, 117,  // en-bw
            36, 197,  // en-bz
            37, 21,   // en-ca
            37, 101,  // en-cc
            37, 181,  // en-ch
            38, 5,    // en-ck
            38, 85,   // en-cm
            38, 165,  // en-cx
            38, 245,  // en-cy
            39, 69,   // en-de
            39, 149,  // en-dk
            39, 229,  // en-dm
            40, 53,   // en-er
            40, 133,  // en-fi
            40, 213,  // en-fj
            41, 37,   // en-fk
            41, 117,  // en-fm
            41, 197,  // en-gb
            42, 21,   // en-gd
            42, 101,  // en-gg
            42, 181,  // en-gh
            43, 5,    // en-gi
            43, 85,   // en-gm
            43, 165,  // en-gu
            43, 245,  // en-gy
            44, 69,   // en-hk
            44, 149,  // en-id
            44, 229,  // en-ie
            45, 53,   // en-il
            45, 133,  // en-im
            45, 213,  // en-in
            46, 37,   // en-io
            46, 117,  // en-je
            46, 197,  // en-jm
            47, 21,   // en-ke
            47, 101,  // en-ki
            47, 181,  // en-kn
            48, 5,    // en-ky
            48, 85,   // en-lc
            48, 165,  // en-lr
            48, 245,  // en-ls
            49, 69,   // en-mg
            49, 149,  // en-mh
            49, 229,  // en-mo
            50, 53,   // en-mp
            50, 133,  // en-ms
            50, 213,  // en-mt
            51, 37,   // en-mu
            51, 117,  // en-mw
            51, 197,  // en-my
            52, 21,   // en-na
            52, 101,  // en-nf
            52, 181,  // en-ng
            53, 5,    // en-nl
            53, 85,   // en-nr
            53, 165,  // en-nu
            53, 245,  // en-nz
            54, 69,   // en-pg
            54, 149,  // en-ph
            54, 229,  // en-pk
            55, 53,   // en-pn
            55, 133,  // en-pr
            55, 213,  // en-pw
            56, 37,   // en-rw
            56, 117,  // en-sb
            56, 197,  // en-sc
            57, 21,   // en-sd
            57, 101,  // en-se
            57, 181,  // en-sg
            58, 5,    // en-sh
            58, 85,   // en-si
            58, 165,  // en-sl
            58, 245,  // en-ss
            59, 69,   // en-sx
            59, 149,  // en-sz
            59, 229,  // en-tc
            60, 53,   // en-tk
            60, 133,  // en-to
            60, 213,  // en-tt
            61, 37,   // en-tv
            61, 117,  // en-tz
            61, 197,  // en-ug
            62, 21,   // en-um
            62, 101,  // en-us
            62, 181,  // en-vc
            63, 5,    // en-vg
            63, 85,   // en-vi
            63, 165,  // en-vu
            63, 245,  // en-ws
            64, 69,   // en-za
            64, 149,  // en-zm
            64, 229,  // en-zw
            65, 50,   // eo
            65, 54,   // eo-001
            65, 146,  // es
            65, 150,  // es-419
            65, 245,  // es-ar
            66, 69,   // es-bo
            66, 149,  // es-br
            66, 229,  // es-cl
            67, 53,   // es-co
            67, 133,  // es-cr
            67, 213,  // es-cu
            68, 37,   // es-do
            68, 117,  // es-ec
            68, 197,  // es-es
            68, 204,  // es-es_tradnl
            69, 133,  // es-gq
            69, 213,  // es-gt
            70, 37,   // es-hn
            70, 117,  // es-mx
            70, 197,  // es-ni
            71, 21,   // es-pa
            71, 101,  // es-pe
            71, 181,  // es-ph
            72, 5,    // es-pr
            72, 85,   // es-py
            72, 165,  // es-sv
            72, 245,  // es-us
            73, 69,   // es-uy
            73, 149,  // es-ve
            73, 226,  // et
            73, 229,  // et-ee
            74, 50,   // eu
            74, 53,   // eu-es
            74, 131,  // ewo
            74, 134,  // ewo-cm
            74, 226,  // fa
            74, 229,  // fa-ir
            75, 50,   // ff
            75, 53,   // ff-cm
            75, 133,  // ff-gn
            75, 215,  // ff-latn
            75, 218,  // ff-latn-sn
            76, 117,  // ff-mr
            76, 197,  // ff-ng
            77, 18,   // fi
            77, 21,   // fi-fi
            77, 99,   // fil
            77, 102,  // fil-ph
            77, 194,  // fo
            77, 197,  // fo-dk
            78, 21,   // fo-fo
            78, 98,   // fr
            78, 102,  // fr-029
            78, 197,  // fr-be
            79, 21,   // fr-bf
            79, 101,  // fr-bi
            79, 181,  // fr-bj
            80, 5,    // fr-bl
            80, 85,   // fr-ca
            80, 165,  // fr-cd
            80, 245,  // fr-cf
            81, 69,   // fr-cg
            81, 149,  // fr-ch
            81, 229,  // fr-ci
            82, 53,   // fr-cm
            82, 133,  // fr-dj
            82, 213,  // fr-dz
            83, 37,   // fr-fr
            83, 117,  // fr-ga
            83, 197,  // fr-gf
            84, 21,   // fr-gn
            84, 101,  // fr-gp
            84, 181,  // fr-gq
            85, 5,    // fr-ht
            85, 85,   // fr-km
            85, 165,  // fr-lu
            85, 245,  // fr-ma
            86, 69,   // fr-mc
            86, 149,  // fr-mf
            86, 229,  // fr-mg
            87, 53,   // fr-ml
            87, 133,  // fr-mq
            87, 213,  // fr-mr
            88, 37,   // fr-mu
            88, 117,  // fr-nc
            88, 197,  // fr-ne
            89, 21,   // fr-pf
            89, 101,  // fr-pm
            89, 181,  // fr-re
            90, 5,    // fr-rw
            90, 85,   // fr-sc
            90, 165,  // fr-sn
            90, 245,  // fr-sy
            91, 69,   // fr-td
            91, 149,  // fr-tg
            91, 229,  // fr-tn
            92, 53,   // fr-vu
            92, 133,  // fr-wf
            92, 213,  // fr-yt
            93, 35,   // fur
            93, 38,   // fur-it
            93, 130,  // fy
            93, 133,  // fy-nl
            93, 210,  // ga
            93, 213,  // ga-ie
            94, 34,   // gd
            94, 37,   // gd-gb
            94, 114,  // gl
            94, 117,  // gl-es
            94, 194,  // gn
            94, 197,  // gn-py
            95, 19,   // gsw
            95, 22,   // gsw-ch
            95, 118,  // gsw-fr
            95, 214,  // gsw-li
            96, 50,   // gu
            96, 53,   // gu-in
            96, 131,  // guz
            96, 134,  // guz-ke
            96, 226,  // gv
            96, 229,  // gv-im
            97, 50,   // ha
            97, 55,   // ha-latn
            97, 58,   // ha-latn-gh
            97, 218,  // ha-latn-ne
            98, 122,  // ha-latn-ng
            99, 19,   // haw
            99, 22,   // haw-us
            99, 114,  // he
            99, 117,  // he-il
            99, 194,  // hi
            99, 197,  // hi-in
            100, 18,  // hr
            100, 21,  // hr-ba
            100, 101, // hr-hr
            100, 179, // hsb
            100, 182, // hsb-de
            101, 18,  // hu
            101, 21,  // hu-hu
            101, 28,  // hu-hu_technl
            101, 210, // hy
            101, 213, // hy-am
            102, 34,  // ia
            102, 38,  // ia-001
            102, 133, // ia-fr
            102, 211, // ibb
            102, 214, // ibb-ng
            103, 50,  // id
            103, 53,  // id-id
            103, 130, // ig
            103, 133, // ig-ng
            103, 210, // ii
            103, 213, // ii-cn
            104, 34,  // is
            104, 37,  // is-is
            104, 114, // it
            104, 117, // it-ch
            104, 197, // it-it
            105, 21,  // it-sm
            105, 98,  // iu
            105, 103, // iu-cans
            105, 106, // iu-cans-ca
            106, 7,   // iu-latn
            106, 10,  // iu-latn-ca
            106, 162, // ja
            106, 165, // ja-jp
            106, 172, // ja-jp_radstr
            107, 99,  // jgo
            107, 102, // jgo-cm
            107, 195, // jmc
            107, 198, // jmc-tz
            108, 34,  // jv
            108, 39,  // jv-java
            108, 42,  // jv-java-id
            108, 199, // jv-latn
            108, 202, // jv-latn-id
            109, 98,  // ka
            109, 101, // ka-ge
            109, 108, // ka-ge_modern
            110, 35,  // kab
            110, 38,  // kab-dz
            110, 131, // kam
            110, 134, // kam-ke
            110, 227, // kde
            110, 230, // kde-tz
            111, 67,  // kea
            111, 70,  // kea-cv
            111, 163, // khq
            111, 166, // khq-ml
            112, 2,   // ki
            112, 5,   // ki-ke
            112, 82,  // kk
            112, 85,  // kk-kz
            112, 163, // kkj
            112, 166, // kkj-cm
            113, 2,   // kl
            113, 5,   // kl-gl
            113, 83,  // kln
            113, 86,  // kln-ke
            113, 178, // km
            113, 181, // km-kh
            114, 2,   // kn
            114, 5,   // kn-in
            114, 82,  // ko
            114, 85,  // ko-kp
            114, 165, // ko-kr
            114, 243, // kok
            114, 246, // kok-in
            115, 82,  // kr
            115, 85,  // kr-ng
            115, 162, // ks
            115, 167, // ks-arab
            115, 170, // ks-arab-in
            116, 71,  // ks-deva
            116, 74,  // ks-deva-in
            116, 227, // ksb
            116, 230, // ksb-tz
            117, 67,  // ksf
            117, 70,  // ksf-cm
            117, 163, // ksh
            117, 166, // ksh-de
            118, 2,   // ku
            118, 7,   // ku-arab
            118, 10,  // ku-arab-iq
            118, 170, // ku-arab-ir
            119, 66,  // kw
            119, 69,  // kw-gb
            119, 146, // ky
            119, 149, // ky-kg
            119, 226, // la
            119, 230, // la-001
            120, 67,  // lag
            120, 70,  // lag-tz
            120, 162, // lb
            120, 165, // lb-lu
            120, 242, // lg
            120, 245, // lg-ug
            121, 67,  // lkt
            121, 70,  // lkt-us
            121, 162, // ln
            121, 165, // ln-ao
            121, 245, // ln-cd
            122, 69,  // ln-cf
            122, 149, // ln-cg
            122, 226, // lo
            122, 229, // lo-la
            123, 51,  // lrc
            123, 54,  // lrc-iq
            123, 150, // lrc-ir
            123, 242, // lt
            123, 245, // lt-lt
            124, 66,  // lu
            124, 69,  // lu-cd
            124, 147, // luo
            124, 150, // luo-ke
            124, 243, // luy
            124, 246, // luy-ke
            125, 82,  // lv
            125, 85,  // lv-lv
            125, 163, // mas
            125, 166, // mas-ke
            126, 6,   // mas-tz
            126, 99,  // mer
            126, 102, // mer-ke
            126, 195, // mfe
            126, 198, // mfe-mu
            127, 34,  // mg
            127, 37,  // mg-mg
            127, 115, // mgh
            127, 118, // mgh-mz
            127, 211, // mgo
            127, 214, // mgo-cm
            128, 50,  // mi
            128, 53,  // mi-nz
            128, 130, // mk
            128, 133, // mk-mk
            128, 210, // ml
            128, 213, // ml-in
            129, 34,  // mn
            129, 39,  // mn-cyrl
            129, 149, // mn-mn
            129, 231, // mn-mong
            129, 234, // mn-mong-cn
            130, 138, // mn-mong-mn
            131, 35,  // mni
            131, 38,  // mni-in
            131, 131, // moh
            131, 134, // moh-ca
            131, 226, // mr
            131, 229, // mr-in
            132, 50,  // ms
            132, 53,  // ms-bn
            132, 133, // ms-my
            132, 213, // ms-sg
            133, 34,  // mt
            133, 37,  // mt-mt
            133, 115, // mua
            133, 118, // mua-cm
            133, 210, // my
            133, 213, // my-mm
            134, 35,  // mzn
            134, 38,  // mzn-ir
            134, 131, // naq
            134, 134, // naq-na
            134, 226, // nb
            134, 229, // nb-no
            135, 53,  // nb-sj
            135, 130, // nd
            135, 133, // nd-zw
            135, 211, // nds
            135, 214, // nds-de
            136, 54,  // nds-nl
            136, 146, // ne
            136, 149, // ne-in
            136, 229, // ne-np
            137, 50,  // nl
            137, 53,  // nl-aw
            137, 133, // nl-be
            137, 213, // nl-bq
            138, 37,  // nl-cw
            138, 117, // nl-nl
            138, 197, // nl-sr
            139, 21,  // nl-sx
            139, 99,  // nmg
            139, 102, // nmg-cm
            139, 194, // nn
            139, 197, // nn-no
            140, 19,  // nnh
            140, 22,  // nnh-cm
            140, 114, // no
            140, 147, // nqo
            140, 150, // nqo-gn
            140, 242, // nr
            140, 245, // nr-za
            141, 67,  // nso
            141, 70,  // nso-za
            141, 163, // nus
            141, 166, // nus-ss
            142, 3,   // nyn
            142, 6,   // nyn-ug
            142, 98,  // oc
            142, 101, // oc-fr
            142, 178, // om
            142, 181, // om-et
            143, 5,   // om-ke
            143, 82,  // or
            143, 85,  // or-in
            143, 162, // os
            143, 165, // os-ge
            143, 245, // os-ru
            144, 66,  // pa
            144, 71,  // pa-arab
            144, 74,  // pa-arab-pk
            144, 229, // pa-in
            145, 51,  // pap
            145, 55,  // pap-029
            145, 162, // pl
            145, 165, // pl-pl
            145, 243, // prg
            145, 247, // prg-001
            146, 99,  // prs
            146, 102, // prs-af
            146, 194, // ps
            146, 197, // ps-af
            147, 18,  // pt
            147, 21,  // pt-ao
            147, 101, // pt-br
            147, 181, // pt-ch
            148, 5,   // pt-cv
            148, 85,  // pt-gq
            148, 165, // pt-gw
            148, 245, // pt-lu
            149, 69,  // pt-mo
            149, 149, // pt-mz
            149, 229, // pt-pt
            150, 53,  // pt-st
            150, 133, // pt-tl
            150, 221, // qps-latn-x-sh
            151, 168, // qps-ploc
            151, 169, // qps-ploca
            152, 57,  // qps-plocm
            152, 195, // quc
            152, 200, // quc-latn
            152, 203, // quc-latn-gt
            153, 115, // quz
            153, 118, // quz-bo
            153, 214, // quz-ec
            154, 54,  // quz-pe
            154, 146, // rm
            154, 149, // rm-ch
            154, 226, // rn
            154, 229, // rn-bi
            155, 50,  // ro
            155, 53,  // ro-md
            155, 133, // ro-ro
            155, 211, // rof
            155, 214, // rof-tz
            156, 50,  // ru
            156, 53,  // ru-by
            156, 133, // ru-kg
            156, 213, // ru-kz
            157, 37,  // ru-md
            157, 117, // ru-ru
            157, 197, // ru-ua
            158, 18,  // rw
            158, 21,  // rw-rw
            158, 99,  // rwk
            158, 102, // rwk-tz
            158, 194, // sa
            158, 197, // sa-in
            159, 19,  // sah
            159, 22,  // sah-ru
            159, 115, // saq
            159, 118, // saq-ke
            159, 211, // sbp
            159, 214, // sbp-tz
            160, 50,  // sd
            160, 55,  // sd-arab
            160, 58,  // sd-arab-pk
            160, 215, // sd-deva
            160, 218, // sd-deva-in
            161, 114, // se
            161, 117, // se-fi
            161, 197, // se-no
            162, 21,  // se-se
            162, 99,  // seh
            162, 102, // seh-mz
            162, 195, // ses
            162, 198, // ses-ml
            163, 34,  // sg
            163, 37,  // sg-cf
            163, 115, // shi
            163, 120, // shi-latn
            163, 123, // shi-latn-ma
            164, 40,  // shi-tfng
            164, 43,  // shi-tfng-ma
            164, 210, // si
            164, 213, // si-lk
            165, 34,  // sk
            165, 37,  // sk-sk
            165, 114, // sl
            165, 117, // sl-si
            165, 195, // sma
            165, 198, // sma-no
            166, 38,  // sma-se
            166, 131, // smj
            166, 134, // smj-no
            166, 230, // smj-se
            167, 67,  // smn
            167, 70,  // smn-fi
            167, 163, // sms
            167, 166, // sms-fi
            168, 2,   // sn
            168, 7,   // sn-latn
            168, 10,  // sn-latn-zw
            168, 162, // so
            168, 165, // so-dj
            168, 245, // so-et
            169, 69,  // so-ke
            169, 149, // so-so
            169, 226, // sq
            169, 229, // sq-al
            170, 53,  // sq-mk
            170, 133, // sq-xk
            170, 210, // sr
            170, 215, // sr-cyrl
            170, 218, // sr-cyrl-ba
            171, 122, // sr-cyrl-cs
            172, 26,  // sr-cyrl-me
            172, 186, // sr-cyrl-rs
            173, 90,  // sr-cyrl-xk
            173, 247, // sr-latn
            173, 250, // sr-latn-ba
            174, 154, // sr-latn-cs
            175, 58,  // sr-latn-me
            175, 218, // sr-latn-rs
            176, 122, // sr-latn-xk
            177, 18,  // ss
            177, 21,  // ss-sz
            177, 101, // ss-za
            177, 179, // ssy
            177, 182, // ssy-er
            178, 18,  // st
            178, 21,  // st-ls
            178, 101, // st-za
            178, 178, // sv
            178, 181, // sv-ax
            179, 5,   // sv-fi
            179, 85,  // sv-se
            179, 162, // sw
            179, 165, // sw-cd
            179, 245, // sw-ke
            180, 69,  // sw-tz
            180, 149, // sw-ug
            180, 227, // swc
            180, 230, // swc-cd
            181, 67,  // syr
            181, 70,  // syr-sy
            181, 162, // ta
            181, 165, // ta-in
            181, 245, // ta-lk
            182, 69,  // ta-my
            182, 149, // ta-sg
            182, 226, // te
            182, 229, // te-in
            183, 51,  // teo
            183, 54,  // teo-ke
            183, 150, // teo-ug
            183, 242, // tg
            183, 247, // tg-cyrl
            183, 250, // tg-cyrl-tj
            184, 146, // th
            184, 149, // th-th
            184, 226, // ti
            184, 229, // ti-er
            185, 53,  // ti-et
            185, 131, // tig
            185, 134, // tig-er
            185, 226, // tk
            185, 229, // tk-tm
            186, 50,  // tn
            186, 53,  // tn-bw
            186, 133, // tn-za
            186, 210, // to
            186, 213, // to-to
            187, 34,  // tr
            187, 37,  // tr-cy
            187, 117, // tr-tr
            187, 194, // ts
            187, 197, // ts-za
            188, 18,  // tt
            188, 21,  // tt-ru
            188, 99,  // twq
            188, 102, // twq-ne
            188, 195, // tzm
            188, 200, // tzm-arab
            188, 203, // tzm-arab-ma
            189, 120, // tzm-latn
            189, 123, // tzm-latn-dz
            190, 43,  // tzm-latn-ma
            190, 216, // tzm-tfng
            190, 219, // tzm-tfng-ma
            191, 130, // ug
            191, 133, // ug-cn
            191, 210, // uk
            191, 213, // uk-ua
            192, 34,  // ur
            192, 37,  // ur-in
            192, 117, // ur-pk
            192, 194, // uz
            192, 199, // uz-arab
            192, 202, // uz-arab-af
            193, 103, // uz-cyrl
            193, 106, // uz-cyrl-uz
            194, 7,   // uz-latn
            194, 10,  // uz-latn-uz
            194, 163, // vai
            194, 168, // vai-latn
            194, 171, // vai-latn-lr
            195, 88,  // vai-vaii
            195, 91,  // vai-vaii-lr
            196, 2,   // ve
            196, 5,   // ve-za
            196, 82,  // vi
            196, 85,  // vi-vn
            196, 162, // vo
            196, 166, // vo-001
            197, 3,   // vun
            197, 6,   // vun-tz
            197, 99,  // wae
            197, 102, // wae-ch
            197, 195, // wal
            197, 198, // wal-et
            198, 34,  // wo
            198, 37,  // wo-sn
            198, 123, // x-iv_mathan
            199, 34,  // xh
            199, 37,  // xh-za
            199, 115, // xog
            199, 118, // xog-ug
            199, 211, // yav
            199, 214, // yav-cm
            200, 50,  // yi
            200, 54,  // yi-001
            200, 146, // yo
            200, 149, // yo-bj
            200, 229, // yo-ng
            201, 51,  // yue
            201, 54,  // yue-hk
            201, 147, // zgh
            201, 152, // zgh-tfng
            201, 155, // zgh-tfng-ma
            202, 66,  // zh
            202, 70,  // zh-chs
            202, 166, // zh-cht
            203, 5,   // zh-cn
            203, 12,  // zh-cn_phoneb
            203, 204, // zh-cn_stroke
            204, 135, // zh-hans
            204, 138, // zh-hans-hk
            205, 42,  // zh-hans-mo
            205, 199, // zh-hant
            206, 53,  // zh-hk
            206, 60,  // zh-hk_radstr
            206, 245, // zh-mo
            206, 252, // zh-mo_radstr
            207, 188, // zh-mo_stroke
            208, 117, // zh-sg
            208, 124, // zh-sg_phoneb
            209, 60,  // zh-sg_stroke
            209, 245, // zh-tw
            209, 252, // zh-tw_pronun
            210, 188, // zh-tw_radstr
            211, 114, // zu
            211, 117, // zu-za
        ];

        private const int LocaleLongestName = 14;

        private static ReadOnlySpan<byte> LcidToCultureNameIndices => // 488 * 4
        [
            0x00, 0x01, 0x02, 0x92,  // ar
            0x00, 0x02, 0x0f, 0x82,  // bg
            0x00, 0x03, 0x14, 0x62,  // ca
            0x00, 0x04, 0xca, 0x46,  // zh-chs
            0x00, 0x05, 0x17, 0xe2,  // cs
            0x00, 0x06, 0x18, 0xd2,  // da
            0x00, 0x07, 0x19, 0xd2,  // de
            0x00, 0x08, 0x1f, 0x92,  // el
            0x00, 0x09, 0x20, 0x32,  // en
            0x00, 0x0a, 0x41, 0x92,  // es
            0x00, 0x0b, 0x4d, 0x12,  // fi
            0x00, 0x0c, 0x4e, 0x62,  // fr
            0x00, 0x0d, 0x63, 0x72,  // he
            0x00, 0x0e, 0x65, 0x12,  // hu
            0x00, 0x0f, 0x68, 0x22,  // is
            0x00, 0x10, 0x68, 0x72,  // it
            0x00, 0x11, 0x6a, 0xa2,  // ja
            0x00, 0x12, 0x72, 0x52,  // ko
            0x00, 0x13, 0x89, 0x32,  // nl
            0x00, 0x14, 0x8c, 0x72,  // no
            0x00, 0x15, 0x91, 0xa2,  // pl
            0x00, 0x16, 0x93, 0x12,  // pt
            0x00, 0x17, 0x9a, 0x92,  // rm
            0x00, 0x18, 0x9b, 0x32,  // ro
            0x00, 0x19, 0x9c, 0x32,  // ru
            0x00, 0x1a, 0x64, 0x12,  // hr
            0x00, 0x1b, 0xa5, 0x22,  // sk
            0x00, 0x1c, 0xa9, 0xe2,  // sq
            0x00, 0x1d, 0xb2, 0xb2,  // sv
            0x00, 0x1e, 0xb8, 0x92,  // th
            0x00, 0x1f, 0xbb, 0x22,  // tr
            0x00, 0x20, 0xc0, 0x22,  // ur
            0x00, 0x21, 0x67, 0x32,  // id
            0x00, 0x22, 0xbf, 0xd2,  // uk
            0x00, 0x23, 0x0e, 0x72,  // be
            0x00, 0x24, 0xa5, 0x72,  // sl
            0x00, 0x25, 0x49, 0xe2,  // et
            0x00, 0x26, 0x7d, 0x52,  // lv
            0x00, 0x27, 0x7b, 0xf2,  // lt
            0x00, 0x28, 0xb7, 0xf2,  // tg
            0x00, 0x29, 0x4a, 0xe2,  // fa
            0x00, 0x2a, 0xc4, 0x52,  // vi
            0x00, 0x2b, 0x65, 0xd2,  // hy
            0x00, 0x2c, 0x0c, 0x82,  // az
            0x00, 0x2d, 0x4a, 0x32,  // eu
            0x00, 0x2e, 0x64, 0xb3,  // hsb
            0x00, 0x2f, 0x80, 0x82,  // mk
            0x00, 0x30, 0xb2, 0x12,  // st
            0x00, 0x31, 0xbb, 0xc2,  // ts
            0x00, 0x32, 0xba, 0x32,  // tn
            0x00, 0x33, 0xc4, 0x02,  // ve
            0x00, 0x34, 0xc7, 0x22,  // xh
            0x00, 0x35, 0xd3, 0x72,  // zu
            0x00, 0x36, 0x00, 0xf2,  // af
            0x00, 0x37, 0x6d, 0x62,  // ka
            0x00, 0x38, 0x4d, 0xc2,  // fo
            0x00, 0x39, 0x63, 0xc2,  // hi
            0x00, 0x3a, 0x85, 0x22,  // mt
            0x00, 0x3b, 0xa1, 0x72,  // se
            0x00, 0x3c, 0x5d, 0xd2,  // ga
            0x00, 0x3d, 0xc8, 0x32,  // yi
            0x00, 0x3e, 0x84, 0x32,  // ms
            0x00, 0x3f, 0x70, 0x52,  // kk
            0x00, 0x40, 0x77, 0x92,  // ky
            0x00, 0x41, 0xb3, 0xa2,  // sw
            0x00, 0x42, 0xb9, 0xe2,  // tk
            0x00, 0x43, 0xc0, 0xc2,  // uz
            0x00, 0x44, 0xbc, 0x12,  // tt
            0x00, 0x45, 0x10, 0xd2,  // bn
            0x00, 0x46, 0x90, 0x42,  // pa
            0x00, 0x47, 0x60, 0x32,  // gu
            0x00, 0x48, 0x8f, 0x52,  // or
            0x00, 0x49, 0xb5, 0xa2,  // ta
            0x00, 0x4a, 0xb6, 0xe2,  // te
            0x00, 0x4b, 0x72, 0x02,  // kn
            0x00, 0x4c, 0x80, 0xd2,  // ml
            0x00, 0x4d, 0x0b, 0x72,  // as
            0x00, 0x4e, 0x83, 0xe2,  // mr
            0x00, 0x4f, 0x9e, 0xc2,  // sa
            0x00, 0x50, 0x81, 0x22,  // mn
            0x00, 0x51, 0x11, 0x72,  // bo
            0x00, 0x52, 0x18, 0x82,  // cy
            0x00, 0x53, 0x71, 0xb2,  // km
            0x00, 0x54, 0x7a, 0xe2,  // lo
            0x00, 0x55, 0x85, 0xd2,  // my
            0x00, 0x56, 0x5e, 0x72,  // gl
            0x00, 0x57, 0x72, 0xf3,  // kok
            0x00, 0x58, 0x83, 0x23,  // mni
            0x00, 0x59, 0xa0, 0x32,  // sd
            0x00, 0x5a, 0xb5, 0x43,  // syr
            0x00, 0x5b, 0xa4, 0xd2,  // si
            0x00, 0x5c, 0x16, 0xe3,  // chr
            0x00, 0x5d, 0x69, 0x62,  // iu
            0x00, 0x5e, 0x02, 0x42,  // am
            0x00, 0x5f, 0xbc, 0xc3,  // tzm
            0x00, 0x60, 0x73, 0xa2,  // ks
            0x00, 0x61, 0x88, 0x92,  // ne
            0x00, 0x62, 0x5d, 0x82,  // fy
            0x00, 0x63, 0x92, 0xc2,  // ps
            0x00, 0x64, 0x4d, 0x63,  // fil
            0x00, 0x65, 0x1d, 0x92,  // dv
            0x00, 0x66, 0x0f, 0xd3,  // bin
            0x00, 0x67, 0x4b, 0x32,  // ff
            0x00, 0x68, 0x61, 0x32,  // ha
            0x00, 0x69, 0x66, 0xd3,  // ibb
            0x00, 0x6a, 0xc8, 0x92,  // yo
            0x00, 0x6b, 0x99, 0x73,  // quz
            0x00, 0x6c, 0x8d, 0x43,  // nso
            0x00, 0x6d, 0x0d, 0xc2,  // ba
            0x00, 0x6e, 0x78, 0xa2,  // lb
            0x00, 0x6f, 0x71, 0x02,  // kl
            0x00, 0x70, 0x67, 0x82,  // ig
            0x00, 0x71, 0x73, 0x52,  // kr
            0x00, 0x72, 0x8e, 0xb2,  // om
            0x00, 0x73, 0xb8, 0xe2,  // ti
            0x00, 0x74, 0x5e, 0xc2,  // gn
            0x00, 0x75, 0x63, 0x13,  // haw
            0x00, 0x76, 0x77, 0xe2,  // la
            0x00, 0x77, 0xa8, 0xa2,  // so
            0x00, 0x78, 0x67, 0xd2,  // ii
            0x00, 0x79, 0x91, 0x33,  // pap
            0x00, 0x7a, 0x0b, 0x13,  // arn
            0x00, 0x7c, 0x83, 0x83,  // moh
            0x00, 0x7e, 0x12, 0x12,  // br
            0x00, 0x80, 0xbf, 0x82,  // ug
            0x00, 0x81, 0x80, 0x32,  // mi
            0x00, 0x82, 0x8e, 0x62,  // oc
            0x00, 0x83, 0x17, 0x92,  // co
            0x00, 0x84, 0x5f, 0x13,  // gsw
            0x00, 0x85, 0x9f, 0x13,  // sah
            0x00, 0x86, 0x98, 0xc3,  // quc
            0x00, 0x87, 0x9e, 0x12,  // rw
            0x00, 0x88, 0xc6, 0x22,  // wo
            0x00, 0x8c, 0x92, 0x63,  // prs
            0x00, 0x91, 0x5e, 0x22,  // gd
            0x00, 0x92, 0x76, 0x02,  // ku
            0x04, 0x01, 0x08, 0x95,  // ar-sa
            0x04, 0x02, 0x0f, 0x85,  // bg-bg
            0x04, 0x03, 0x14, 0xb5,  // ca-es
            0x04, 0x04, 0xd1, 0xf5,  // zh-tw
            0x04, 0x05, 0x17, 0xe5,  // cs-cz
            0x04, 0x06, 0x18, 0xd5,  // da-dk
            0x04, 0x07, 0x1a, 0xc5,  // de-de
            0x04, 0x08, 0x1f, 0xe5,  // el-gr
            0x04, 0x09, 0x3e, 0x65,  // en-us
            0x04, 0x0a, 0x44, 0xcc,  // es-es_tradnl
            0x04, 0x0b, 0x4d, 0x15,  // fi-fi
            0x04, 0x0c, 0x53, 0x25,  // fr-fr
            0x04, 0x0d, 0x63, 0x75,  // he-il
            0x04, 0x0e, 0x65, 0x15,  // hu-hu
            0x04, 0x0f, 0x68, 0x25,  // is-is
            0x04, 0x10, 0x68, 0xc5,  // it-it
            0x04, 0x11, 0x6a, 0xa5,  // ja-jp
            0x04, 0x12, 0x72, 0xa5,  // ko-kr
            0x04, 0x13, 0x8a, 0x75,  // nl-nl
            0x04, 0x14, 0x86, 0xe5,  // nb-no
            0x04, 0x15, 0x91, 0xa5,  // pl-pl
            0x04, 0x16, 0x93, 0x65,  // pt-br
            0x04, 0x17, 0x9a, 0x95,  // rm-ch
            0x04, 0x18, 0x9b, 0x85,  // ro-ro
            0x04, 0x19, 0x9d, 0x75,  // ru-ru
            0x04, 0x1a, 0x64, 0x65,  // hr-hr
            0x04, 0x1b, 0xa5, 0x25,  // sk-sk
            0x04, 0x1c, 0xa9, 0xe5,  // sq-al
            0x04, 0x1d, 0xb3, 0x55,  // sv-se
            0x04, 0x1e, 0xb8, 0x95,  // th-th
            0x04, 0x1f, 0xbb, 0x75,  // tr-tr
            0x04, 0x20, 0xc0, 0x75,  // ur-pk
            0x04, 0x21, 0x67, 0x35,  // id-id
            0x04, 0x22, 0xbf, 0xd5,  // uk-ua
            0x04, 0x23, 0x0e, 0x75,  // be-by
            0x04, 0x24, 0xa5, 0x75,  // sl-si
            0x04, 0x25, 0x49, 0xe5,  // et-ee
            0x04, 0x26, 0x7d, 0x55,  // lv-lv
            0x04, 0x27, 0x7b, 0xf5,  // lt-lt
            0x04, 0x28, 0xb7, 0xfa,  // tg-cyrl-tj
            0x04, 0x29, 0x4a, 0xe5,  // fa-ir
            0x04, 0x2a, 0xc4, 0x55,  // vi-vn
            0x04, 0x2b, 0x65, 0xd5,  // hy-am
            0x04, 0x2c, 0x0d, 0x2a,  // az-latn-az
            0x04, 0x2d, 0x4a, 0x35,  // eu-es
            0x04, 0x2e, 0x64, 0xb6,  // hsb-de
            0x04, 0x2f, 0x80, 0x85,  // mk-mk
            0x04, 0x30, 0xb2, 0x65,  // st-za
            0x04, 0x31, 0xbb, 0xc5,  // ts-za
            0x04, 0x32, 0xba, 0x85,  // tn-za
            0x04, 0x33, 0xc4, 0x05,  // ve-za
            0x04, 0x34, 0xc7, 0x25,  // xh-za
            0x04, 0x35, 0xd3, 0x75,  // zu-za
            0x04, 0x36, 0x01, 0x45,  // af-za
            0x04, 0x37, 0x6d, 0x65,  // ka-ge
            0x04, 0x38, 0x4e, 0x15,  // fo-fo
            0x04, 0x39, 0x63, 0xc5,  // hi-in
            0x04, 0x3a, 0x85, 0x25,  // mt-mt
            0x04, 0x3b, 0xa1, 0xc5,  // se-no
            0x04, 0x3d, 0xc8, 0x36,  // yi-001
            0x04, 0x3e, 0x84, 0x85,  // ms-my
            0x04, 0x3f, 0x70, 0x55,  // kk-kz
            0x04, 0x40, 0x77, 0x95,  // ky-kg
            0x04, 0x41, 0xb3, 0xf5,  // sw-ke
            0x04, 0x42, 0xb9, 0xe5,  // tk-tm
            0x04, 0x43, 0xc2, 0x0a,  // uz-latn-uz
            0x04, 0x44, 0xbc, 0x15,  // tt-ru
            0x04, 0x45, 0x11, 0x25,  // bn-in
            0x04, 0x46, 0x90, 0xe5,  // pa-in
            0x04, 0x47, 0x60, 0x35,  // gu-in
            0x04, 0x48, 0x8f, 0x55,  // or-in
            0x04, 0x49, 0xb5, 0xa5,  // ta-in
            0x04, 0x4a, 0xb6, 0xe5,  // te-in
            0x04, 0x4b, 0x72, 0x05,  // kn-in
            0x04, 0x4c, 0x80, 0xd5,  // ml-in
            0x04, 0x4d, 0x0b, 0x75,  // as-in
            0x04, 0x4e, 0x83, 0xe5,  // mr-in
            0x04, 0x4f, 0x9e, 0xc5,  // sa-in
            0x04, 0x50, 0x81, 0x95,  // mn-mn
            0x04, 0x51, 0x11, 0x75,  // bo-cn
            0x04, 0x52, 0x18, 0x85,  // cy-gb
            0x04, 0x53, 0x71, 0xb5,  // km-kh
            0x04, 0x54, 0x7a, 0xe5,  // lo-la
            0x04, 0x55, 0x85, 0xd5,  // my-mm
            0x04, 0x56, 0x5e, 0x75,  // gl-es
            0x04, 0x57, 0x72, 0xf6,  // kok-in
            0x04, 0x58, 0x83, 0x26,  // mni-in
            0x04, 0x59, 0xa0, 0xda,  // sd-deva-in
            0x04, 0x5a, 0xb5, 0x46,  // syr-sy
            0x04, 0x5b, 0xa4, 0xd5,  // si-lk
            0x04, 0x5c, 0x16, 0xeb,  // chr-cher-us
            0x04, 0x5d, 0x69, 0x6a,  // iu-cans-ca
            0x04, 0x5e, 0x02, 0x45,  // am-et
            0x04, 0x5f, 0xbc, 0xcb,  // tzm-arab-ma
            0x04, 0x60, 0x73, 0xa7,  // ks-arab
            0x04, 0x61, 0x88, 0xe5,  // ne-np
            0x04, 0x62, 0x5d, 0x85,  // fy-nl
            0x04, 0x63, 0x92, 0xc5,  // ps-af
            0x04, 0x64, 0x4d, 0x66,  // fil-ph
            0x04, 0x65, 0x1d, 0x95,  // dv-mv
            0x04, 0x66, 0x0f, 0xd6,  // bin-ng
            0x04, 0x67, 0x4c, 0xc5,  // ff-ng
            0x04, 0x68, 0x62, 0x7a,  // ha-latn-ng
            0x04, 0x69, 0x66, 0xd6,  // ibb-ng
            0x04, 0x6a, 0xc8, 0xe5,  // yo-ng
            0x04, 0x6b, 0x99, 0x76,  // quz-bo
            0x04, 0x6c, 0x8d, 0x46,  // nso-za
            0x04, 0x6d, 0x0d, 0xc5,  // ba-ru
            0x04, 0x6e, 0x78, 0xa5,  // lb-lu
            0x04, 0x6f, 0x71, 0x05,  // kl-gl
            0x04, 0x70, 0x67, 0x85,  // ig-ng
            0x04, 0x71, 0x73, 0x55,  // kr-ng
            0x04, 0x72, 0x8e, 0xb5,  // om-et
            0x04, 0x73, 0xb9, 0x35,  // ti-et
            0x04, 0x74, 0x5e, 0xc5,  // gn-py
            0x04, 0x75, 0x63, 0x16,  // haw-us
            0x04, 0x76, 0x77, 0xe6,  // la-001
            0x04, 0x77, 0xa9, 0x95,  // so-so
            0x04, 0x78, 0x67, 0xd5,  // ii-cn
            0x04, 0x79, 0x91, 0x37,  // pap-029
            0x04, 0x7a, 0x0b, 0x16,  // arn-cl
            0x04, 0x7c, 0x83, 0x86,  // moh-ca
            0x04, 0x7e, 0x12, 0x15,  // br-fr
            0x04, 0x80, 0xbf, 0x85,  // ug-cn
            0x04, 0x81, 0x80, 0x35,  // mi-nz
            0x04, 0x82, 0x8e, 0x65,  // oc-fr
            0x04, 0x83, 0x17, 0x95,  // co-fr
            0x04, 0x84, 0x5f, 0x76,  // gsw-fr
            0x04, 0x85, 0x9f, 0x16,  // sah-ru
            0x04, 0x86, 0x98, 0xcb,  // quc-latn-gt
            0x04, 0x87, 0x9e, 0x15,  // rw-rw
            0x04, 0x88, 0xc6, 0x25,  // wo-sn
            0x04, 0x8c, 0x92, 0x66,  // prs-af
            0x04, 0x91, 0x5e, 0x25,  // gd-gb
            0x04, 0x92, 0x76, 0x0a,  // ku-arab-iq
            0x05, 0x01, 0x97, 0xa8,  // qps-ploc
            0x05, 0xfe, 0x97, 0xa9,  // qps-ploca
            0x08, 0x01, 0x05, 0x25,  // ar-iq
            0x08, 0x03, 0x14, 0xbe,  // ca-es-valencia
            0x08, 0x04, 0xcb, 0x05,  // zh-cn
            0x08, 0x07, 0x1a, 0x75,  // de-ch
            0x08, 0x09, 0x29, 0xc5,  // en-gb
            0x08, 0x0a, 0x46, 0x75,  // es-mx
            0x08, 0x0c, 0x4e, 0xc5,  // fr-be
            0x08, 0x10, 0x68, 0x75,  // it-ch
            0x08, 0x13, 0x89, 0x85,  // nl-be
            0x08, 0x14, 0x8b, 0xc5,  // nn-no
            0x08, 0x16, 0x95, 0xe5,  // pt-pt
            0x08, 0x18, 0x9b, 0x35,  // ro-md
            0x08, 0x19, 0x9d, 0x25,  // ru-md
            0x08, 0x1a, 0xae, 0x9a,  // sr-latn-cs
            0x08, 0x1d, 0xb3, 0x05,  // sv-fi
            0x08, 0x20, 0xc0, 0x25,  // ur-in
            0x08, 0x2c, 0x0c, 0x8a,  // az-cyrl-az
            0x08, 0x2e, 0x1c, 0xd6,  // dsb-de
            0x08, 0x32, 0xba, 0x35,  // tn-bw
            0x08, 0x3b, 0xa2, 0x15,  // se-se
            0x08, 0x3c, 0x5d, 0xd5,  // ga-ie
            0x08, 0x3e, 0x84, 0x35,  // ms-bn
            0x08, 0x43, 0xc1, 0x6a,  // uz-cyrl-uz
            0x08, 0x45, 0x10, 0xd5,  // bn-bd
            0x08, 0x46, 0x90, 0x4a,  // pa-arab-pk
            0x08, 0x49, 0xb5, 0xf5,  // ta-lk
            0x08, 0x50, 0x81, 0xea,  // mn-mong-cn
            0x08, 0x59, 0xa0, 0x3a,  // sd-arab-pk
            0x08, 0x5d, 0x6a, 0x0a,  // iu-latn-ca
            0x08, 0x5f, 0xbd, 0x7b,  // tzm-latn-dz
            0x08, 0x60, 0x74, 0x4a,  // ks-deva-in
            0x08, 0x61, 0x88, 0x95,  // ne-in
            0x08, 0x67, 0x4b, 0xda,  // ff-latn-sn
            0x08, 0x6b, 0x99, 0xd6,  // quz-ec
            0x08, 0x73, 0xb8, 0xe5,  // ti-er
            0x09, 0x01, 0x96, 0xdd,  // qps-latn-x-sh
            0x09, 0xff, 0x98, 0x39,  // qps-plocm
            0x0c, 0x01, 0x04, 0x35,  // ar-eg
            0x0c, 0x04, 0xce, 0x35,  // zh-hk
            0x0c, 0x07, 0x19, 0xd5,  // de-at
            0x0c, 0x09, 0x22, 0x95,  // en-au
            0x0c, 0x0a, 0x44, 0xc5,  // es-es
            0x0c, 0x0c, 0x50, 0x55,  // fr-ca
            0x0c, 0x1a, 0xab, 0x7a,  // sr-cyrl-cs
            0x0c, 0x3b, 0xa1, 0x75,  // se-fi
            0x0c, 0x50, 0x82, 0x8a,  // mn-mong-mn
            0x0c, 0x51, 0x1e, 0x45,  // dz-bt
            0x0c, 0x6b, 0x9a, 0x36,  // quz-pe
            0x10, 0x01, 0x06, 0xb5,  // ar-ly
            0x10, 0x04, 0xd0, 0x75,  // zh-sg
            0x10, 0x07, 0x1c, 0x25,  // de-lu
            0x10, 0x09, 0x25, 0x15,  // en-ca
            0x10, 0x0a, 0x45, 0xd5,  // es-gt
            0x10, 0x0c, 0x51, 0x95,  // fr-ch
            0x10, 0x1a, 0x64, 0x15,  // hr-ba
            0x10, 0x3b, 0xa6, 0x86,  // smj-no
            0x10, 0x5f, 0xbe, 0xdb,  // tzm-tfng-ma
            0x14, 0x01, 0x03, 0xe5,  // ar-dz
            0x14, 0x04, 0xce, 0xf5,  // zh-mo
            0x14, 0x07, 0x1b, 0xd5,  // de-li
            0x14, 0x09, 0x35, 0xf5,  // en-nz
            0x14, 0x0a, 0x43, 0x85,  // es-cr
            0x14, 0x0c, 0x55, 0xa5,  // fr-lu
            0x14, 0x1a, 0x13, 0x6a,  // bs-latn-ba
            0x14, 0x3b, 0xa6, 0xe6,  // smj-se
            0x18, 0x01, 0x07, 0x05,  // ar-ma
            0x18, 0x09, 0x2c, 0xe5,  // en-ie
            0x18, 0x0a, 0x47, 0x15,  // es-pa
            0x18, 0x0c, 0x56, 0x45,  // fr-mc
            0x18, 0x1a, 0xad, 0xfa,  // sr-latn-ba
            0x18, 0x3b, 0xa5, 0xc6,  // sma-no
            0x1c, 0x01, 0x0a, 0x75,  // ar-tn
            0x1c, 0x09, 0x40, 0x45,  // en-za
            0x1c, 0x0a, 0x44, 0x25,  // es-do
            0x1c, 0x0c, 0x4e, 0x66,  // fr-029
            0x1c, 0x1a, 0xaa, 0xda,  // sr-cyrl-ba
            0x1c, 0x3b, 0xa6, 0x26,  // sma-se
            0x20, 0x01, 0x07, 0xa5,  // ar-om
            0x20, 0x09, 0x2e, 0xc5,  // en-jm
            0x20, 0x0a, 0x49, 0x95,  // es-ve
            0x20, 0x0c, 0x59, 0xb5,  // fr-re
            0x20, 0x1a, 0x12, 0xca,  // bs-cyrl-ba
            0x20, 0x3b, 0xa7, 0xa6,  // sms-fi
            0x24, 0x01, 0x0a, 0xc5,  // ar-ye
            0x24, 0x09, 0x20, 0x96,  // en-029
            0x24, 0x0a, 0x43, 0x35,  // es-co
            0x24, 0x0c, 0x50, 0xa5,  // fr-cd
            0x24, 0x1a, 0xaf, 0xda,  // sr-latn-rs
            0x24, 0x3b, 0xa7, 0x46,  // smn-fi
            0x28, 0x01, 0x09, 0xd5,  // ar-sy
            0x28, 0x09, 0x24, 0xc5,  // en-bz
            0x28, 0x0a, 0x47, 0x65,  // es-pe
            0x28, 0x0c, 0x5a, 0xa5,  // fr-sn
            0x28, 0x1a, 0xac, 0xba,  // sr-cyrl-rs
            0x2c, 0x01, 0x05, 0x75,  // ar-jo
            0x2c, 0x09, 0x3c, 0xd5,  // en-tt
            0x2c, 0x0a, 0x41, 0xf5,  // es-ar
            0x2c, 0x0c, 0x52, 0x35,  // fr-cm
            0x2c, 0x1a, 0xaf, 0x3a,  // sr-latn-me
            0x30, 0x01, 0x06, 0x65,  // ar-lb
            0x30, 0x09, 0x40, 0xe5,  // en-zw
            0x30, 0x0a, 0x44, 0x75,  // es-ec
            0x30, 0x0c, 0x51, 0xe5,  // fr-ci
            0x30, 0x1a, 0xac, 0x1a,  // sr-cyrl-me
            0x34, 0x01, 0x06, 0x15,  // ar-kw
            0x34, 0x09, 0x36, 0x95,  // en-ph
            0x34, 0x0a, 0x42, 0xe5,  // es-cl
            0x34, 0x0c, 0x57, 0x35,  // fr-ml
            0x38, 0x01, 0x02, 0xf5,  // ar-ae
            0x38, 0x09, 0x2c, 0x95,  // en-id
            0x38, 0x0a, 0x49, 0x45,  // es-uy
            0x38, 0x0c, 0x55, 0xf5,  // fr-ma
            0x3c, 0x01, 0x03, 0x45,  // ar-bh
            0x3c, 0x09, 0x2c, 0x45,  // en-hk
            0x3c, 0x0a, 0x48, 0x55,  // es-py
            0x3c, 0x0c, 0x55, 0x05,  // fr-ht
            0x40, 0x01, 0x08, 0x45,  // ar-qa
            0x40, 0x09, 0x2d, 0xd5,  // en-in
            0x40, 0x0a, 0x42, 0x45,  // es-bo
            0x44, 0x09, 0x33, 0xc5,  // en-my
            0x44, 0x0a, 0x48, 0xa5,  // es-sv
            0x48, 0x09, 0x39, 0xb5,  // en-sg
            0x48, 0x0a, 0x46, 0x25,  // es-hn
            0x4c, 0x0a, 0x46, 0xc5,  // es-ni
            0x50, 0x0a, 0x48, 0x05,  // es-pr
            0x54, 0x0a, 0x48, 0xf5,  // es-us
            0x58, 0x0a, 0x41, 0x96,  // es-419
            0x5c, 0x0a, 0x43, 0xd5,  // es-cu
            0x64, 0x1a, 0x12, 0xc7,  // bs-cyrl
            0x68, 0x1a, 0x13, 0x67,  // bs-latn
            0x6c, 0x1a, 0xaa, 0xd7,  // sr-cyrl
            0x70, 0x1a, 0xad, 0xf7,  // sr-latn
            0x70, 0x3b, 0xa7, 0x43,  // smn
            0x74, 0x2c, 0x0c, 0x87,  // az-cyrl
            0x74, 0x3b, 0xa7, 0xa3,  // sms
            0x78, 0x04, 0xca, 0x42,  // zh
            0x78, 0x14, 0x8b, 0xc2,  // nn
            0x78, 0x1a, 0x12, 0xc2,  // bs
            0x78, 0x2c, 0x0d, 0x27,  // az-latn
            0x78, 0x3b, 0xa5, 0xc3,  // sma
            0x78, 0x43, 0xc1, 0x67,  // uz-cyrl
            0x78, 0x50, 0x81, 0x27,  // mn-cyrl
            0x78, 0x5d, 0x69, 0x67,  // iu-cans
            0x78, 0x5f, 0xbe, 0xd8,  // tzm-tfng
            0x7c, 0x04, 0xca, 0xa6,  // zh-cht
            0x7c, 0x14, 0x86, 0xe2,  // nb
            0x7c, 0x1a, 0xaa, 0xd2,  // sr
            0x7c, 0x28, 0xb7, 0xf7,  // tg-cyrl
            0x7c, 0x2e, 0x1c, 0xd3,  // dsb
            0x7c, 0x3b, 0xa6, 0x83,  // smj
            0x7c, 0x43, 0xc2, 0x07,  // uz-latn
            0x7c, 0x46, 0x90, 0x47,  // pa-arab
            0x7c, 0x50, 0x81, 0xe7,  // mn-mong
            0x7c, 0x59, 0xa0, 0x37,  // sd-arab
            0x7c, 0x5c, 0x16, 0xe8,  // chr-cher
            0x7c, 0x5d, 0x6a, 0x07,  // iu-latn
            0x7c, 0x5f, 0xbd, 0x78,  // tzm-latn
            0x7c, 0x67, 0x4b, 0xd7,  // ff-latn
            0x7c, 0x68, 0x61, 0x37,  // ha-latn
            0x7c, 0x86, 0x98, 0xc8,  // quc-latn
            0x7c, 0x92, 0x76, 0x07,  // ku-arab
            // Sort 0x1
            0x00, 0x7f, 0xc6, 0x7b,  // x-iv_mathan
            0x04, 0x07, 0x1a, 0xcc,  // de-de_phoneb
            0x04, 0x0e, 0x65, 0x1c,  // hu-hu_technl
            0x04, 0x37, 0x6d, 0x6c,  // ka-ge_modern
            // Sort 0x2
            0x08, 0x04, 0xcb, 0xcc,  // zh-cn_stroke
            0x10, 0x04, 0xd1, 0x3c,  // zh-sg_stroke
            0x14, 0x04, 0xcf, 0xbc,  // zh-mo_stroke
            // Sort 0x3
            0x04, 0x04, 0xd1, 0xfc,  // zh-tw_pronun
            // Sort 0x4
            0x04, 0x04, 0xd2, 0xbc,  // zh-tw_radstr
            0x04, 0x11, 0x6a, 0xac,  // ja-jp_radstr
            0x0c, 0x04, 0xce, 0x3c,  // zh-hk_radstr
            0x14, 0x04, 0xce, 0xfc,  // zh-mo_radstr
            // Sort 0x5
            0x08, 0x04, 0xcb, 0x0c,  // zh-cn_phoneb
            0x10, 0x04, 0xd0, 0x7c,  // zh-sg_phoneb
        ];

        private const int LcidSortPrefix1Index = 1736;
        private const int LcidSortPrefix2Index = 1752;
        private const int LcidSortPrefix3Index = 1764;
        private const int LcidSortPrefix4Index = 1768;
        private const int LcidSortPrefix5Index = 1784;

        private const int NumericLocaleDataBytesPerRow = 18;

        // ThreeLetterWindowsLanguageName is string containing 3-letter Windows language names
        // every 3-characters entry is matching locale name entry in CultureNames
        private static ReadOnlySpan<byte> ThreeLetterWindowsLanguageName =>
            "ZZZ"u8 + // aa
            "ZZZ"u8 + // aa-dj
            "ZZZ"u8 + // aa-er
            "ZZZ"u8 + // aa-et
            "AFK"u8 + // af
            "ZZZ"u8 + // af-na
            "AFK"u8 + // af-za
            "ZZZ"u8 + // agq
            "ZZZ"u8 + // agq-cm
            "ZZZ"u8 + // ak
            "ZZZ"u8 + // ak-gh
            "AMH"u8 + // am
            "AMH"u8 + // am-et
            "ARA"u8 + // ar
            "ZZZ"u8 + // ar-001
            "ARU"u8 + // ar-ae
            "ARH"u8 + // ar-bh
            "ZZZ"u8 + // ar-dj
            "ARG"u8 + // ar-dz
            "ARE"u8 + // ar-eg
            "ZZZ"u8 + // ar-er
            "ZZZ"u8 + // ar-il
            "ARI"u8 + // ar-iq
            "ARJ"u8 + // ar-jo
            "ZZZ"u8 + // ar-km
            "ARK"u8 + // ar-kw
            "ARB"u8 + // ar-lb
            "ARL"u8 + // ar-ly
            "ARM"u8 + // ar-ma
            "ZZZ"u8 + // ar-mr
            "ARO"u8 + // ar-om
            "ZZZ"u8 + // ar-ps
            "ARQ"u8 + // ar-qa
            "ARA"u8 + // ar-sa
            "ZZZ"u8 + // ar-sd
            "ZZZ"u8 + // ar-so
            "ZZZ"u8 + // ar-ss
            "ARS"u8 + // ar-sy
            "ZZZ"u8 + // ar-td
            "ART"u8 + // ar-tn
            "ARY"u8 + // ar-ye
            "MPD"u8 + // arn
            "MPD"u8 + // arn-cl
            "ASM"u8 + // as
            "ASM"u8 + // as-in
            "ZZZ"u8 + // asa
            "ZZZ"u8 + // asa-tz
            "ZZZ"u8 + // ast
            "ZZZ"u8 + // ast-es
            "AZE"u8 + // az
            "AZC"u8 + // az-cyrl
            "AZC"u8 + // az-cyrl-az
            "AZE"u8 + // az-latn
            "AZE"u8 + // az-latn-az
            "BAS"u8 + // ba
            "BAS"u8 + // ba-ru
            "ZZZ"u8 + // bas
            "ZZZ"u8 + // bas-cm
            "BEL"u8 + // be
            "BEL"u8 + // be-by
            "ZZZ"u8 + // bem
            "ZZZ"u8 + // bem-zm
            "ZZZ"u8 + // bez
            "ZZZ"u8 + // bez-tz
            "BGR"u8 + // bg
            "BGR"u8 + // bg-bg
            "ZZZ"u8 + // bin
            "ZZZ"u8 + // bin-ng
            "ZZZ"u8 + // bm
            "ZZZ"u8 + // bm-latn
            "ZZZ"u8 + // bm-latn-ml
            "BNB"u8 + // bn
            "BNB"u8 + // bn-bd
            "BNG"u8 + // bn-in
            "BOB"u8 + // bo
            "BOB"u8 + // bo-cn
            "ZZZ"u8 + // bo-in
            "BRE"u8 + // br
            "BRE"u8 + // br-fr
            "ZZZ"u8 + // brx
            "ZZZ"u8 + // brx-in
            "BSB"u8 + // bs
            "BSC"u8 + // bs-cyrl
            "BSC"u8 + // bs-cyrl-ba
            "BSB"u8 + // bs-latn
            "BSB"u8 + // bs-latn-ba
            "ZZZ"u8 + // byn
            "ZZZ"u8 + // byn-er
            "CAT"u8 + // ca
            "ZZZ"u8 + // ca-ad
            "CAT"u8 + // ca-es
            "VAL"u8 + // ca-es-valencia
            "ZZZ"u8 + // ca-fr
            "ZZZ"u8 + // ca-it
            "ZZZ"u8 + // ce
            "ZZZ"u8 + // ce-ru
            "ZZZ"u8 + // cgg
            "ZZZ"u8 + // cgg-ug
            "CRE"u8 + // chr
            "CRE"u8 + // chr-cher
            "CRE"u8 + // chr-cher-us
            "COS"u8 + // co
            "COS"u8 + // co-fr
            "CSY"u8 + // cs
            "CSY"u8 + // cs-cz
            "ZZZ"u8 + // cu
            "ZZZ"u8 + // cu-ru
            "CYM"u8 + // cy
            "CYM"u8 + // cy-gb
            "DAN"u8 + // da
            "DAN"u8 + // da-dk
            "ZZZ"u8 + // da-gl
            "ZZZ"u8 + // dav
            "ZZZ"u8 + // dav-ke
            "DEU"u8 + // de
            "DEA"u8 + // de-at
            "ZZZ"u8 + // de-be
            "DES"u8 + // de-ch
            "DEU"u8 + // de-de
            "DEU"u8 + // de-de_phoneb
            "ZZZ"u8 + // de-it
            "DEC"u8 + // de-li
            "DEL"u8 + // de-lu
            "ZZZ"u8 + // dje
            "ZZZ"u8 + // dje-ne
            "DSB"u8 + // dsb
            "DSB"u8 + // dsb-de
            "ZZZ"u8 + // dua
            "ZZZ"u8 + // dua-cm
            "DIV"u8 + // dv
            "DIV"u8 + // dv-mv
            "ZZZ"u8 + // dyo
            "ZZZ"u8 + // dyo-sn
            "ZZZ"u8 + // dz
            "ZZZ"u8 + // dz-bt
            "ZZZ"u8 + // ebu
            "ZZZ"u8 + // ebu-ke
            "ZZZ"u8 + // ee
            "ZZZ"u8 + // ee-gh
            "ZZZ"u8 + // ee-tg
            "ELL"u8 + // el
            "ZZZ"u8 + // el-cy
            "ELL"u8 + // el-gr
            "ENU"u8 + // en
            "ZZZ"u8 + // en-001
            "ENB"u8 + // en-029
            "ZZZ"u8 + // en-150
            "ZZZ"u8 + // en-ag
            "ZZZ"u8 + // en-ai
            "ZZZ"u8 + // en-as
            "ZZZ"u8 + // en-at
            "ENA"u8 + // en-au
            "ZZZ"u8 + // en-bb
            "ZZZ"u8 + // en-be
            "ZZZ"u8 + // en-bi
            "ZZZ"u8 + // en-bm
            "ZZZ"u8 + // en-bs
            "ZZZ"u8 + // en-bw
            "ENL"u8 + // en-bz
            "ENC"u8 + // en-ca
            "ZZZ"u8 + // en-cc
            "ZZZ"u8 + // en-ch
            "ZZZ"u8 + // en-ck
            "ZZZ"u8 + // en-cm
            "ZZZ"u8 + // en-cx
            "ZZZ"u8 + // en-cy
            "ZZZ"u8 + // en-de
            "ZZZ"u8 + // en-dk
            "ZZZ"u8 + // en-dm
            "ZZZ"u8 + // en-er
            "ZZZ"u8 + // en-fi
            "ZZZ"u8 + // en-fj
            "ZZZ"u8 + // en-fk
            "ZZZ"u8 + // en-fm
            "ENG"u8 + // en-gb
            "ZZZ"u8 + // en-gd
            "ZZZ"u8 + // en-gg
            "ZZZ"u8 + // en-gh
            "ZZZ"u8 + // en-gi
            "ZZZ"u8 + // en-gm
            "ZZZ"u8 + // en-gu
            "ZZZ"u8 + // en-gy
            "ENH"u8 + // en-hk
            "ZZZ"u8 + // en-id
            "ENI"u8 + // en-ie
            "ZZZ"u8 + // en-il
            "ZZZ"u8 + // en-im
            "ENN"u8 + // en-in
            "ZZZ"u8 + // en-io
            "ZZZ"u8 + // en-je
            "ENJ"u8 + // en-jm
            "ZZZ"u8 + // en-ke
            "ZZZ"u8 + // en-ki
            "ZZZ"u8 + // en-kn
            "ZZZ"u8 + // en-ky
            "ZZZ"u8 + // en-lc
            "ZZZ"u8 + // en-lr
            "ZZZ"u8 + // en-ls
            "ZZZ"u8 + // en-mg
            "ZZZ"u8 + // en-mh
            "ZZZ"u8 + // en-mo
            "ZZZ"u8 + // en-mp
            "ZZZ"u8 + // en-ms
            "ZZZ"u8 + // en-mt
            "ZZZ"u8 + // en-mu
            "ZZZ"u8 + // en-mw
            "ENM"u8 + // en-my
            "ZZZ"u8 + // en-na
            "ZZZ"u8 + // en-nf
            "ZZZ"u8 + // en-ng
            "ZZZ"u8 + // en-nl
            "ZZZ"u8 + // en-nr
            "ZZZ"u8 + // en-nu
            "ENZ"u8 + // en-nz
            "ZZZ"u8 + // en-pg
            "ENP"u8 + // en-ph
            "ZZZ"u8 + // en-pk
            "ZZZ"u8 + // en-pn
            "ZZZ"u8 + // en-pr
            "ZZZ"u8 + // en-pw
            "ZZZ"u8 + // en-rw
            "ZZZ"u8 + // en-sb
            "ZZZ"u8 + // en-sc
            "ZZZ"u8 + // en-sd
            "ZZZ"u8 + // en-se
            "ENE"u8 + // en-sg
            "ZZZ"u8 + // en-sh
            "ZZZ"u8 + // en-si
            "ZZZ"u8 + // en-sl
            "ZZZ"u8 + // en-ss
            "ZZZ"u8 + // en-sx
            "ZZZ"u8 + // en-sz
            "ZZZ"u8 + // en-tc
            "ZZZ"u8 + // en-tk
            "ZZZ"u8 + // en-to
            "ENT"u8 + // en-tt
            "ZZZ"u8 + // en-tv
            "ZZZ"u8 + // en-tz
            "ZZZ"u8 + // en-ug
            "ZZZ"u8 + // en-um
            "ENU"u8 + // en-us
            "ZZZ"u8 + // en-vc
            "ZZZ"u8 + // en-vg
            "ZZZ"u8 + // en-vi
            "ZZZ"u8 + // en-vu
            "ZZZ"u8 + // en-ws
            "ENS"u8 + // en-za
            "ZZZ"u8 + // en-zm
            "ENW"u8 + // en-zw
            "ZZZ"u8 + // eo
            "ZZZ"u8 + // eo-001
            "ESP"u8 + // es
            "ESJ"u8 + // es-419
            "ESS"u8 + // es-ar
            "ESB"u8 + // es-bo
            "ZZZ"u8 + // es-br
            "ESL"u8 + // es-cl
            "ESO"u8 + // es-co
            "ESC"u8 + // es-cr
            "ESK"u8 + // es-cu
            "ESD"u8 + // es-do
            "ESF"u8 + // es-ec
            "ESN"u8 + // es-es
            "ESP"u8 + // es-es_tradnl
            "ZZZ"u8 + // es-gq
            "ESG"u8 + // es-gt
            "ESH"u8 + // es-hn
            "ESM"u8 + // es-mx
            "ESI"u8 + // es-ni
            "ESA"u8 + // es-pa
            "ESR"u8 + // es-pe
            "ZZZ"u8 + // es-ph
            "ESU"u8 + // es-pr
            "ESZ"u8 + // es-py
            "ESE"u8 + // es-sv
            "EST"u8 + // es-us
            "ESY"u8 + // es-uy
            "ESV"u8 + // es-ve
            "ETI"u8 + // et
            "ETI"u8 + // et-ee
            "EUQ"u8 + // eu
            "EUQ"u8 + // eu-es
            "ZZZ"u8 + // ewo
            "ZZZ"u8 + // ewo-cm
            "FAR"u8 + // fa
            "FAR"u8 + // fa-ir
            "FUL"u8 + // ff
            "ZZZ"u8 + // ff-cm
            "ZZZ"u8 + // ff-gn
            "FUL"u8 + // ff-latn
            "FUL"u8 + // ff-latn-sn
            "ZZZ"u8 + // ff-mr
            "ZZZ"u8 + // ff-ng
            "FIN"u8 + // fi
            "FIN"u8 + // fi-fi
            "FPO"u8 + // fil
            "FPO"u8 + // fil-ph
            "FOS"u8 + // fo
            "ZZZ"u8 + // fo-dk
            "FOS"u8 + // fo-fo
            "FRA"u8 + // fr
            "ZZZ"u8 + // fr-029
            "FRB"u8 + // fr-be
            "ZZZ"u8 + // fr-bf
            "ZZZ"u8 + // fr-bi
            "ZZZ"u8 + // fr-bj
            "ZZZ"u8 + // fr-bl
            "FRC"u8 + // fr-ca
            "FRD"u8 + // fr-cd
            "ZZZ"u8 + // fr-cf
            "ZZZ"u8 + // fr-cg
            "FRS"u8 + // fr-ch
            "FRI"u8 + // fr-ci
            "FRE"u8 + // fr-cm
            "ZZZ"u8 + // fr-dj
            "ZZZ"u8 + // fr-dz
            "FRA"u8 + // fr-fr
            "ZZZ"u8 + // fr-ga
            "ZZZ"u8 + // fr-gf
            "ZZZ"u8 + // fr-gn
            "ZZZ"u8 + // fr-gp
            "ZZZ"u8 + // fr-gq
            "FRH"u8 + // fr-ht
            "ZZZ"u8 + // fr-km
            "FRL"u8 + // fr-lu
            "FRO"u8 + // fr-ma
            "FRM"u8 + // fr-mc
            "ZZZ"u8 + // fr-mf
            "ZZZ"u8 + // fr-mg
            "FRF"u8 + // fr-ml
            "ZZZ"u8 + // fr-mq
            "ZZZ"u8 + // fr-mr
            "ZZZ"u8 + // fr-mu
            "ZZZ"u8 + // fr-nc
            "ZZZ"u8 + // fr-ne
            "ZZZ"u8 + // fr-pf
            "ZZZ"u8 + // fr-pm
            "FRR"u8 + // fr-re
            "ZZZ"u8 + // fr-rw
            "ZZZ"u8 + // fr-sc
            "FRN"u8 + // fr-sn
            "ZZZ"u8 + // fr-sy
            "ZZZ"u8 + // fr-td
            "ZZZ"u8 + // fr-tg
            "ZZZ"u8 + // fr-tn
            "ZZZ"u8 + // fr-vu
            "ZZZ"u8 + // fr-wf
            "ZZZ"u8 + // fr-yt
            "ZZZ"u8 + // fur
            "ZZZ"u8 + // fur-it
            "FYN"u8 + // fy
            "FYN"u8 + // fy-nl
            "IRE"u8 + // ga
            "IRE"u8 + // ga-ie
            "GLA"u8 + // gd
            "GLA"u8 + // gd-gb
            "GLC"u8 + // gl
            "GLC"u8 + // gl-es
            "GRN"u8 + // gn
            "GRN"u8 + // gn-py
            "ZZZ"u8 + // gsw
            "ZZZ"u8 + // gsw-ch
            "GSW"u8 + // gsw-fr
            "ZZZ"u8 + // gsw-li
            "GUJ"u8 + // gu
            "GUJ"u8 + // gu-in
            "ZZZ"u8 + // guz
            "ZZZ"u8 + // guz-ke
            "ZZZ"u8 + // gv
            "ZZZ"u8 + // gv-im
            "HAU"u8 + // ha
            "HAU"u8 + // ha-latn
            "ZZZ"u8 + // ha-latn-gh
            "ZZZ"u8 + // ha-latn-ne
            "HAU"u8 + // ha-latn-ng
            "HAW"u8 + // haw
            "HAW"u8 + // haw-us
            "HEB"u8 + // he
            "HEB"u8 + // he-il
            "HIN"u8 + // hi
            "HIN"u8 + // hi-in
            "HRV"u8 + // hr
            "HRB"u8 + // hr-ba
            "HRV"u8 + // hr-hr
            "HSB"u8 + // hsb
            "HSB"u8 + // hsb-de
            "HUN"u8 + // hu
            "HUN"u8 + // hu-hu
            "HUN"u8 + // hu-hu_technl
            "HYE"u8 + // hy
            "HYE"u8 + // hy-am
            "ZZZ"u8 + // ia
            "ZZZ"u8 + // ia-001
            "ZZZ"u8 + // ia-fr
            "ZZZ"u8 + // ibb
            "ZZZ"u8 + // ibb-ng
            "IND"u8 + // id
            "IND"u8 + // id-id
            "IBO"u8 + // ig
            "IBO"u8 + // ig-ng
            "III"u8 + // ii
            "III"u8 + // ii-cn
            "ISL"u8 + // is
            "ISL"u8 + // is-is
            "ITA"u8 + // it
            "ITS"u8 + // it-ch
            "ITA"u8 + // it-it
            "ZZZ"u8 + // it-sm
            "IUK"u8 + // iu
            "IUS"u8 + // iu-cans
            "IUS"u8 + // iu-cans-ca
            "IUK"u8 + // iu-latn
            "IUK"u8 + // iu-latn-ca
            "JPN"u8 + // ja
            "JPN"u8 + // ja-jp
            "JPN"u8 + // ja-jp_radstr
            "ZZZ"u8 + // jgo
            "ZZZ"u8 + // jgo-cm
            "ZZZ"u8 + // jmc
            "ZZZ"u8 + // jmc-tz
            "JAV"u8 + // jv
            "ZZZ"u8 + // jv-java
            "ZZZ"u8 + // jv-java-id
            "JAV"u8 + // jv-latn
            "JAV"u8 + // jv-latn-id
            "KAT"u8 + // ka
            "KAT"u8 + // ka-ge
            "KAT"u8 + // ka-ge_modern
            "ZZZ"u8 + // kab
            "ZZZ"u8 + // kab-dz
            "ZZZ"u8 + // kam
            "ZZZ"u8 + // kam-ke
            "ZZZ"u8 + // kde
            "ZZZ"u8 + // kde-tz
            "ZZZ"u8 + // kea
            "ZZZ"u8 + // kea-cv
            "ZZZ"u8 + // khq
            "ZZZ"u8 + // khq-ml
            "ZZZ"u8 + // ki
            "ZZZ"u8 + // ki-ke
            "KKZ"u8 + // kk
            "KKZ"u8 + // kk-kz
            "ZZZ"u8 + // kkj
            "ZZZ"u8 + // kkj-cm
            "KAL"u8 + // kl
            "KAL"u8 + // kl-gl
            "ZZZ"u8 + // kln
            "ZZZ"u8 + // kln-ke
            "KHM"u8 + // km
            "KHM"u8 + // km-kh
            "KDI"u8 + // kn
            "KDI"u8 + // kn-in
            "KOR"u8 + // ko
            "ZZZ"u8 + // ko-kp
            "KOR"u8 + // ko-kr
            "KNK"u8 + // kok
            "KNK"u8 + // kok-in
            "ZZZ"u8 + // kr
            "ZZZ"u8 + // kr-ng
            "ZZZ"u8 + // ks
            "ZZZ"u8 + // ks-arab
            "ZZZ"u8 + // ks-arab-in
            "ZZZ"u8 + // ks-deva
            "ZZZ"u8 + // ks-deva-in
            "ZZZ"u8 + // ksb
            "ZZZ"u8 + // ksb-tz
            "ZZZ"u8 + // ksf
            "ZZZ"u8 + // ksf-cm
            "ZZZ"u8 + // ksh
            "ZZZ"u8 + // ksh-de
            "KUR"u8 + // ku
            "KUR"u8 + // ku-arab
            "KUR"u8 + // ku-arab-iq
            "ZZZ"u8 + // ku-arab-ir
            "ZZZ"u8 + // kw
            "ZZZ"u8 + // kw-gb
            "KYR"u8 + // ky
            "KYR"u8 + // ky-kg
            "ZZZ"u8 + // la
            "ZZZ"u8 + // la-001
            "ZZZ"u8 + // lag
            "ZZZ"u8 + // lag-tz
            "LBX"u8 + // lb
            "LBX"u8 + // lb-lu
            "ZZZ"u8 + // lg
            "ZZZ"u8 + // lg-ug
            "ZZZ"u8 + // lkt
            "ZZZ"u8 + // lkt-us
            "ZZZ"u8 + // ln
            "ZZZ"u8 + // ln-ao
            "ZZZ"u8 + // ln-cd
            "ZZZ"u8 + // ln-cf
            "ZZZ"u8 + // ln-cg
            "LAO"u8 + // lo
            "LAO"u8 + // lo-la
            "ZZZ"u8 + // lrc
            "ZZZ"u8 + // lrc-iq
            "ZZZ"u8 + // lrc-ir
            "LTH"u8 + // lt
            "LTH"u8 + // lt-lt
            "ZZZ"u8 + // lu
            "ZZZ"u8 + // lu-cd
            "ZZZ"u8 + // luo
            "ZZZ"u8 + // luo-ke
            "ZZZ"u8 + // luy
            "ZZZ"u8 + // luy-ke
            "LVI"u8 + // lv
            "LVI"u8 + // lv-lv
            "ZZZ"u8 + // mas
            "ZZZ"u8 + // mas-ke
            "ZZZ"u8 + // mas-tz
            "ZZZ"u8 + // mer
            "ZZZ"u8 + // mer-ke
            "ZZZ"u8 + // mfe
            "ZZZ"u8 + // mfe-mu
            "MLG"u8 + // mg
            "MLG"u8 + // mg-mg
            "ZZZ"u8 + // mgh
            "ZZZ"u8 + // mgh-mz
            "ZZZ"u8 + // mgo
            "ZZZ"u8 + // mgo-cm
            "MRI"u8 + // mi
            "MRI"u8 + // mi-nz
            "MKI"u8 + // mk
            "MKI"u8 + // mk-mk
            "MYM"u8 + // ml
            "MYM"u8 + // ml-in
            "MON"u8 + // mn
            "MNN"u8 + // mn-cyrl
            "MNN"u8 + // mn-mn
            "MNG"u8 + // mn-mong
            "MNG"u8 + // mn-mong-cn
            "MNM"u8 + // mn-mong-mn
            "ZZZ"u8 + // mni
            "ZZZ"u8 + // mni-in
            "MWK"u8 + // moh
            "MWK"u8 + // moh-ca
            "MAR"u8 + // mr
            "MAR"u8 + // mr-in
            "MSL"u8 + // ms
            "MSB"u8 + // ms-bn
            "MSL"u8 + // ms-my
            "ZZZ"u8 + // ms-sg
            "MLT"u8 + // mt
            "MLT"u8 + // mt-mt
            "ZZZ"u8 + // mua
            "ZZZ"u8 + // mua-cm
            "MYA"u8 + // my
            "MYA"u8 + // my-mm
            "ZZZ"u8 + // mzn
            "ZZZ"u8 + // mzn-ir
            "ZZZ"u8 + // naq
            "ZZZ"u8 + // naq-na
            "NOR"u8 + // nb
            "NOR"u8 + // nb-no
            "ZZZ"u8 + // nb-sj
            "ZZZ"u8 + // nd
            "ZZZ"u8 + // nd-zw
            "ZZZ"u8 + // nds
            "ZZZ"u8 + // nds-de
            "ZZZ"u8 + // nds-nl
            "NEP"u8 + // ne
            "NEI"u8 + // ne-in
            "NEP"u8 + // ne-np
            "NLD"u8 + // nl
            "ZZZ"u8 + // nl-aw
            "NLB"u8 + // nl-be
            "ZZZ"u8 + // nl-bq
            "ZZZ"u8 + // nl-cw
            "NLD"u8 + // nl-nl
            "ZZZ"u8 + // nl-sr
            "ZZZ"u8 + // nl-sx
            "ZZZ"u8 + // nmg
            "ZZZ"u8 + // nmg-cm
            "NON"u8 + // nn
            "NON"u8 + // nn-no
            "ZZZ"u8 + // nnh
            "ZZZ"u8 + // nnh-cm
            "NOR"u8 + // no
            "NQO"u8 + // nqo
            "NQO"u8 + // nqo-gn
            "ZZZ"u8 + // nr
            "ZZZ"u8 + // nr-za
            "NSO"u8 + // nso
            "NSO"u8 + // nso-za
            "ZZZ"u8 + // nus
            "ZZZ"u8 + // nus-ss
            "ZZZ"u8 + // nyn
            "ZZZ"u8 + // nyn-ug
            "OCI"u8 + // oc
            "OCI"u8 + // oc-fr
            "ORM"u8 + // om
            "ORM"u8 + // om-et
            "ZZZ"u8 + // om-ke
            "ORI"u8 + // or
            "ORI"u8 + // or-in
            "ZZZ"u8 + // os
            "ZZZ"u8 + // os-ge
            "ZZZ"u8 + // os-ru
            "PAN"u8 + // pa
            "PAP"u8 + // pa-arab
            "PAP"u8 + // pa-arab-pk
            "PAN"u8 + // pa-in
            "ZZZ"u8 + // pap
            "ZZZ"u8 + // pap-029
            "PLK"u8 + // pl
            "PLK"u8 + // pl-pl
            "ZZZ"u8 + // prg
            "ZZZ"u8 + // prg-001
            "PRS"u8 + // prs
            "PRS"u8 + // prs-af
            "PAS"u8 + // ps
            "PAS"u8 + // ps-af
            "PTB"u8 + // pt
            "PTA"u8 + // pt-ao
            "PTB"u8 + // pt-br
            "ZZZ"u8 + // pt-ch
            "ZZZ"u8 + // pt-cv
            "ZZZ"u8 + // pt-gq
            "ZZZ"u8 + // pt-gw
            "ZZZ"u8 + // pt-lu
            "ZZZ"u8 + // pt-mo
            "ZZZ"u8 + // pt-mz
            "PTG"u8 + // pt-pt
            "ZZZ"u8 + // pt-st
            "ZZZ"u8 + // pt-tl
            "ENJ"u8 + // qps-latn-x-sh
            "ENU"u8 + // qps-ploc
            "JPN"u8 + // qps-ploca
            "ARA"u8 + // qps-plocm
            "QUC"u8 + // quc
            "QUT"u8 + // quc-latn
            "QUT"u8 + // quc-latn-gt
            "QUB"u8 + // quz
            "QUB"u8 + // quz-bo
            "QUE"u8 + // quz-ec
            "QUP"u8 + // quz-pe
            "RMC"u8 + // rm
            "RMC"u8 + // rm-ch
            "ZZZ"u8 + // rn
            "ZZZ"u8 + // rn-bi
            "ROM"u8 + // ro
            "ROD"u8 + // ro-md
            "ROM"u8 + // ro-ro
            "ZZZ"u8 + // rof
            "ZZZ"u8 + // rof-tz
            "RUS"u8 + // ru
            "ZZZ"u8 + // ru-by
            "ZZZ"u8 + // ru-kg
            "ZZZ"u8 + // ru-kz
            "RUM"u8 + // ru-md
            "RUS"u8 + // ru-ru
            "ZZZ"u8 + // ru-ua
            "KIN"u8 + // rw
            "KIN"u8 + // rw-rw
            "ZZZ"u8 + // rwk
            "ZZZ"u8 + // rwk-tz
            "SAN"u8 + // sa
            "SAN"u8 + // sa-in
            "SAH"u8 + // sah
            "SAH"u8 + // sah-ru
            "ZZZ"u8 + // saq
            "ZZZ"u8 + // saq-ke
            "ZZZ"u8 + // sbp
            "ZZZ"u8 + // sbp-tz
            "SIP"u8 + // sd
            "SIP"u8 + // sd-arab
            "SIP"u8 + // sd-arab-pk
            "ZZZ"u8 + // sd-deva
            "ZZZ"u8 + // sd-deva-in
            "SME"u8 + // se
            "SMG"u8 + // se-fi
            "SME"u8 + // se-no
            "SMF"u8 + // se-se
            "ZZZ"u8 + // seh
            "ZZZ"u8 + // seh-mz
            "ZZZ"u8 + // ses
            "ZZZ"u8 + // ses-ml
            "ZZZ"u8 + // sg
            "ZZZ"u8 + // sg-cf
            "ZZZ"u8 + // shi
            "ZZZ"u8 + // shi-latn
            "ZZZ"u8 + // shi-latn-ma
            "ZZZ"u8 + // shi-tfng
            "ZZZ"u8 + // shi-tfng-ma
            "SIN"u8 + // si
            "SIN"u8 + // si-lk
            "SKY"u8 + // sk
            "SKY"u8 + // sk-sk
            "SLV"u8 + // sl
            "SLV"u8 + // sl-si
            "SMB"u8 + // sma
            "SMA"u8 + // sma-no
            "SMB"u8 + // sma-se
            "SMK"u8 + // smj
            "SMJ"u8 + // smj-no
            "SMK"u8 + // smj-se
            "SMN"u8 + // smn
            "SMN"u8 + // smn-fi
            "SMS"u8 + // sms
            "SMS"u8 + // sms-fi
            "SNA"u8 + // sn
            "SNA"u8 + // sn-latn
            "SNA"u8 + // sn-latn-zw
            "SOM"u8 + // so
            "ZZZ"u8 + // so-dj
            "ZZZ"u8 + // so-et
            "ZZZ"u8 + // so-ke
            "SOM"u8 + // so-so
            "SQI"u8 + // sq
            "SQI"u8 + // sq-al
            "ZZZ"u8 + // sq-mk
            "ZZZ"u8 + // sq-xk
            "SRB"u8 + // sr
            "SRO"u8 + // sr-cyrl
            "SRN"u8 + // sr-cyrl-ba
            "SRB"u8 + // sr-cyrl-cs
            "SRQ"u8 + // sr-cyrl-me
            "SRO"u8 + // sr-cyrl-rs
            "ZZZ"u8 + // sr-cyrl-xk
            "SRM"u8 + // sr-latn
            "SRS"u8 + // sr-latn-ba
            "SRL"u8 + // sr-latn-cs
            "SRP"u8 + // sr-latn-me
            "SRM"u8 + // sr-latn-rs
            "ZZZ"u8 + // sr-latn-xk
            "ZZZ"u8 + // ss
            "ZZZ"u8 + // ss-sz
            "ZZZ"u8 + // ss-za
            "ZZZ"u8 + // ssy
            "ZZZ"u8 + // ssy-er
            "SOT"u8 + // st
            "ZZZ"u8 + // st-ls
            "SOT"u8 + // st-za
            "SVE"u8 + // sv
            "ZZZ"u8 + // sv-ax
            "SVF"u8 + // sv-fi
            "SVE"u8 + // sv-se
            "SWK"u8 + // sw
            "ZZZ"u8 + // sw-cd
            "SWK"u8 + // sw-ke
            "ZZZ"u8 + // sw-tz
            "ZZZ"u8 + // sw-ug
            "ZZZ"u8 + // swc
            "ZZZ"u8 + // swc-cd
            "SYR"u8 + // syr
            "SYR"u8 + // syr-sy
            "TAI"u8 + // ta
            "TAI"u8 + // ta-in
            "TAM"u8 + // ta-lk
            "ZZZ"u8 + // ta-my
            "ZZZ"u8 + // ta-sg
            "TEL"u8 + // te
            "TEL"u8 + // te-in
            "ZZZ"u8 + // teo
            "ZZZ"u8 + // teo-ke
            "ZZZ"u8 + // teo-ug
            "TAJ"u8 + // tg
            "TAJ"u8 + // tg-cyrl
            "TAJ"u8 + // tg-cyrl-tj
            "THA"u8 + // th
            "THA"u8 + // th-th
            "TIR"u8 + // ti
            "TIR"u8 + // ti-er
            "TIE"u8 + // ti-et
            "ZZZ"u8 + // tig
            "ZZZ"u8 + // tig-er
            "TUK"u8 + // tk
            "TUK"u8 + // tk-tm
            "TSN"u8 + // tn
            "TSB"u8 + // tn-bw
            "TSN"u8 + // tn-za
            "ZZZ"u8 + // to
            "ZZZ"u8 + // to-to
            "TRK"u8 + // tr
            "ZZZ"u8 + // tr-cy
            "TRK"u8 + // tr-tr
            "TSO"u8 + // ts
            "TSO"u8 + // ts-za
            "TTT"u8 + // tt
            "TTT"u8 + // tt-ru
            "ZZZ"u8 + // twq
            "ZZZ"u8 + // twq-ne
            "TZA"u8 + // tzm
            "ZZZ"u8 + // tzm-arab
            "ZZZ"u8 + // tzm-arab-ma
            "TZA"u8 + // tzm-latn
            "TZA"u8 + // tzm-latn-dz
            "ZZZ"u8 + // tzm-latn-ma
            "TZM"u8 + // tzm-tfng
            "TZM"u8 + // tzm-tfng-ma
            "UIG"u8 + // ug
            "UIG"u8 + // ug-cn
            "UKR"u8 + // uk
            "UKR"u8 + // uk-ua
            "URD"u8 + // ur
            "URI"u8 + // ur-in
            "URD"u8 + // ur-pk
            "UZB"u8 + // uz
            "ZZZ"u8 + // uz-arab
            "ZZZ"u8 + // uz-arab-af
            "UZC"u8 + // uz-cyrl
            "UZC"u8 + // uz-cyrl-uz
            "UZB"u8 + // uz-latn
            "UZB"u8 + // uz-latn-uz
            "ZZZ"u8 + // vai
            "ZZZ"u8 + // vai-latn
            "ZZZ"u8 + // vai-latn-lr
            "ZZZ"u8 + // vai-vaii
            "ZZZ"u8 + // vai-vaii-lr
            "ZZZ"u8 + // ve
            "ZZZ"u8 + // ve-za
            "VIT"u8 + // vi
            "VIT"u8 + // vi-vn
            "ZZZ"u8 + // vo
            "ZZZ"u8 + // vo-001
            "ZZZ"u8 + // vun
            "ZZZ"u8 + // vun-tz
            "ZZZ"u8 + // wae
            "ZZZ"u8 + // wae-ch
            "ZZZ"u8 + // wal
            "ZZZ"u8 + // wal-et
            "WOL"u8 + // wo
            "WOL"u8 + // wo-sn
            "IVL"u8 + // x-iv_mathan
            "XHO"u8 + // xh
            "XHO"u8 + // xh-za
            "ZZZ"u8 + // xog
            "ZZZ"u8 + // xog-ug
            "ZZZ"u8 + // yav
            "ZZZ"u8 + // yav-cm
            "ZZZ"u8 + // yi
            "ZZZ"u8 + // yi-001
            "YOR"u8 + // yo
            "ZZZ"u8 + // yo-bj
            "YOR"u8 + // yo-ng
            "ZZZ"u8 + // yue
            "ZZZ"u8 + // yue-hk
            "ZHG"u8 + // zgh
            "ZHG"u8 + // zgh-tfng
            "ZHG"u8 + // zgh-tfng-ma
            "CHS"u8 + // zh
            "CHS"u8 + // zh-chs
            "CHT"u8 + // zh-cht
            "CHS"u8 + // zh-cn
            "CHS"u8 + // zh-cn_phoneb
            "CHS"u8 + // zh-cn_stroke
            "CHS"u8 + // zh-hans
            "ZZZ"u8 + // zh-hans-hk
            "ZZZ"u8 + // zh-hans-mo
            "ZHH"u8 + // zh-hant
            "ZHH"u8 + // zh-hk
            "ZHH"u8 + // zh-hk_radstr
            "ZHM"u8 + // zh-mo
            "ZHM"u8 + // zh-mo_radstr
            "ZHM"u8 + // zh-mo_stroke
            "ZHI"u8 + // zh-sg
            "ZHI"u8 + // zh-sg_phoneb
            "ZHI"u8 + // zh-sg_stroke
            "CHT"u8 + // zh-tw
            "CHT"u8 + // zh-tw_pronun
            "CHT"u8 + // zh-tw_radstr
            "ZUL"u8 + // zu
            "ZUL"u8;  // zu-za

        internal const int CommaSep              = 0 << 16;
        internal const int SemicolonSep          = 1 << 16;
        internal const int ArabicCommaSep        = 2 << 16;
        internal const int ArabicSemicolonSep    = 3 << 16;
        internal const int DoubleCommaSep        = 4 << 16;

        private static ReadOnlySpan<byte> NameIndexToNumericData => // CulturesCount * NumericLocaleDataBytesPerRow
        [
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x49, 0x11, 0x00,  0x30, 0xf0,  // 0    - aa
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x3e, 0x11, 0x00,  0x10, 0xf0,  // 1    - aa-dj
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x47, 0x11, 0x00,  0x20, 0xf0,  // 2    - aa-er
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x49, 0x11, 0x00,  0x30, 0xf0,  // 3    - aa-et
            0x00, 0x00, 0x36, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x00,  0x60, 0x06,  // 4    - af
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xfe, 0x11, 0x00,  0x50, 0xf0,  // 5    - af-na
            0x00, 0x04, 0x36, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x00,  0x60, 0x06,  // 6    - af-za
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x00,  0x80, 0xf0,  // 7    - agq
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x00,  0x80, 0xf0,  // 8    - agq-cm
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x59, 0x11, 0x00,  0xa0, 0xf0,  // 9    - ak
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x59, 0x11, 0x00,  0xa0, 0xf0,  // 10   - ak-gh
            0x00, 0x00, 0x5e, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x49, 0x11, 0x00,  0xc0, 0x8f,  // 11   - am
            0x00, 0x04, 0x5e, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x49, 0x11, 0x00,  0xc0, 0x8f,  // 12   - am-et
            0x00, 0x00, 0x01, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xcd, 0x10, 0x02,  0x10, 0x8f,  // 13   - ar
            0x00, 0x10, 0x00, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x98, 0x9e, 0x10, 0x00,  0xe0, 0xf0,  // 14   - ar-001
            0x00, 0x38, 0x01, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xe0, 0x10, 0x00,  0xf0, 0x8f,  // 15   - ar-ae
            0x00, 0x3c, 0x01, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x11, 0x10, 0x01,  0x00, 0x8f,  // 16   - ar-bh
            0x00, 0x10, 0x00, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x3e, 0x10, 0x01,  0x10, 0xf0,  // 17   - ar-dj
            0x00, 0x14, 0x01, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x04, 0x11, 0x01,  0x21, 0x2c,  // 18   - ar-dz
            0x00, 0x0c, 0x01, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x43, 0x10, 0x01,  0x30, 0x8f,  // 19   - ar-eg
            0x00, 0x10, 0x00, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x47, 0x10, 0x01,  0x40, 0xf0,  // 20   - ar-er
            0x00, 0x10, 0x00, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x75, 0x10, 0x01,  0x50, 0xf0,  // 21   - ar-il
            0x00, 0x08, 0x01, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x79, 0x10, 0x01,  0x60, 0x8f,  // 22   - ar-iq
            0x00, 0x2c, 0x01, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x7e, 0x10, 0x01,  0x70, 0x8f,  // 23   - ar-jo
            0x00, 0x10, 0x00, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x32, 0x10, 0x01,  0x80, 0xf0,  // 24   - ar-km
            0x00, 0x34, 0x01, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x88, 0x10, 0x01,  0x90, 0x8f,  // 25   - ar-kw
            0x00, 0x30, 0x01, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x8b, 0x10, 0x01,  0xa0, 0x8f,  // 26   - ar-lb
            0x00, 0x10, 0x01, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x94, 0x11, 0x01,  0xb0, 0x8f,  // 27   - ar-ly
            0x00, 0x18, 0x01, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x9f, 0x11, 0x01,  0xc1, 0x2c,  // 28   - ar-ma
            0x00, 0x10, 0x00, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xa2, 0x10, 0x01,  0xd0, 0xf0,  // 29   - ar-mr
            0x00, 0x20, 0x01, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xa4, 0x10, 0x01,  0xe0, 0x8f,  // 30   - ar-om
            0x00, 0x10, 0x00, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xb8, 0x10, 0x01,  0xf0, 0xf0,  // 31   - ar-ps
            0x00, 0x40, 0x01, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xc5, 0x10, 0x02,  0x00, 0x8f,  // 32   - ar-qa
            0x00, 0x04, 0x01, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xcd, 0x10, 0x02,  0x10, 0x8f,  // 33   - ar-sa
            0x00, 0x10, 0x00, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xdb, 0x10, 0x02,  0x20, 0xf0,  // 34   - ar-sd
            0x00, 0x10, 0x00, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xd8, 0x10, 0x02,  0x30, 0xf0,  // 35   - ar-so
            0x00, 0x10, 0x00, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x01, 0x14, 0x10, 0x02,  0x40, 0xf0,  // 36   - ar-ss
            0x00, 0x28, 0x01, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xde, 0x10, 0x02,  0x50, 0x8f,  // 37   - ar-sy
            0x00, 0x10, 0x00, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x29, 0x10, 0x02,  0x60, 0xf0,  // 38   - ar-td
            0x00, 0x1c, 0x01, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xea, 0x11, 0x02,  0x71, 0x2c,  // 39   - ar-tn
            0x00, 0x24, 0x01, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x01, 0x05, 0x10, 0x02,  0x80, 0x8f,  // 40   - ar-ye
            0x00, 0x00, 0x7a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x2e, 0x01, 0x02,  0xa0, 0x2a,  // 41   - arn
            0x00, 0x04, 0x7a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x2e, 0x01, 0x02,  0xa0, 0x2a,  // 42   - arn-cl
            0x00, 0x00, 0x4d, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x02,  0xc0, 0x8f,  // 43   - as
            0x00, 0x04, 0x4d, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x02,  0xc0, 0x8f,  // 44   - as-in
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x02,  0xe0, 0xf0,  // 45   - asa
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x02,  0xe0, 0xf0,  // 46   - asa-tz
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd9, 0x11, 0x03,  0x00, 0xf0,  // 47   - ast
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd9, 0x11, 0x03,  0x00, 0xf0,  // 48   - ast-es
            0x00, 0x00, 0x2c, 0x4e,  0x63, 0x59, 0x27, 0x61,  0x51, 0xa9, 0x00, 0x00,  0x00, 0x05, 0x11, 0x03,  0x50, 0x35,  // 49   - az
            0x00, 0x74, 0x2c, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0x05, 0x11, 0x03,  0x30, 0x33,  // 50   - az-cyrl
            0x00, 0x08, 0x2c, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0x05, 0x11, 0x03,  0x30, 0x33,  // 51   - az-cyrl-az
            0x00, 0x78, 0x2c, 0x4e,  0x63, 0x59, 0x27, 0x61,  0x51, 0xa9, 0x00, 0x00,  0x00, 0x05, 0x11, 0x03,  0x50, 0x35,  // 52   - az-latn
            0x00, 0x04, 0x2c, 0x4e,  0x63, 0x59, 0x27, 0x61,  0x51, 0xa9, 0x00, 0x00,  0x00, 0x05, 0x11, 0x03,  0x50, 0x35,  // 53   - az-latn-az
            0x00, 0x00, 0x6d, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0xcb, 0x11, 0x03,  0x70, 0x37,  // 54   - ba
            0x00, 0x04, 0x6d, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0xcb, 0x11, 0x03,  0x70, 0x37,  // 55   - ba-ru
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x03,  0x90, 0xf0,  // 56   - bas
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x03,  0x90, 0xf0,  // 57   - bas-cm
            0x00, 0x00, 0x23, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x1d, 0x11, 0x03,  0xb0, 0x3b,  // 58   - be
            0x00, 0x04, 0x23, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x1d, 0x11, 0x03,  0xb0, 0x3b,  // 59   - be-by
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x07, 0x11, 0x03,  0xd0, 0xf0,  // 60   - bem
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x07, 0x11, 0x03,  0xd0, 0xf0,  // 61   - bem-zm
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x03,  0xf0, 0xf0,  // 62   - bez
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x03,  0xf0, 0xf0,  // 63   - bez-tz
            0x00, 0x00, 0x02, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x52, 0x21, 0x00, 0x00,  0x00, 0x23, 0x11, 0x04,  0x10, 0x41,  // 64   - bg
            0x00, 0x04, 0x02, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x52, 0x21, 0x00, 0x00,  0x00, 0x23, 0x11, 0x04,  0x10, 0x41,  // 65   - bg-bg
            0x00, 0x00, 0x66, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xaf, 0x11, 0x04,  0x30, 0xf0,  // 66   - bin
            0x00, 0x04, 0x66, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xaf, 0x11, 0x04,  0x30, 0xf0,  // 67   - bin-ng
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9d, 0x11, 0x04,  0x60, 0xf0,  // 68   - bm
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9d, 0x11, 0x04,  0x60, 0xf0,  // 69   - bm-latn
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9d, 0x11, 0x04,  0x60, 0xf0,  // 70   - bm-latn-ml
            0x00, 0x00, 0x45, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x17, 0x01, 0x04,  0x80, 0x8f,  // 71   - bn
            0x00, 0x08, 0x45, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x17, 0x01, 0x04,  0x80, 0x8f,  // 72   - bn-bd
            0x00, 0x04, 0x45, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x04,  0x90, 0x8f,  // 73   - bn-in
            0x00, 0x00, 0x51, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2d, 0x01, 0x04,  0xb0, 0x8f,  // 74   - bo
            0x00, 0x04, 0x51, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2d, 0x01, 0x04,  0xb0, 0x8f,  // 75   - bo-cn
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x11, 0x04,  0xc0, 0xf0,  // 76   - bo-in
            0x00, 0x00, 0x7e, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x54, 0x11, 0x04,  0xe0, 0x4e,  // 77   - br
            0x00, 0x04, 0x7e, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x54, 0x11, 0x04,  0xe0, 0x4e,  // 78   - br-fr
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x11, 0x05,  0x00, 0xf0,  // 79   - brx
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x11, 0x05,  0x00, 0xf0,  // 80   - brx-in
            0x00, 0x78, 0x1a, 0x4e,  0x23, 0x54, 0x27, 0x62,  0x03, 0x66, 0x00, 0x00,  0x00, 0x19, 0x11, 0x05,  0x50, 0x55,  // 81   - bs
            0x00, 0x64, 0x1a, 0x4e,  0x33, 0x57, 0x27, 0x62,  0x03, 0x66, 0x00, 0x00,  0x00, 0x19, 0x11, 0x05,  0x30, 0x53,  // 82   - bs-cyrl
            0x00, 0x20, 0x1a, 0x4e,  0x33, 0x57, 0x27, 0x62,  0x03, 0x66, 0x00, 0x00,  0x00, 0x19, 0x11, 0x05,  0x30, 0x53,  // 83   - bs-cyrl-ba
            0x00, 0x68, 0x1a, 0x4e,  0x23, 0x54, 0x27, 0x62,  0x03, 0x66, 0x00, 0x00,  0x00, 0x19, 0x11, 0x05,  0x50, 0x55,  // 84   - bs-latn
            0x00, 0x14, 0x1a, 0x4e,  0x23, 0x54, 0x27, 0x62,  0x03, 0x66, 0x00, 0x00,  0x00, 0x19, 0x11, 0x05,  0x50, 0x55,  // 85   - bs-latn-ba
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x47, 0x11, 0x05,  0x70, 0xf0,  // 86   - byn
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x47, 0x11, 0x05,  0x70, 0xf0,  // 87   - byn-er
            0x00, 0x00, 0x03, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd9, 0x11, 0x05,  0xa0, 0x5a,  // 88   - ca
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x08, 0x11, 0x05,  0x90, 0xf0,  // 89   - ca-ad
            0x00, 0x04, 0x03, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd9, 0x11, 0x05,  0xa0, 0x5a,  // 90   - ca-es
            0x00, 0x08, 0x03, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd9, 0x11, 0x05,  0xb0, 0x5a,  // 91   - ca-es-valencia
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x54, 0x11, 0x05,  0xc0, 0xf0,  // 92   - ca-fr
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x76, 0x11, 0x05,  0xd0, 0xf0,  // 93   - ca-it
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xcb, 0x11, 0x05,  0xf0, 0xf0,  // 94   - ce
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xcb, 0x11, 0x05,  0xf0, 0xf0,  // 95   - ce-ru
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf0, 0x11, 0x06,  0x10, 0xf0,  // 96   - cgg
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf0, 0x11, 0x06,  0x10, 0xf0,  // 97   - cgg-ug
            0x00, 0x00, 0x5c, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf4, 0x01, 0x06,  0x40, 0xf0,  // 98   - chr
            0x00, 0x7c, 0x5c, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf4, 0x01, 0x06,  0x40, 0xf0,  // 99   - chr-cher
            0x00, 0x04, 0x5c, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf4, 0x01, 0x06,  0x40, 0xf0,  // 100  - chr-cher-us
            0x00, 0x00, 0x83, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x54, 0x11, 0x06,  0x60, 0x66,  // 101  - co
            0x00, 0x04, 0x83, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x54, 0x11, 0x06,  0x60, 0x66,  // 102  - co-fr
            0x00, 0x00, 0x05, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x4b, 0x11, 0x06,  0x80, 0x68,  // 103  - cs
            0x00, 0x04, 0x05, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x4b, 0x11, 0x06,  0x80, 0x68,  // 104  - cs-cz
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xcb, 0x11, 0x06,  0xa0, 0xf0,  // 105  - cu
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xcb, 0x11, 0x06,  0xa0, 0xf0,  // 106  - cu-ru
            0x00, 0x00, 0x52, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3d, 0x00, 0x00,  0x00, 0xf2, 0x11, 0x06,  0xc0, 0x6c,  // 107  - cy
            0x00, 0x04, 0x52, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3d, 0x00, 0x00,  0x00, 0xf2, 0x11, 0x06,  0xc0, 0x6c,  // 108  - cy-gb
            0x00, 0x00, 0x06, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x35, 0x00, 0x00,  0x00, 0x3d, 0x11, 0x06,  0xe0, 0x6e,  // 109  - da
            0x00, 0x04, 0x06, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x35, 0x00, 0x00,  0x00, 0x3d, 0x11, 0x06,  0xe0, 0x6e,  // 110  - da-dk
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x5d, 0x11, 0x06,  0xf0, 0xf0,  // 111  - da-gl
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x07,  0x10, 0xf0,  // 112  - dav
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x07,  0x10, 0xf0,  // 113  - dav-ke
            0x00, 0x00, 0x07, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x31, 0x00, 0x00,  0x00, 0x5e, 0x11, 0x07,  0x60, 0x76,  // 114  - de
            0x00, 0x0c, 0x07, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x31, 0x00, 0x00,  0x00, 0x0e, 0x11, 0x07,  0x30, 0x73,  // 115  - de-at
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x31, 0x00, 0x00,  0x00, 0x15, 0x11, 0x07,  0x40, 0xf0,  // 116  - de-be
            0x00, 0x08, 0x07, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x31, 0x00, 0x00,  0x00, 0xdf, 0x11, 0x07,  0x50, 0x75,  // 117  - de-ch
            0x00, 0x04, 0x07, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x31, 0x00, 0x00,  0x00, 0x5e, 0x11, 0x07,  0x60, 0x76,  // 118  - de-de
            0x01, 0x04, 0x07, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x31, 0x00, 0x00,  0x00, 0x5e, 0x11, 0x07,  0x60, 0x76,  // 119  - de-de_phoneb
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x76, 0x11, 0x07,  0x80, 0xf0,  // 120  - de-it
            0x00, 0x14, 0x07, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x31, 0x00, 0x00,  0x00, 0x91, 0x11, 0x07,  0x90, 0x79,  // 121  - de-li
            0x00, 0x10, 0x07, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x31, 0x00, 0x00,  0x00, 0x93, 0x11, 0x07,  0xa0, 0x7a,  // 122  - de-lu
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xad, 0x11, 0x07,  0xc0, 0xf0,  // 123  - dje
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xad, 0x11, 0x07,  0xc0, 0xf0,  // 124  - dje-ne
            0x00, 0x7c, 0x2e, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x03, 0x66, 0x00, 0x00,  0x00, 0x5e, 0x11, 0x07,  0xe0, 0x7e,  // 125  - dsb
            0x00, 0x08, 0x2e, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x03, 0x66, 0x00, 0x00,  0x00, 0x5e, 0x11, 0x07,  0xe0, 0x7e,  // 126  - dsb-de
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x08,  0x00, 0xf0,  // 127  - dua
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x08,  0x00, 0xf0,  // 128  - dua-cm
            0x00, 0x00, 0x65, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xa5, 0x21, 0x08,  0x20, 0x8f,  // 129  - dv
            0x00, 0x04, 0x65, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xa5, 0x21, 0x08,  0x20, 0x8f,  // 130  - dv-mv
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd2, 0x11, 0x08,  0x40, 0xf0,  // 131  - dyo
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd2, 0x11, 0x08,  0x40, 0xf0,  // 132  - dyo-sn
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x22, 0x12, 0x08,  0x60, 0xf0,  // 133  - dz
            0x00, 0x0c, 0x51, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x22, 0x12, 0x08,  0x60, 0xf0,  // 134  - dz-bt
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x08,  0x80, 0xf0,  // 135  - ebu
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x08,  0x80, 0xf0,  // 136  - ebu-ke
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x59, 0x11, 0x08,  0xa0, 0xf0,  // 137  - ee
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x59, 0x11, 0x08,  0xa0, 0xf0,  // 138  - ee-gh
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xe8, 0x11, 0x08,  0xb0, 0xf0,  // 139  - ee-tg
            0x00, 0x00, 0x08, 0x4e,  0x52, 0xe1, 0x27, 0x16,  0x4f, 0x31, 0x00, 0x00,  0x00, 0x62, 0x11, 0x08,  0xe0, 0x8e,  // 140  - el
            0x00, 0x10, 0x00, 0x4e,  0x52, 0xe1, 0x27, 0x16,  0x4f, 0x31, 0x00, 0x00,  0x00, 0x3b, 0x11, 0x08,  0xd0, 0xf0,  // 141  - el-cy
            0x00, 0x04, 0x08, 0x4e,  0x52, 0xe1, 0x27, 0x16,  0x4f, 0x31, 0x00, 0x00,  0x00, 0x62, 0x11, 0x08,  0xe0, 0x8e,  // 142  - el-gr
            0x00, 0x00, 0x09, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0xf4, 0x01, 0x0f,  0x00, 0xf0,  // 143  - en
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x98, 0x9e, 0x01, 0x09,  0x00, 0xf0,  // 144  - en-001
            0x00, 0x24, 0x09, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x99,  0x32, 0x48, 0x01, 0x09,  0x10, 0x91,  // 145  - en-029
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x29, 0x2d, 0x01, 0x09,  0x20, 0xf0,  // 146  - en-150
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x02, 0x01, 0x09,  0x30, 0xf0,  // 147  - en-ag
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x2c, 0x01, 0x09,  0x40, 0xf0,  // 148  - en-ai
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x0a, 0x01, 0x09,  0x50, 0xf0,  // 149  - en-as
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x0e, 0x01, 0x09,  0x60, 0xf0,  // 150  - en-at
            0x00, 0x0c, 0x09, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x0c, 0x01, 0x09,  0x70, 0x97,  // 151  - en-au
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x12, 0x01, 0x09,  0x80, 0xf0,  // 152  - en-bb
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x15, 0x01, 0x09,  0x90, 0xf0,  // 153  - en-be
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x26, 0x01, 0x09,  0xa0, 0xf0,  // 154  - en-bi
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x14, 0x01, 0x09,  0xb0, 0xf0,  // 155  - en-bm
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x16, 0x01, 0x09,  0xc0, 0xf0,  // 156  - en-bs
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x13, 0x01, 0x09,  0xd0, 0xf0,  // 157  - en-bw
            0x00, 0x28, 0x09, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x18, 0x01, 0x09,  0xe0, 0x9e,  // 158  - en-bz
            0x00, 0x10, 0x09, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0x27, 0x01, 0x09,  0xf0, 0x9f,  // 159  - en-ca
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x37, 0x01, 0x0a,  0x00, 0xf0,  // 160  - en-cc
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xdf, 0x01, 0x0a,  0x10, 0xf0,  // 161  - en-ch
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x38, 0x01, 0x0a,  0x20, 0xf0,  // 162  - en-ck
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x01, 0x0a,  0x30, 0xf0,  // 163  - en-cm
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x35, 0x01, 0x0a,  0x40, 0xf0,  // 164  - en-cx
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x3b, 0x01, 0x0a,  0x50, 0xf0,  // 165  - en-cy
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x5e, 0x01, 0x0a,  0x60, 0xf0,  // 166  - en-de
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x3d, 0x01, 0x0a,  0x70, 0xf0,  // 167  - en-dk
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x3f, 0x01, 0x0a,  0x80, 0xf0,  // 168  - en-dm
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x47, 0x01, 0x0a,  0x90, 0xf0,  // 169  - en-er
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x4d, 0x01, 0x0a,  0xa0, 0xf0,  // 170  - en-fi
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x4e, 0x01, 0x0a,  0xb0, 0xf0,  // 171  - en-fj
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x3b, 0x01, 0x0a,  0xc0, 0xf0,  // 172  - en-fk
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x50, 0x01, 0x0a,  0xd0, 0xf0,  // 173  - en-fm
            0x00, 0x08, 0x09, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3d, 0x00, 0x00,  0x00, 0xf2, 0x01, 0x0a,  0xe0, 0xae,  // 174  - en-gb
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x5b, 0x01, 0x0a,  0xf0, 0xf0,  // 175  - en-gd
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x44, 0x01, 0x0b,  0x00, 0xf0,  // 176  - en-gg
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x59, 0x01, 0x0b,  0x10, 0xf0,  // 177  - en-gh
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x5a, 0x01, 0x0b,  0x20, 0xf0,  // 178  - en-gi
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x56, 0x01, 0x0b,  0x30, 0xf0,  // 179  - en-gm
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x42, 0x01, 0x0b,  0x40, 0xf0,  // 180  - en-gu
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x65, 0x01, 0x0b,  0x50, 0xf0,  // 181  - en-gy
            0x00, 0x3c, 0x09, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x68, 0x01, 0x0b,  0x60, 0xf0,  // 182  - en-hk
            0x00, 0x38, 0x09, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x6f, 0x11, 0x0b,  0x70, 0xf0,  // 183  - en-id
            0x00, 0x18, 0x09, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x44, 0x01, 0x0b,  0x80, 0xb8,  // 184  - en-ie
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x75, 0x01, 0x0b,  0x90, 0xf0,  // 185  - en-il
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x3b, 0x16, 0x01, 0x0b,  0xa0, 0xf0,  // 186  - en-im
            0x00, 0x40, 0x09, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0x71, 0x01, 0x0b,  0xb0, 0xbb,  // 187  - en-in
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x72, 0x01, 0x0b,  0xc0, 0xf0,  // 188  - en-io
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x48, 0x01, 0x0b,  0xd0, 0xf0,  // 189  - en-je
            0x00, 0x20, 0x09, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x7c, 0x01, 0x0b,  0xe0, 0xbe,  // 190  - en-jm
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x01, 0x0b,  0xf0, 0xf0,  // 191  - en-ke
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x85, 0x01, 0x0c,  0x00, 0xf0,  // 192  - en-ki
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xcf, 0x01, 0x0c,  0x10, 0xf0,  // 193  - en-kn
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x33, 0x01, 0x0c,  0x20, 0xf0,  // 194  - en-ky
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xda, 0x01, 0x0c,  0x30, 0xf0,  // 195  - en-lc
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x8e, 0x01, 0x0c,  0x40, 0xf0,  // 196  - en-lr
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x92, 0x01, 0x0c,  0x50, 0xf0,  // 197  - en-ls
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x95, 0x01, 0x0c,  0x60, 0xf0,  // 198  - en-mg
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xc7, 0x01, 0x0c,  0x70, 0xf0,  // 199  - en-mh
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x97, 0x01, 0x0c,  0x80, 0xf0,  // 200  - en-mo
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x51, 0x01, 0x0c,  0x90, 0xf0,  // 201  - en-mp
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x4c, 0x01, 0x0c,  0xa0, 0xf0,  // 202  - en-ms
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xa3, 0x01, 0x0c,  0xb0, 0xf0,  // 203  - en-mt
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xa0, 0x01, 0x0c,  0xc0, 0xf0,  // 204  - en-mu
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9c, 0x01, 0x0c,  0xd0, 0xf0,  // 205  - en-mw
            0x00, 0x44, 0x09, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0xa7, 0x01, 0x0c,  0xe0, 0xce,  // 206  - en-my
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xfe, 0x01, 0x0c,  0xf0, 0xf0,  // 207  - en-na
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x50, 0x01, 0x0d,  0x00, 0xf0,  // 208  - en-nf
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xaf, 0x01, 0x0d,  0x10, 0xf0,  // 209  - en-ng
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xb0, 0x01, 0x0d,  0x20, 0xf0,  // 210  - en-nl
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xb4, 0x01, 0x0d,  0x30, 0xf0,  // 211  - en-nr
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x4f, 0x01, 0x0d,  0x40, 0xf0,  // 212  - en-nu
            0x00, 0x14, 0x09, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xb7, 0x01, 0x0d,  0x50, 0xd5,  // 213  - en-nz
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xc2, 0x01, 0x0d,  0x60, 0xf0,  // 214  - en-pg
            0x00, 0x34, 0x09, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xc9, 0x01, 0x0d,  0x70, 0xd7,  // 215  - en-ph
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xbe, 0x01, 0x0d,  0x80, 0xf0,  // 216  - en-pk
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x53, 0x01, 0x0d,  0x90, 0xf0,  // 217  - en-pn
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xca, 0x01, 0x0d,  0xa0, 0xf0,  // 218  - en-pr
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xc3, 0x01, 0x0d,  0xb0, 0xf0,  // 219  - en-pw
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xcc, 0x01, 0x0d,  0xc0, 0xf0,  // 220  - en-rw
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x1e, 0x01, 0x0d,  0xd0, 0xf0,  // 221  - en-sb
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd0, 0x01, 0x0d,  0xe0, 0xf0,  // 222  - en-sc
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xdb, 0x01, 0x0d,  0xf0, 0xf0,  // 223  - en-sd
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xdd, 0x01, 0x0e,  0x00, 0xf0,  // 224  - en-se
            0x00, 0x48, 0x09, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0xd7, 0x01, 0x0e,  0x10, 0xe1,  // 225  - en-sg
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x57, 0x01, 0x0e,  0x20, 0xf0,  // 226  - en-sh
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd4, 0x01, 0x0e,  0x30, 0xf0,  // 227  - en-si
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd5, 0x01, 0x0e,  0x40, 0xf0,  // 228  - en-sl
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x14, 0x01, 0x0e,  0x50, 0xf0,  // 229  - en-ss
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x78, 0xf7, 0x01, 0x0e,  0x60, 0xf0,  // 230  - en-sx
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x04, 0x01, 0x0e,  0x70, 0xf0,  // 231  - en-sz
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x5d, 0x01, 0x0e,  0x80, 0xf0,  // 232  - en-tc
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x5b, 0x01, 0x0e,  0x90, 0xf0,  // 233  - en-tk
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xe7, 0x01, 0x0e,  0xa0, 0xf0,  // 234  - en-to
            0x00, 0x2c, 0x09, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xe1, 0x01, 0x0e,  0xb0, 0xeb,  // 235  - en-tt
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xec, 0x01, 0x0e,  0xc0, 0xf0,  // 236  - en-tv
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x01, 0x0e,  0xd0, 0xf0,  // 237  - en-tz
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf0, 0x01, 0x0e,  0xe0, 0xf0,  // 238  - en-ug
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x09, 0xa5,  0x5d, 0x40, 0x01, 0x0e,  0xf0, 0xf0,  // 239  - en-um
            0x00, 0x04, 0x09, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0xf4, 0x01, 0x0f,  0x00, 0xf0,  // 240  - en-us
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf8, 0x01, 0x0f,  0x10, 0xf0,  // 241  - en-vc
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x5f, 0x01, 0x0f,  0x20, 0xf0,  // 242  - en-vg
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xfc, 0x01, 0x0f,  0x30, 0xf0,  // 243  - en-vi
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xae, 0x01, 0x0f,  0x40, 0xf0,  // 244  - en-vu
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x03, 0x01, 0x0f,  0x50, 0xf0,  // 245  - en-ws
            0x00, 0x1c, 0x09, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x01, 0x0f,  0x60, 0xf6,  // 246  - en-za
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x07, 0x01, 0x0f,  0x70, 0xf0,  // 247  - en-zm
            0x00, 0x30, 0x09, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x08, 0x01, 0x0f,  0x80, 0xf8,  // 248  - en-zw
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x98, 0x9e, 0x11, 0x0f,  0xa0, 0xf0,  // 249  - eo
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x98, 0x9e, 0x11, 0x0f,  0xa0, 0xf0,  // 250  - eo-001
            0x00, 0x00, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0xd9, 0x11, 0x10,  0x61, 0x06,  // 251  - es
            0x00, 0x58, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x09, 0xa5,  0x5d, 0x41, 0x11, 0x0f,  0xc0, 0xf0,  // 252  - es-419
            0x00, 0x2c, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x0b, 0x11, 0x0f,  0xd0, 0xfd,  // 253  - es-ar
            0x00, 0x40, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x1a, 0x11, 0x0f,  0xe0, 0xfe,  // 254  - es-bo
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x20, 0x11, 0x0f,  0xf0, 0xf0,  // 255  - es-br
            0x00, 0x34, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x2e, 0x11, 0x10,  0x01, 0x00,  // 256  - es-cl
            0x00, 0x24, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x33, 0x11, 0x10,  0x11, 0x01,  // 257  - es-co
            0x00, 0x14, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x36, 0x11, 0x10,  0x21, 0x02,  // 258  - es-cr
            0x00, 0x5c, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x38, 0x11, 0x10,  0x30, 0xf0,  // 259  - es-cu
            0x00, 0x1c, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x41, 0x11, 0x10,  0x41, 0x04,  // 260  - es-do
            0x00, 0x30, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x42, 0x11, 0x10,  0x51, 0x05,  // 261  - es-ec
            0x00, 0x0c, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0xd9, 0x11, 0x10,  0x61, 0x06,  // 262  - es-es
            0x00, 0x04, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0xd9, 0x11, 0x10,  0x71, 0x07,  // 263  - es-es_tradnl
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x45, 0x11, 0x10,  0x80, 0xf0,  // 264  - es-gq
            0x00, 0x10, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x63, 0x11, 0x10,  0x91, 0x09,  // 265  - es-gt
            0x00, 0x48, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x6a, 0x11, 0x10,  0xa1, 0x0a,  // 266  - es-hn
            0x00, 0x08, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0xa6, 0x01, 0x10,  0xb1, 0x0b,  // 267  - es-mx
            0x00, 0x4c, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0xb6, 0x11, 0x10,  0xc1, 0x0c,  // 268  - es-ni
            0x00, 0x18, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0xc0, 0x11, 0x10,  0xd1, 0x0d,  // 269  - es-pa
            0x00, 0x28, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0xbb, 0x11, 0x10,  0xe1, 0x0e,  // 270  - es-pe
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0xc9, 0x11, 0x10,  0xf0, 0xf0,  // 271  - es-ph
            0x00, 0x50, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0xca, 0x11, 0x11,  0x01, 0x10,  // 272  - es-pr
            0x00, 0x3c, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0xb9, 0x11, 0x11,  0x11, 0x11,  // 273  - es-py
            0x00, 0x44, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x48, 0x11, 0x11,  0x21, 0x12,  // 274  - es-sv
            0x00, 0x54, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0xf4, 0x01, 0x11,  0x31, 0x13,  // 275  - es-us
            0x00, 0x38, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0xf6, 0x11, 0x11,  0x41, 0x14,  // 276  - es-uy
            0x00, 0x20, 0x0a, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0xf9, 0x11, 0x11,  0x51, 0x15,  // 277  - es-ve
            0x00, 0x00, 0x25, 0x4e,  0x93, 0x07, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x46, 0x11, 0x11,  0x71, 0x17,  // 278  - et
            0x00, 0x04, 0x25, 0x4e,  0x93, 0x07, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x46, 0x11, 0x11,  0x71, 0x17,  // 279  - et-ee
            0x00, 0x00, 0x2d, 0x4e,  0x43, 0x52, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd9, 0x11, 0x11,  0x90, 0xf0,  // 280  - eu
            0x00, 0x04, 0x2d, 0x4e,  0x43, 0x52, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd9, 0x11, 0x11,  0x90, 0xf0,  // 281  - eu-es
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x11,  0xb0, 0xf0,  // 282  - ewo
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x11,  0xb0, 0xf0,  // 283  - ewo-cm
            0x00, 0x00, 0x29, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x74, 0x30, 0x11,  0xd0, 0x8f,  // 284  - fa
            0x00, 0x04, 0x29, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x74, 0x30, 0x11,  0xd0, 0x8f,  // 285  - fa-ir
            0x00, 0x00, 0x67, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xd2, 0x11, 0x12,  0x21, 0x22,  // 286  - ff
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x31, 0x11, 0x11,  0xf0, 0xf0,  // 287  - ff-cm
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x64, 0x11, 0x12,  0x00, 0xf0,  // 288  - ff-gn
            0x00, 0x7c, 0x67, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xd2, 0x11, 0x12,  0x21, 0x22,  // 289  - ff-latn
            0x00, 0x08, 0x67, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xd2, 0x11, 0x12,  0x21, 0x22,  // 290  - ff-latn-sn
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xa2, 0x11, 0x12,  0x30, 0xf0,  // 291  - ff-mr
            0x00, 0x04, 0x67, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xaf, 0x11, 0x12,  0x40, 0xf0,  // 292  - ff-ng
            0x00, 0x00, 0x0b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x36, 0x00, 0x00,  0x00, 0x4d, 0x11, 0x12,  0x61, 0x26,  // 293  - fi
            0x00, 0x04, 0x0b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x36, 0x00, 0x00,  0x00, 0x4d, 0x11, 0x12,  0x61, 0x26,  // 294  - fi-fi
            0x00, 0x00, 0x64, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xc9, 0x11, 0x12,  0x81, 0x28,  // 295  - fil
            0x00, 0x04, 0x64, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xc9, 0x11, 0x12,  0x81, 0x28,  // 296  - fil-ph
            0x00, 0x00, 0x38, 0x4e,  0x43, 0x52, 0x27, 0x5f,  0x4f, 0x35, 0x00, 0x00,  0x00, 0x51, 0x11, 0x12,  0xb1, 0x2b,  // 297  - fo
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x3d, 0x11, 0x12,  0xa0, 0xf0,  // 298  - fo-dk
            0x00, 0x04, 0x38, 0x4e,  0x43, 0x52, 0x27, 0x5f,  0x4f, 0x35, 0x00, 0x00,  0x00, 0x51, 0x11, 0x12,  0xb1, 0x2b,  // 299  - fo-fo
            0x00, 0x00, 0x0c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x54, 0x11, 0x13,  0xc1, 0x3c,  // 300  - fr
            0x00, 0x1c, 0x0c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x99,  0x32, 0x48, 0x11, 0x12,  0xd1, 0x3c,  // 301  - fr-029
            0x00, 0x08, 0x0c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x15, 0x11, 0x12,  0xe1, 0x2e,  // 302  - fr-be
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xf5, 0x11, 0x12,  0xf0, 0xf0,  // 303  - fr-bf
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x26, 0x11, 0x13,  0x00, 0xf0,  // 304  - fr-bi
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x1c, 0x11, 0x13,  0x10, 0xf0,  // 305  - fr-bj
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x09, 0xa5,  0x5c, 0x4f, 0x11, 0x13,  0x20, 0xf0,  // 306  - fr-bl
            0x00, 0x0c, 0x0c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x27, 0x11, 0x13,  0x31, 0x33,  // 307  - fr-ca
            0x00, 0x24, 0x0c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x2c, 0x11, 0x13,  0x40, 0xf0,  // 308  - fr-cd
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x37, 0x11, 0x13,  0x50, 0xf0,  // 309  - fr-cf
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x2b, 0x11, 0x13,  0x60, 0xf0,  // 310  - fr-cg
            0x00, 0x10, 0x0c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xdf, 0x11, 0x13,  0x71, 0x37,  // 311  - fr-ch
            0x00, 0x30, 0x0c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x77, 0x11, 0x13,  0x80, 0xf0,  // 312  - fr-ci
            0x00, 0x2c, 0x0c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x31, 0x11, 0x13,  0x90, 0xf0,  // 313  - fr-cm
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x3e, 0x11, 0x13,  0xa0, 0xf0,  // 314  - fr-dj
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x04, 0x11, 0x13,  0xb0, 0xf0,  // 315  - fr-dz
            0x00, 0x04, 0x0c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x54, 0x11, 0x13,  0xc1, 0x3c,  // 316  - fr-fr
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x57, 0x11, 0x13,  0xd0, 0xf0,  // 317  - fr-ga
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x01, 0x3d, 0x11, 0x13,  0xe0, 0xf0,  // 318  - fr-gf
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x64, 0x11, 0x13,  0xf0, 0xf0,  // 319  - fr-gn
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x01, 0x41, 0x11, 0x14,  0x00, 0xf0,  // 320  - fr-gp
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x45, 0x11, 0x14,  0x10, 0xf0,  // 321  - fr-gq
            0x00, 0x3c, 0x0c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x67, 0x11, 0x14,  0x20, 0xf0,  // 322  - fr-ht
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x32, 0x11, 0x14,  0x30, 0xf0,  // 323  - fr-km
            0x00, 0x14, 0x0c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x93, 0x11, 0x14,  0x41, 0x44,  // 324  - fr-lu
            0x00, 0x38, 0x0c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x9f, 0x11, 0x14,  0x50, 0xf0,  // 325  - fr-ma
            0x00, 0x18, 0x0c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x9e, 0x11, 0x14,  0x61, 0x46,  // 326  - fr-mc
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x7b, 0xda, 0x11, 0x14,  0x70, 0xf0,  // 327  - fr-mf
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x95, 0x11, 0x14,  0x80, 0xf0,  // 328  - fr-mg
            0x00, 0x34, 0x0c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x9d, 0x11, 0x14,  0x90, 0xf0,  // 329  - fr-ml
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x01, 0x4a, 0x11, 0x14,  0xa0, 0xf0,  // 330  - fr-mq
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xa2, 0x11, 0x14,  0xb0, 0xf0,  // 331  - fr-mr
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xa0, 0x11, 0x14,  0xc0, 0xf0,  // 332  - fr-mu
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x01, 0x4e, 0x11, 0x14,  0xd0, 0xf0,  // 333  - fr-nc
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xad, 0x11, 0x14,  0xe0, 0xf0,  // 334  - fr-ne
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x01, 0x3e, 0x11, 0x14,  0xf0, 0xf0,  // 335  - fr-pf
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xce, 0x11, 0x15,  0x00, 0xf0,  // 336  - fr-pm
            0x00, 0x20, 0x0c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xc6, 0x11, 0x15,  0x10, 0xf0,  // 337  - fr-re
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xcc, 0x11, 0x15,  0x20, 0xf0,  // 338  - fr-rw
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xd0, 0x11, 0x15,  0x30, 0xf0,  // 339  - fr-sc
            0x00, 0x28, 0x0c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xd2, 0x11, 0x15,  0x40, 0xf0,  // 340  - fr-sn
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xde, 0x11, 0x15,  0x50, 0xf0,  // 341  - fr-sy
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x29, 0x11, 0x15,  0x60, 0xf0,  // 342  - fr-td
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xe8, 0x11, 0x15,  0x70, 0xf0,  // 343  - fr-tg
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xea, 0x11, 0x15,  0x80, 0xf0,  // 344  - fr-tn
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xae, 0x11, 0x15,  0x90, 0xf0,  // 345  - fr-vu
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x01, 0x60, 0x11, 0x15,  0xa0, 0xf0,  // 346  - fr-wf
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x01, 0x4b, 0x11, 0x15,  0xb0, 0xf0,  // 347  - fr-yt
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x76, 0x11, 0x15,  0xd0, 0xf0,  // 348  - fur
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x76, 0x11, 0x15,  0xd0, 0xf0,  // 349  - fur-it
            0x00, 0x00, 0x62, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xb0, 0x11, 0x15,  0xf1, 0x5f,  // 350  - fy
            0x00, 0x04, 0x62, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xb0, 0x11, 0x15,  0xf1, 0x5f,  // 351  - fy-nl
            0x00, 0x00, 0x3c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x44, 0x11, 0x16,  0x11, 0x61,  // 352  - ga
            0x00, 0x08, 0x3c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x44, 0x11, 0x16,  0x11, 0x61,  // 353  - ga-ie
            0x00, 0x00, 0x91, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3d, 0x00, 0x00,  0x00, 0xf2, 0x11, 0x16,  0x31, 0x63,  // 354  - gd
            0x00, 0x04, 0x91, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3d, 0x00, 0x00,  0x00, 0xf2, 0x11, 0x16,  0x31, 0x63,  // 355  - gd-gb
            0x00, 0x00, 0x56, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd9, 0x11, 0x16,  0x51, 0x65,  // 356  - gl
            0x00, 0x04, 0x56, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd9, 0x11, 0x16,  0x51, 0x65,  // 357  - gl-es
            0x00, 0x00, 0x74, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0xb9, 0x01, 0x16,  0x71, 0x67,  // 358  - gn
            0x00, 0x04, 0x74, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0xb9, 0x01, 0x16,  0x71, 0x67,  // 359  - gn-py
            0x00, 0x00, 0x84, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xdf, 0x11, 0x16,  0x90, 0xf0,  // 360  - gsw
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xdf, 0x11, 0x16,  0x90, 0xf0,  // 361  - gsw-ch
            0x00, 0x04, 0x84, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x54, 0x11, 0x16,  0xa1, 0x6a,  // 362  - gsw-fr
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x91, 0x11, 0x16,  0xb0, 0xf0,  // 363  - gsw-li
            0x00, 0x00, 0x47, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x16,  0xd0, 0x8f,  // 364  - gu
            0x00, 0x04, 0x47, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x16,  0xd0, 0x8f,  // 365  - gu-in
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x16,  0xf0, 0xf0,  // 366  - guz
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x16,  0xf0, 0xf0,  // 367  - guz-ke
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x3b, 0x16, 0x11, 0x17,  0x10, 0xf0,  // 368  - gv
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x3b, 0x16, 0x11, 0x17,  0x10, 0xf0,  // 369  - gv-im
            0x00, 0x00, 0x68, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0xaf, 0x11, 0x17,  0x61, 0x76,  // 370  - ha
            0x00, 0x7c, 0x68, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0xaf, 0x11, 0x17,  0x61, 0x76,  // 371  - ha-latn
            0x00, 0x10, 0x00, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x59, 0x11, 0x17,  0x40, 0xf0,  // 372  - ha-latn-gh
            0x00, 0x10, 0x00, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xad, 0x11, 0x17,  0x50, 0xf0,  // 373  - ha-latn-ne
            0x00, 0x04, 0x68, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0xaf, 0x11, 0x17,  0x61, 0x76,  // 374  - ha-latn-ng
            0x00, 0x00, 0x75, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0xf4, 0x11, 0x17,  0x81, 0x78,  // 375  - haw
            0x00, 0x04, 0x75, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0xf4, 0x11, 0x17,  0x81, 0x78,  // 376  - haw-us
            0x00, 0x00, 0x0d, 0x4e,  0x73, 0x5e, 0x27, 0x15,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x75, 0x01, 0x17,  0xa0, 0x8f,  // 377  - he
            0x00, 0x04, 0x0d, 0x4e,  0x73, 0x5e, 0x27, 0x15,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x75, 0x01, 0x17,  0xa0, 0x8f,  // 378  - he-il
            0x00, 0x00, 0x39, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x17,  0xc0, 0x8f,  // 379  - hi
            0x00, 0x04, 0x39, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x17,  0xc0, 0x8f,  // 380  - hi-in
            0x00, 0x00, 0x1a, 0x4e,  0x23, 0x54, 0x27, 0x62,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x6c, 0x11, 0x17,  0xf1, 0x7f,  // 381  - hr
            0x00, 0x10, 0x1a, 0x4e,  0x23, 0x54, 0x27, 0x62,  0x03, 0x66, 0x00, 0x00,  0x00, 0x19, 0x11, 0x17,  0xe1, 0x7e,  // 382  - hr-ba
            0x00, 0x04, 0x1a, 0x4e,  0x23, 0x54, 0x27, 0x62,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x6c, 0x11, 0x17,  0xf1, 0x7f,  // 383  - hr-hr
            0x00, 0x00, 0x2e, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x03, 0x66, 0x00, 0x00,  0x00, 0x5e, 0x11, 0x18,  0x11, 0x81,  // 384  - hsb
            0x00, 0x04, 0x2e, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x03, 0x66, 0x00, 0x00,  0x00, 0x5e, 0x11, 0x18,  0x11, 0x81,  // 385  - hsb-de
            0x00, 0x00, 0x0e, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x6d, 0x11, 0x18,  0x31, 0x83,  // 386  - hu
            0x00, 0x04, 0x0e, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x6d, 0x11, 0x18,  0x31, 0x83,  // 387  - hu-hu
            0x01, 0x04, 0x0e, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x6d, 0x11, 0x18,  0x31, 0x83,  // 388  - hu-hu_technl
            0x00, 0x00, 0x2b, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x07, 0x01, 0x18,  0x61, 0x86,  // 389  - hy
            0x00, 0x04, 0x2b, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x07, 0x01, 0x18,  0x61, 0x86,  // 390  - hy-am
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x54, 0x11, 0x18,  0x90, 0xf0,  // 391  - ia
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x98, 0x9e, 0x11, 0x18,  0x80, 0xf0,  // 392  - ia-001
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x54, 0x11, 0x18,  0x90, 0xf0,  // 393  - ia-fr
            0x00, 0x00, 0x69, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xaf, 0x11, 0x18,  0xb0, 0xf0,  // 394  - ibb
            0x00, 0x04, 0x69, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xaf, 0x11, 0x18,  0xb0, 0xf0,  // 395  - ibb-ng
            0x00, 0x00, 0x21, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x6f, 0x11, 0x18,  0xd1, 0x8d,  // 396  - id
            0x00, 0x04, 0x21, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x6f, 0x11, 0x18,  0xd1, 0x8d,  // 397  - id-id
            0x00, 0x00, 0x70, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0xaf, 0x11, 0x18,  0xf1, 0x8f,  // 398  - ig
            0x00, 0x04, 0x70, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0xaf, 0x11, 0x18,  0xf1, 0x8f,  // 399  - ig-ng
            0x00, 0x00, 0x78, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2d, 0x11, 0x19,  0x10, 0x8f,  // 400  - ii
            0x00, 0x04, 0x78, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2d, 0x11, 0x19,  0x10, 0x8f,  // 401  - ii-cn
            0x00, 0x00, 0x0f, 0x4e,  0x43, 0x52, 0x27, 0x5f,  0x51, 0x87, 0x00, 0x00,  0x00, 0x6e, 0x11, 0x19,  0x31, 0x93,  // 402  - is
            0x00, 0x04, 0x0f, 0x4e,  0x43, 0x52, 0x27, 0x5f,  0x51, 0x87, 0x00, 0x00,  0x00, 0x6e, 0x11, 0x19,  0x31, 0x93,  // 403  - is-is
            0x00, 0x00, 0x10, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x38, 0x00, 0x00,  0x00, 0x76, 0x11, 0x19,  0x61, 0x96,  // 404  - it
            0x00, 0x08, 0x10, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xdf, 0x11, 0x19,  0x51, 0x95,  // 405  - it-ch
            0x00, 0x04, 0x10, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x38, 0x00, 0x00,  0x00, 0x76, 0x11, 0x19,  0x61, 0x96,  // 406  - it-it
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x38, 0x00, 0x00,  0x00, 0xd6, 0x11, 0x19,  0x70, 0xf0,  // 407  - it-sm
            0x00, 0x00, 0x5d, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0x27, 0x01, 0x19,  0xc1, 0x9c,  // 408  - iu
            0x00, 0x78, 0x5d, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x27, 0x01, 0x19,  0xa0, 0x8f,  // 409  - iu-cans
            0x00, 0x04, 0x5d, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x27, 0x01, 0x19,  0xa0, 0x8f,  // 410  - iu-cans-ca
            0x00, 0x7c, 0x5d, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0x27, 0x01, 0x19,  0xc1, 0x9c,  // 411  - iu-latn
            0x00, 0x08, 0x5d, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0x27, 0x01, 0x19,  0xc1, 0x9c,  // 412  - iu-latn-ca
            0x00, 0x00, 0x11, 0x3a,  0x43, 0xa4, 0x27, 0x11,  0x4f, 0x42, 0x00, 0x00,  0x00, 0x7a, 0x01, 0x19,  0xe1, 0x9e,  // 413  - ja
            0x00, 0x04, 0x11, 0x3a,  0x43, 0xa4, 0x27, 0x11,  0x4f, 0x42, 0x00, 0x00,  0x00, 0x7a, 0x01, 0x19,  0xe1, 0x9e,  // 414  - ja-jp
            0x04, 0x04, 0x11, 0x3a,  0x43, 0xa4, 0x27, 0x11,  0x4f, 0x42, 0x00, 0x00,  0x00, 0x7a, 0x01, 0x19,  0xe1, 0x9e,  // 415  - ja-jp_radstr
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x1a,  0x10, 0xf0,  // 416  - jgo
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x1a,  0x10, 0xf0,  // 417  - jgo-cm
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x1a,  0x30, 0xf0,  // 418  - jmc
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x1a,  0x30, 0xf0,  // 419  - jmc-tz
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x6f, 0x11, 0x1a,  0x81, 0xa8,  // 420  - jv
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x6f, 0x11, 0x1a,  0x61, 0xa8,  // 421  - jv-java
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x6f, 0x11, 0x1a,  0x61, 0xa8,  // 422  - jv-java-id
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x6f, 0x11, 0x1a,  0x81, 0xa8,  // 423  - jv-latn
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x6f, 0x11, 0x1a,  0x81, 0xa8,  // 424  - jv-latn-id
            0x00, 0x00, 0x37, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x58, 0x11, 0x1a,  0xa1, 0xaa,  // 425  - ka
            0x00, 0x04, 0x37, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x58, 0x11, 0x1a,  0xa1, 0xaa,  // 426  - ka-ge
            0x01, 0x04, 0x37, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x58, 0x11, 0x1a,  0xa1, 0xaa,  // 427  - ka-ge_modern
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x04, 0x11, 0x1a,  0xd0, 0xf0,  // 428  - kab
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x04, 0x11, 0x1a,  0xd0, 0xf0,  // 429  - kab-dz
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x1a,  0xf0, 0xf0,  // 430  - kam
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x1a,  0xf0, 0xf0,  // 431  - kam-ke
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x1b,  0x10, 0xf0,  // 432  - kde
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x1b,  0x10, 0xf0,  // 433  - kde-tz
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x39, 0x11, 0x1b,  0x30, 0xf0,  // 434  - kea
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x39, 0x11, 0x1b,  0x30, 0xf0,  // 435  - kea-cv
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9d, 0x11, 0x1b,  0x50, 0xf0,  // 436  - khq
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9d, 0x11, 0x1b,  0x50, 0xf0,  // 437  - khq-ml
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x1b,  0x70, 0xf0,  // 438  - ki
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x1b,  0x70, 0xf0,  // 439  - ki-ke
            0x00, 0x00, 0x3f, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x89, 0x11, 0x1b,  0x91, 0xb9,  // 440  - kk
            0x00, 0x04, 0x3f, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x89, 0x11, 0x1b,  0x91, 0xb9,  // 441  - kk-kz
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x1b,  0xb0, 0xf0,  // 442  - kkj
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x1b,  0xb0, 0xf0,  // 443  - kkj-cm
            0x00, 0x00, 0x6f, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x35, 0x00, 0x00,  0x00, 0x5d, 0x11, 0x1b,  0xd1, 0xbd,  // 444  - kl
            0x00, 0x04, 0x6f, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x35, 0x00, 0x00,  0x00, 0x5d, 0x11, 0x1b,  0xd1, 0xbd,  // 445  - kl-gl
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x1b,  0xf0, 0xf0,  // 446  - kln
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x1b,  0xf0, 0xf0,  // 447  - kln-ke
            0x00, 0x00, 0x53, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x28, 0x02, 0x1c,  0x10, 0x8f,  // 448  - km
            0x00, 0x04, 0x53, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x28, 0x02, 0x1c,  0x10, 0x8f,  // 449  - km-kh
            0x00, 0x00, 0x4b, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x1c,  0x30, 0x8f,  // 450  - kn
            0x00, 0x04, 0x4b, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x1c,  0x30, 0x8f,  // 451  - kn-in
            0x00, 0x00, 0x12, 0x3b,  0x53, 0xb5, 0x27, 0x13,  0x51, 0x61, 0x00, 0x00,  0x00, 0x86, 0x01, 0x1c,  0x61, 0xc6,  // 452  - ko
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x83, 0x11, 0x1c,  0x50, 0xf0,  // 453  - ko-kp
            0x00, 0x04, 0x12, 0x3b,  0x53, 0xb5, 0x27, 0x13,  0x51, 0x61, 0x00, 0x00,  0x00, 0x86, 0x01, 0x1c,  0x61, 0xc6,  // 454  - ko-kr
            0x00, 0x00, 0x57, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x1c,  0x80, 0x8f,  // 455  - kok
            0x00, 0x04, 0x57, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x1c,  0x80, 0x8f,  // 456  - kok-in
            0x00, 0x00, 0x71, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xaf, 0x11, 0x1c,  0xa0, 0xf0,  // 457  - kr
            0x00, 0x04, 0x71, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xaf, 0x11, 0x1c,  0xa0, 0xf0,  // 458  - kr-ng
            0x00, 0x00, 0x60, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x12, 0x1c,  0xd0, 0xf0,  // 459  - ks
            0x00, 0x04, 0x60, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x12, 0x1c,  0xd0, 0xf0,  // 460  - ks-arab
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x12, 0x1c,  0xd0, 0xf0,  // 461  - ks-arab-in
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x1c,  0xf0, 0xbb,  // 462  - ks-deva
            0x00, 0x08, 0x60, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x1c,  0xf0, 0xbb,  // 463  - ks-deva-in
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x1d,  0x10, 0xf0,  // 464  - ksb
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x1d,  0x10, 0xf0,  // 465  - ksb-tz
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x1d,  0x30, 0xf0,  // 466  - ksf
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x1d,  0x30, 0xf0,  // 467  - ksf-cm
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x5e, 0x11, 0x1d,  0x50, 0xf0,  // 468  - ksh
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x5e, 0x11, 0x1d,  0x50, 0xf0,  // 469  - ksh-de
            0x00, 0x00, 0x92, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x79, 0x30, 0x1d,  0x80, 0x8f,  // 470  - ku
            0x00, 0x7c, 0x92, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x79, 0x30, 0x1d,  0x80, 0x8f,  // 471  - ku-arab
            0x00, 0x04, 0x92, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x79, 0x30, 0x1d,  0x80, 0x8f,  // 472  - ku-arab-iq
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x74, 0x10, 0x1d,  0x90, 0xf0,  // 473  - ku-arab-ir
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf2, 0x11, 0x1d,  0xb0, 0xf0,  // 474  - kw
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf2, 0x11, 0x1d,  0xb0, 0xf0,  // 475  - kw-gb
            0x00, 0x00, 0x40, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0x82, 0x11, 0x1d,  0xd1, 0xdd,  // 476  - ky
            0x00, 0x04, 0x40, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0x82, 0x11, 0x1d,  0xd1, 0xdd,  // 477  - ky-kg
            0x00, 0x00, 0x76, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x98, 0x9e, 0x01, 0x1d,  0xf0, 0x8f,  // 478  - la
            0x00, 0x04, 0x76, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x98, 0x9e, 0x01, 0x1d,  0xf0, 0x8f,  // 479  - la-001
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x1e,  0x10, 0xf0,  // 480  - lag
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x1e,  0x10, 0xf0,  // 481  - lag-tz
            0x00, 0x00, 0x6e, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x93, 0x11, 0x1e,  0x31, 0xe3,  // 482  - lb
            0x00, 0x04, 0x6e, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x93, 0x11, 0x1e,  0x31, 0xe3,  // 483  - lb-lu
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf0, 0x11, 0x1e,  0x50, 0xf0,  // 484  - lg
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf0, 0x11, 0x1e,  0x50, 0xf0,  // 485  - lg-ug
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf4, 0x11, 0x1e,  0x70, 0xf0,  // 486  - lkt
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf4, 0x11, 0x1e,  0x70, 0xf0,  // 487  - lkt-us
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2c, 0x11, 0x1e,  0xa0, 0xf0,  // 488  - ln
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x09, 0x11, 0x1e,  0x90, 0xf0,  // 489  - ln-ao
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2c, 0x11, 0x1e,  0xa0, 0xf0,  // 490  - ln-cd
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x37, 0x11, 0x1e,  0xb0, 0xf0,  // 491  - ln-cf
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2b, 0x11, 0x1e,  0xc0, 0xf0,  // 492  - ln-cg
            0x00, 0x00, 0x54, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x8a, 0x11, 0x1e,  0xe0, 0x8f,  // 493  - lo
            0x00, 0x04, 0x54, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x8a, 0x11, 0x1e,  0xe0, 0x8f,  // 494  - lo-la
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x74, 0x12, 0x1f,  0x10, 0xf0,  // 495  - lrc
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x79, 0x12, 0x1f,  0x00, 0xf0,  // 496  - lrc-iq
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x74, 0x12, 0x1f,  0x10, 0xf0,  // 497  - lrc-ir
            0x00, 0x00, 0x27, 0x4e,  0x93, 0x07, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x8d, 0x11, 0x1f,  0x31, 0xf3,  // 498  - lt
            0x00, 0x04, 0x27, 0x4e,  0x93, 0x07, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x8d, 0x11, 0x1f,  0x31, 0xf3,  // 499  - lt-lt
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2c, 0x11, 0x1f,  0x50, 0xf0,  // 500  - lu
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2c, 0x11, 0x1f,  0x50, 0xf0,  // 501  - lu-cd
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x1f,  0x70, 0xf0,  // 502  - luo
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x1f,  0x70, 0xf0,  // 503  - luo-ke
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x1f,  0x90, 0xf0,  // 504  - luy
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x1f,  0x90, 0xf0,  // 505  - luy-ke
            0x00, 0x00, 0x26, 0x4e,  0x93, 0x07, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x8c, 0x11, 0x1f,  0xb1, 0xfb,  // 506  - lv
            0x00, 0x04, 0x26, 0x4e,  0x93, 0x07, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x8c, 0x11, 0x1f,  0xb1, 0xfb,  // 507  - lv-lv
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x1f,  0xd0, 0xf0,  // 508  - mas
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x1f,  0xd0, 0xf0,  // 509  - mas-ke
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x1f,  0xe0, 0xf0,  // 510  - mas-tz
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x20,  0x00, 0xf0,  // 511  - mer
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x20,  0x00, 0xf0,  // 512  - mer-ke
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xa0, 0x11, 0x20,  0x20, 0xf0,  // 513  - mfe
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xa0, 0x11, 0x20,  0x20, 0xf0,  // 514  - mfe-mu
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x95, 0x11, 0x20,  0x40, 0xf0,  // 515  - mg
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x95, 0x11, 0x20,  0x40, 0xf0,  // 516  - mg-mg
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xa8, 0x11, 0x20,  0x60, 0xf0,  // 517  - mgh
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xa8, 0x11, 0x20,  0x60, 0xf0,  // 518  - mgh-mz
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x20,  0x80, 0xf0,  // 519  - mgo
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x20,  0x80, 0xf0,  // 520  - mgo-cm
            0x00, 0x00, 0x81, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xb7, 0x01, 0x20,  0xa2, 0x0a,  // 521  - mi
            0x00, 0x04, 0x81, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xb7, 0x01, 0x20,  0xa2, 0x0a,  // 522  - mi-nz
            0x00, 0x00, 0x2f, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x01, 0xf4, 0x00, 0x00,  0x4c, 0xa2, 0x11, 0x20,  0xc2, 0x0c,  // 523  - mk
            0x00, 0x04, 0x2f, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x01, 0xf4, 0x00, 0x00,  0x4c, 0xa2, 0x11, 0x20,  0xc2, 0x0c,  // 524  - mk-mk
            0x00, 0x00, 0x4c, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x11, 0x20,  0xe0, 0x8f,  // 525  - ml
            0x00, 0x04, 0x4c, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x11, 0x20,  0xe0, 0x8f,  // 526  - ml-in
            0x00, 0x00, 0x50, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0x9a, 0x11, 0x21,  0x12, 0x11,  // 527  - mn
            0x00, 0x78, 0x50, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0x9a, 0x11, 0x21,  0x12, 0x11,  // 528  - mn-cyrl
            0x00, 0x04, 0x50, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0x9a, 0x11, 0x21,  0x12, 0x11,  // 529  - mn-mn
            0x00, 0x7c, 0x50, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2d, 0x01, 0x21,  0x32, 0x13,  // 530  - mn-mong
            0x00, 0x08, 0x50, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2d, 0x01, 0x21,  0x32, 0x13,  // 531  - mn-mong-cn
            0x00, 0x0c, 0x50, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9a, 0x01, 0x21,  0x42, 0x14,  // 532  - mn-mong-mn
            0x00, 0x00, 0x58, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x21,  0x60, 0xbb,  // 533  - mni
            0x00, 0x04, 0x58, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x21,  0x60, 0xbb,  // 534  - mni-in
            0x00, 0x00, 0x7c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0x27, 0x01, 0x21,  0x80, 0xf0,  // 535  - moh
            0x00, 0x04, 0x7c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0x27, 0x01, 0x21,  0x80, 0xf0,  // 536  - moh-ca
            0x00, 0x00, 0x4e, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x21,  0xa0, 0x8f,  // 537  - mr
            0x00, 0x04, 0x4e, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x21,  0xa0, 0x8f,  // 538  - mr-in
            0x00, 0x00, 0x3e, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xa7, 0x11, 0x21,  0xd2, 0x1d,  // 539  - ms
            0x00, 0x08, 0x3e, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x25, 0x11, 0x21,  0xc2, 0x1c,  // 540  - ms-bn
            0x00, 0x04, 0x3e, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xa7, 0x11, 0x21,  0xd2, 0x1d,  // 541  - ms-my
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd7, 0x11, 0x21,  0xe0, 0xf0,  // 542  - ms-sg
            0x00, 0x00, 0x3a, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xa3, 0x11, 0x22,  0x02, 0x20,  // 543  - mt
            0x00, 0x04, 0x3a, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xa3, 0x11, 0x22,  0x02, 0x20,  // 544  - mt-mt
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x22,  0x20, 0xf0,  // 545  - mua
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x22,  0x20, 0xf0,  // 546  - mua-cm
            0x00, 0x00, 0x55, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x1b, 0x12, 0x22,  0x40, 0xf0,  // 547  - my
            0x00, 0x04, 0x55, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x1b, 0x12, 0x22,  0x40, 0xf0,  // 548  - my-mm
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x74, 0x12, 0x22,  0x60, 0xf0,  // 549  - mzn
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x74, 0x12, 0x22,  0x60, 0xf0,  // 550  - mzn-ir
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xfe, 0x11, 0x22,  0x80, 0xf0,  // 551  - naq
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xfe, 0x11, 0x22,  0x80, 0xf0,  // 552  - naq-na
            0x00, 0x7c, 0x14, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x35, 0x00, 0x00,  0x00, 0xb1, 0x11, 0x22,  0xa2, 0x2a,  // 553  - nb
            0x00, 0x04, 0x14, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x35, 0x00, 0x00,  0x00, 0xb1, 0x11, 0x22,  0xa2, 0x2a,  // 554  - nb-no
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x35, 0x00, 0x00,  0x00, 0xdc, 0x11, 0x22,  0xb0, 0xf0,  // 555  - nb-sj
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x08, 0x11, 0x22,  0xd0, 0xf0,  // 556  - nd
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x08, 0x11, 0x22,  0xd0, 0xf0,  // 557  - nd-zw
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x5e, 0x11, 0x22,  0xf0, 0xf0,  // 558  - nds
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x5e, 0x11, 0x22,  0xf0, 0xf0,  // 559  - nds-de
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xb0, 0x11, 0x23,  0x00, 0xf0,  // 560  - nds-nl
            0x00, 0x00, 0x61, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xb2, 0x01, 0x23,  0x30, 0x8f,  // 561  - ne
            0x00, 0x08, 0x61, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x12, 0x23,  0x20, 0xf0,  // 562  - ne-in
            0x00, 0x04, 0x61, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xb2, 0x01, 0x23,  0x30, 0x8f,  // 563  - ne-np
            0x00, 0x00, 0x13, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xb0, 0x11, 0x23,  0x92, 0x39,  // 564  - nl
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x2e, 0x11, 0x23,  0x50, 0xf0,  // 565  - nl-aw
            0x00, 0x08, 0x13, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x15, 0x11, 0x23,  0x62, 0x36,  // 566  - nl-be
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x09, 0xa5,  0x5d, 0x42, 0x11, 0x23,  0x70, 0xf0,  // 567  - nl-bq
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x11, 0x11, 0x23,  0x80, 0xf0,  // 568  - nl-cw
            0x00, 0x04, 0x13, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xb0, 0x11, 0x23,  0x92, 0x39,  // 569  - nl-nl
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xb5, 0x11, 0x23,  0xa0, 0xf0,  // 570  - nl-sr
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x78, 0xf7, 0x11, 0x23,  0xb0, 0xf0,  // 571  - nl-sx
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x23,  0xd0, 0xf0,  // 572  - nmg
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x23,  0xd0, 0xf0,  // 573  - nmg-cm
            0x00, 0x78, 0x14, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x35, 0x00, 0x00,  0x00, 0xb1, 0x11, 0x23,  0xf2, 0x3f,  // 574  - nn
            0x00, 0x08, 0x14, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x35, 0x00, 0x00,  0x00, 0xb1, 0x11, 0x23,  0xf2, 0x3f,  // 575  - nn-no
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x24,  0x10, 0xf0,  // 576  - nnh
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x24,  0x10, 0xf0,  // 577  - nnh-cm
            0x00, 0x00, 0x14, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x35, 0x00, 0x00,  0x00, 0xb1, 0x11, 0x22,  0xa2, 0x2a,  // 578  - no
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x64, 0x22, 0x24,  0x40, 0x8f,  // 579  - nqo
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x64, 0x22, 0x24,  0x40, 0x8f,  // 580  - nqo-gn
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x24,  0x60, 0xf0,  // 581  - nr
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x24,  0x60, 0xf0,  // 582  - nr-za
            0x00, 0x00, 0x6c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x24,  0x82, 0x48,  // 583  - nso
            0x00, 0x04, 0x6c, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x24,  0x82, 0x48,  // 584  - nso-za
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x14, 0x11, 0x24,  0xa0, 0xf0,  // 585  - nus
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x14, 0x11, 0x24,  0xa0, 0xf0,  // 586  - nus-ss
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf0, 0x11, 0x24,  0xc0, 0xf0,  // 587  - nyn
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf0, 0x11, 0x24,  0xc0, 0xf0,  // 588  - nyn-ug
            0x00, 0x00, 0x82, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x54, 0x11, 0x24,  0xe2, 0x4e,  // 589  - oc
            0x00, 0x04, 0x82, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x54, 0x11, 0x24,  0xe2, 0x4e,  // 590  - oc-fr
            0x00, 0x00, 0x72, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x49, 0x11, 0x25,  0x00, 0xf0,  // 591  - om
            0x00, 0x04, 0x72, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x49, 0x11, 0x25,  0x00, 0xf0,  // 592  - om-et
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x25,  0x10, 0xf0,  // 593  - om-ke
            0x00, 0x00, 0x48, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x25,  0x30, 0x8f,  // 594  - or
            0x00, 0x04, 0x48, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x25,  0x30, 0x8f,  // 595  - or-in
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x58, 0x11, 0x25,  0x50, 0xf0,  // 596  - os
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x58, 0x11, 0x25,  0x50, 0xf0,  // 597  - os-ge
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xcb, 0x11, 0x25,  0x60, 0xf0,  // 598  - os-ru
            0x00, 0x00, 0x46, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x25,  0xa0, 0x8f,  // 599  - pa
            0x00, 0x7c, 0x46, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xbe, 0x12, 0x25,  0x90, 0x8f,  // 600  - pa-arab
            0x00, 0x08, 0x46, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xbe, 0x12, 0x25,  0x90, 0x8f,  // 601  - pa-arab-pk
            0x00, 0x04, 0x46, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x25,  0xa0, 0x8f,  // 602  - pa-in
            0x00, 0x00, 0x79, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x99,  0x32, 0x48, 0x01, 0x25,  0xc0, 0x91,  // 603  - pap
            0x00, 0x04, 0x79, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x99,  0x32, 0x48, 0x01, 0x25,  0xc0, 0x91,  // 604  - pap-029
            0x00, 0x00, 0x15, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x51, 0x90, 0x00, 0x00,  0x00, 0xbf, 0x11, 0x25,  0xe2, 0x5e,  // 605  - pl
            0x00, 0x04, 0x15, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x51, 0x90, 0x00, 0x00,  0x00, 0xbf, 0x11, 0x25,  0xe2, 0x5e,  // 606  - pl-pl
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x98, 0x9e, 0x11, 0x26,  0x00, 0xf0,  // 607  - prg
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x98, 0x9e, 0x11, 0x26,  0x00, 0xf0,  // 608  - prg-001
            0x00, 0x00, 0x8c, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x03, 0x12, 0x26,  0x20, 0x8f,  // 609  - prs
            0x00, 0x04, 0x8c, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x03, 0x12, 0x26,  0x20, 0x8f,  // 610  - prs-af
            0x00, 0x00, 0x63, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x03, 0x12, 0x26,  0x40, 0x8f,  // 611  - ps
            0x00, 0x04, 0x63, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x03, 0x12, 0x26,  0x40, 0x8f,  // 612  - ps-af
            0x00, 0x00, 0x16, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x20, 0x11, 0x26,  0x72, 0x67,  // 613  - pt
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x09, 0x11, 0x26,  0x60, 0xf0,  // 614  - pt-ao
            0x00, 0x04, 0x16, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x20, 0x11, 0x26,  0x72, 0x67,  // 615  - pt-br
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xdf, 0x11, 0x26,  0x80, 0xf0,  // 616  - pt-ch
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x39, 0x11, 0x26,  0x90, 0xf0,  // 617  - pt-cv
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x45, 0x11, 0x26,  0xa0, 0xf0,  // 618  - pt-gq
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xc4, 0x11, 0x26,  0xb0, 0xf0,  // 619  - pt-gw
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x93, 0x11, 0x26,  0xc0, 0xf0,  // 620  - pt-lu
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x97, 0x11, 0x26,  0xd0, 0xf0,  // 621  - pt-mo
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xa8, 0x11, 0x26,  0xe0, 0xf0,  // 622  - pt-mz
            0x00, 0x08, 0x16, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xc1, 0x11, 0x26,  0xf2, 0x6f,  // 623  - pt-pt
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xe9, 0x11, 0x27,  0x00, 0xf0,  // 624  - pt-st
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x6f,  0x60, 0xe7, 0x11, 0x27,  0x10, 0xf0,  // 625  - pt-tl
            0x00, 0x09, 0x01, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x7c, 0x01, 0x27,  0x20, 0xbe,  // 626  - qps-latn-x-sh
            0x00, 0x05, 0x01, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x51, 0x90, 0x00, 0x00,  0x00, 0xf4, 0x41, 0x27,  0x32, 0x73,  // 627  - qps-ploc
            0x00, 0x05, 0xfe, 0x3a,  0x43, 0xa4, 0x27, 0x11,  0x4f, 0x42, 0x00, 0x00,  0x00, 0x7a, 0x01, 0x27,  0x42, 0x74,  // 628  - qps-ploca
            0x00, 0x09, 0xff, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xcd, 0x10, 0x27,  0x50, 0x8f,  // 629  - qps-plocm
            0x00, 0x00, 0x86, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x63, 0x01, 0x27,  0x82, 0x78,  // 630  - quc
            0x00, 0x7c, 0x86, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x63, 0x01, 0x27,  0x82, 0x78,  // 631  - quc-latn
            0x00, 0x04, 0x86, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x63, 0x01, 0x27,  0x82, 0x78,  // 632  - quc-latn-gt
            0x00, 0x00, 0x6b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x1a, 0x01, 0x27,  0xa2, 0x7a,  // 633  - quz
            0x00, 0x04, 0x6b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x1a, 0x01, 0x27,  0xa2, 0x7a,  // 634  - quz-bo
            0x00, 0x08, 0x6b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0x42, 0x01, 0x27,  0xb2, 0x7b,  // 635  - quz-ec
            0x00, 0x0c, 0x6b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x3c, 0x00, 0x00,  0x00, 0xbb, 0x01, 0x27,  0xc2, 0x7c,  // 636  - quz-pe
            0x00, 0x00, 0x17, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x31, 0x00, 0x00,  0x00, 0xdf, 0x11, 0x27,  0xe2, 0x7e,  // 637  - rm
            0x00, 0x04, 0x17, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x31, 0x00, 0x00,  0x00, 0xdf, 0x11, 0x27,  0xe2, 0x7e,  // 638  - rm-ch
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x26, 0x11, 0x28,  0x00, 0xf0,  // 639  - rn
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x26, 0x11, 0x28,  0x00, 0xf0,  // 640  - rn-bi
            0x00, 0x00, 0x18, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x51, 0x90, 0x00, 0x00,  0x00, 0xc8, 0x11, 0x28,  0x32, 0x83,  // 641  - ro
            0x00, 0x08, 0x18, 0x4e,  0x23, 0x54, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x98, 0x11, 0x28,  0x20, 0xf0,  // 642  - ro-md
            0x00, 0x04, 0x18, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x51, 0x90, 0x00, 0x00,  0x00, 0xc8, 0x11, 0x28,  0x32, 0x83,  // 643  - ro-ro
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x28,  0x50, 0xf0,  // 644  - rof
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x28,  0x50, 0xf0,  // 645  - rof-tz
            0x00, 0x00, 0x19, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0xcb, 0x11, 0x28,  0xb2, 0x8b,  // 646  - ru
            0x00, 0x10, 0x00, 0x4e,  0x33, 0x62, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x1d, 0x11, 0x28,  0x70, 0xf0,  // 647  - ru-by
            0x00, 0x10, 0x00, 0x4e,  0x33, 0x62, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x82, 0x11, 0x28,  0x80, 0xf0,  // 648  - ru-kg
            0x00, 0x10, 0x00, 0x4e,  0x33, 0x62, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x89, 0x11, 0x28,  0x90, 0xf0,  // 649  - ru-kz
            0x00, 0x08, 0x19, 0x4e,  0x33, 0x62, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x98, 0x11, 0x28,  0xa0, 0xf0,  // 650  - ru-md
            0x00, 0x04, 0x19, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0xcb, 0x11, 0x28,  0xb2, 0x8b,  // 651  - ru-ru
            0x00, 0x10, 0x00, 0x4e,  0x33, 0x62, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf1, 0x11, 0x28,  0xc0, 0xf0,  // 652  - ru-ua
            0x00, 0x00, 0x87, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0xcc, 0x11, 0x28,  0xe2, 0x8e,  // 653  - rw
            0x00, 0x04, 0x87, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0xcc, 0x11, 0x28,  0xe2, 0x8e,  // 654  - rw-rw
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x29,  0x00, 0xf0,  // 655  - rwk
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x29,  0x00, 0xf0,  // 656  - rwk-tz
            0x00, 0x00, 0x4f, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x29,  0x20, 0x8f,  // 657  - sa
            0x00, 0x04, 0x4f, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x29,  0x20, 0x8f,  // 658  - sa-in
            0x00, 0x00, 0x85, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0xcb, 0x11, 0x29,  0x42, 0x94,  // 659  - sah
            0x00, 0x04, 0x85, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0xcb, 0x11, 0x29,  0x42, 0x94,  // 660  - sah-ru
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x29,  0x60, 0xf0,  // 661  - saq
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x29,  0x60, 0xf0,  // 662  - saq-ke
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x29,  0x80, 0xf0,  // 663  - sbp
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x29,  0x80, 0xf0,  // 664  - sbp-tz
            0x00, 0x00, 0x59, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xbe, 0x12, 0x29,  0xb0, 0x8f,  // 665  - sd
            0x00, 0x7c, 0x59, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xbe, 0x12, 0x29,  0xb0, 0x8f,  // 666  - sd-arab
            0x00, 0x08, 0x59, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xbe, 0x12, 0x29,  0xb0, 0x8f,  // 667  - sd-arab-pk
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x29,  0xd0, 0xbb,  // 668  - sd-deva
            0x00, 0x04, 0x59, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x29,  0xd0, 0xbb,  // 669  - sd-deva-in
            0x00, 0x00, 0x3b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x35, 0x00, 0x00,  0x00, 0xb1, 0x11, 0x2a,  0x02, 0xa0,  // 670  - se
            0x00, 0x0c, 0x3b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x36, 0x00, 0x00,  0x00, 0x4d, 0x11, 0x29,  0xf2, 0x9f,  // 671  - se-fi
            0x00, 0x04, 0x3b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x35, 0x00, 0x00,  0x00, 0xb1, 0x11, 0x2a,  0x02, 0xa0,  // 672  - se-no
            0x00, 0x08, 0x3b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x36, 0x00, 0x00,  0x00, 0xdd, 0x11, 0x2a,  0x12, 0xa1,  // 673  - se-se
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xa8, 0x11, 0x2a,  0x30, 0xf0,  // 674  - seh
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xa8, 0x11, 0x2a,  0x30, 0xf0,  // 675  - seh-mz
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9d, 0x11, 0x2a,  0x50, 0xf0,  // 676  - ses
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9d, 0x11, 0x2a,  0x50, 0xf0,  // 677  - ses-ml
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x37, 0x11, 0x2a,  0x70, 0xf0,  // 678  - sg
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x37, 0x11, 0x2a,  0x70, 0xf0,  // 679  - sg-cf
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9f, 0x11, 0x2a,  0xc0, 0xf0,  // 680  - shi
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9f, 0x11, 0x2a,  0xa0, 0xf0,  // 681  - shi-latn
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9f, 0x11, 0x2a,  0xa0, 0xf0,  // 682  - shi-latn-ma
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9f, 0x11, 0x2a,  0xc0, 0xf0,  // 683  - shi-tfng
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9f, 0x11, 0x2a,  0xc0, 0xf0,  // 684  - shi-tfng-ma
            0x00, 0x00, 0x5b, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2a, 0x11, 0x2a,  0xe0, 0x8f,  // 685  - si
            0x00, 0x04, 0x5b, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2a, 0x11, 0x2a,  0xe0, 0x8f,  // 686  - si-lk
            0x00, 0x00, 0x1b, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x51, 0x90, 0x00, 0x00,  0x00, 0x8f, 0x11, 0x2b,  0x02, 0xb0,  // 687  - sk
            0x00, 0x04, 0x1b, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x51, 0x90, 0x00, 0x00,  0x00, 0x8f, 0x11, 0x2b,  0x02, 0xb0,  // 688  - sk-sk
            0x00, 0x00, 0x24, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x51, 0x90, 0x00, 0x00,  0x00, 0xd4, 0x11, 0x2b,  0x22, 0xb2,  // 689  - sl
            0x00, 0x04, 0x24, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x51, 0x90, 0x00, 0x00,  0x00, 0xd4, 0x11, 0x2b,  0x22, 0xb2,  // 690  - sl-si
            0x00, 0x78, 0x3b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x36, 0x00, 0x00,  0x00, 0xdd, 0x11, 0x2b,  0x52, 0xb5,  // 691  - sma
            0x00, 0x18, 0x3b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x35, 0x00, 0x00,  0x00, 0xb1, 0x11, 0x2b,  0x42, 0xb4,  // 692  - sma-no
            0x00, 0x1c, 0x3b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x36, 0x00, 0x00,  0x00, 0xdd, 0x11, 0x2b,  0x52, 0xb5,  // 693  - sma-se
            0x00, 0x7c, 0x3b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x36, 0x00, 0x00,  0x00, 0xdd, 0x11, 0x2b,  0x82, 0xb8,  // 694  - smj
            0x00, 0x10, 0x3b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x35, 0x00, 0x00,  0x00, 0xb1, 0x11, 0x2b,  0x72, 0xb7,  // 695  - smj-no
            0x00, 0x14, 0x3b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x36, 0x00, 0x00,  0x00, 0xdd, 0x11, 0x2b,  0x82, 0xb8,  // 696  - smj-se
            0x00, 0x70, 0x3b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x36, 0x00, 0x00,  0x00, 0x4d, 0x11, 0x2b,  0xa2, 0xba,  // 697  - smn
            0x00, 0x24, 0x3b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x36, 0x00, 0x00,  0x00, 0x4d, 0x11, 0x2b,  0xa2, 0xba,  // 698  - smn-fi
            0x00, 0x74, 0x3b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x36, 0x00, 0x00,  0x00, 0x4d, 0x11, 0x2b,  0xc2, 0xbc,  // 699  - sms
            0x00, 0x20, 0x3b, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x36, 0x00, 0x00,  0x00, 0x4d, 0x11, 0x2b,  0xc2, 0xbc,  // 700  - sms-fi
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x08, 0x11, 0x2b,  0xf0, 0xf0,  // 701  - sn
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x08, 0x11, 0x2b,  0xf0, 0xf0,  // 702  - sn-latn
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x08, 0x11, 0x2b,  0xf0, 0xf0,  // 703  - sn-latn-zw
            0x00, 0x00, 0x77, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd8, 0x11, 0x2c,  0x40, 0xf0,  // 704  - so
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x3e, 0x11, 0x2c,  0x10, 0xf0,  // 705  - so-dj
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x49, 0x11, 0x2c,  0x20, 0xf0,  // 706  - so-et
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x2c,  0x30, 0xf0,  // 707  - so-ke
            0x00, 0x04, 0x77, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd8, 0x11, 0x2c,  0x40, 0xf0,  // 708  - so-so
            0x00, 0x00, 0x1c, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x51, 0x90, 0x00, 0x00,  0x00, 0x06, 0x11, 0x2c,  0x62, 0xc6,  // 709  - sq
            0x00, 0x04, 0x1c, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x51, 0x90, 0x00, 0x00,  0x00, 0x06, 0x11, 0x2c,  0x62, 0xc6,  // 710  - sq-al
            0x00, 0x10, 0x00, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x51, 0x90, 0x00, 0x00,  0x4c, 0xa2, 0x11, 0x2c,  0x70, 0xf0,  // 711  - sq-mk
            0x00, 0x10, 0x00, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x51, 0x90, 0x00, 0x97,  0x49, 0x41, 0x11, 0x2c,  0x80, 0xf0,  // 712  - sq-xk
            0x00, 0x7c, 0x1a, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x0f, 0x11, 0x2d,  0x42, 0xd4,  // 713  - sr
            0x00, 0x6c, 0x1a, 0x4e,  0x33, 0x57, 0x27, 0x17,  0x52, 0x21, 0x00, 0x00,  0x01, 0x0f, 0x11, 0x2c,  0xe2, 0xce,  // 714  - sr-cyrl
            0x00, 0x1c, 0x1a, 0x4e,  0x33, 0x57, 0x27, 0x17,  0x52, 0x21, 0x00, 0x00,  0x00, 0x19, 0x11, 0x2c,  0xb2, 0xcb,  // 715  - sr-cyrl-ba
            0x00, 0x0c, 0x1a, 0x4e,  0x33, 0x57, 0x27, 0x17,  0x52, 0x21, 0x00, 0x00,  0x01, 0x0d, 0x11, 0x2c,  0xc2, 0xcc,  // 716  - sr-cyrl-cs
            0x00, 0x30, 0x1a, 0x4e,  0x33, 0x57, 0x27, 0x17,  0x52, 0x21, 0x00, 0x00,  0x01, 0x0e, 0x11, 0x2c,  0xd2, 0xcd,  // 717  - sr-cyrl-me
            0x00, 0x28, 0x1a, 0x4e,  0x33, 0x57, 0x27, 0x17,  0x52, 0x21, 0x00, 0x00,  0x01, 0x0f, 0x11, 0x2c,  0xe2, 0xce,  // 718  - sr-cyrl-rs
            0x00, 0x10, 0x00, 0x4e,  0x33, 0x57, 0x27, 0x17,  0x52, 0x21, 0x00, 0x97,  0x49, 0x41, 0x11, 0x2c,  0xf0, 0xf0,  // 719  - sr-cyrl-xk
            0x00, 0x70, 0x1a, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x0f, 0x11, 0x2d,  0x42, 0xd4,  // 720  - sr-latn
            0x00, 0x18, 0x1a, 0x4e,  0x23, 0x54, 0x27, 0x62,  0x03, 0x66, 0x00, 0x00,  0x00, 0x19, 0x11, 0x2d,  0x12, 0xd1,  // 721  - sr-latn-ba
            0x00, 0x08, 0x1a, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x0d, 0x11, 0x2d,  0x22, 0xd2,  // 722  - sr-latn-cs
            0x00, 0x2c, 0x1a, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x0e, 0x11, 0x2d,  0x32, 0xd3,  // 723  - sr-latn-me
            0x00, 0x24, 0x1a, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x0f, 0x11, 0x2d,  0x42, 0xd4,  // 724  - sr-latn-rs
            0x00, 0x10, 0x00, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x97,  0x49, 0x41, 0x11, 0x2d,  0x50, 0xf0,  // 725  - sr-latn-xk
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x2d,  0x80, 0xf0,  // 726  - ss
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x01, 0x04, 0x11, 0x2d,  0x70, 0xf0,  // 727  - ss-sz
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x2d,  0x80, 0xf0,  // 728  - ss-za
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x47, 0x11, 0x2d,  0xa0, 0xf0,  // 729  - ssy
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x47, 0x11, 0x2d,  0xa0, 0xf0,  // 730  - ssy-er
            0x00, 0x00, 0x30, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x2d,  0xd0, 0xf0,  // 731  - st
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x92, 0x11, 0x2d,  0xc0, 0xf0,  // 732  - st-ls
            0x00, 0x04, 0x30, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x2d,  0xd0, 0xf0,  // 733  - st-za
            0x00, 0x00, 0x1d, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x36, 0x00, 0x00,  0x00, 0xdd, 0x11, 0x2e,  0x12, 0xe1,  // 734  - sv
            0x00, 0x10, 0x00, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x36, 0x00, 0x99,  0x06, 0xf5, 0x11, 0x2d,  0xf0, 0xf0,  // 735  - sv-ax
            0x00, 0x08, 0x1d, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x36, 0x00, 0x00,  0x00, 0x4d, 0x11, 0x2e,  0x02, 0xe0,  // 736  - sv-fi
            0x00, 0x04, 0x1d, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x36, 0x00, 0x00,  0x00, 0xdd, 0x11, 0x2e,  0x12, 0xe1,  // 737  - sv-se
            0x00, 0x00, 0x41, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x2e,  0x42, 0xe4,  // 738  - sw
            0x00, 0x10, 0x00, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2c, 0x11, 0x2e,  0x32, 0xe4,  // 739  - sw-cd
            0x00, 0x04, 0x41, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x2e,  0x42, 0xe4,  // 740  - sw-ke
            0x00, 0x10, 0x00, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x2e,  0x50, 0xf0,  // 741  - sw-tz
            0x00, 0x10, 0x00, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf0, 0x11, 0x2e,  0x60, 0xf0,  // 742  - sw-ug
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x00,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2c, 0x01, 0x2e,  0x80, 0xf0,  // 743  - swc
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x00,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2c, 0x11, 0x2e,  0x80, 0xf0,  // 744  - swc-cd
            0x00, 0x00, 0x5a, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xde, 0x01, 0x2e,  0xa0, 0x8f,  // 745  - syr
            0x00, 0x04, 0x5a, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xde, 0x01, 0x2e,  0xa0, 0x8f,  // 746  - syr-sy
            0x00, 0x00, 0x49, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x2e,  0xc0, 0x8f,  // 747  - ta
            0x00, 0x04, 0x49, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x01, 0x2e,  0xc0, 0x8f,  // 748  - ta-in
            0x00, 0x08, 0x49, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2a, 0x11, 0x2e,  0xd0, 0x8f,  // 749  - ta-lk
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xa7, 0x11, 0x2e,  0xe0, 0xf0,  // 750  - ta-my
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd7, 0x11, 0x2e,  0xf0, 0xf0,  // 751  - ta-sg
            0x00, 0x00, 0x4a, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x11, 0x2f,  0x10, 0x8f,  // 752  - te
            0x00, 0x04, 0x4a, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x11, 0x2f,  0x10, 0x8f,  // 753  - te-in
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf0, 0x11, 0x2f,  0x40, 0xf0,  // 754  - teo
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x81, 0x11, 0x2f,  0x30, 0xf0,  // 755  - teo-ke
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf0, 0x11, 0x2f,  0x40, 0xf0,  // 756  - teo-ug
            0x00, 0x00, 0x28, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0xe4, 0x11, 0x2f,  0x72, 0xf7,  // 757  - tg
            0x00, 0x7c, 0x28, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0xe4, 0x11, 0x2f,  0x72, 0xf7,  // 758  - tg-cyrl
            0x00, 0x04, 0x28, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0xe4, 0x11, 0x2f,  0x72, 0xf7,  // 759  - tg-cyrl-tj
            0x00, 0x00, 0x1e, 0x36,  0xa3, 0x6a, 0x27, 0x25,  0x51, 0x66, 0x00, 0x00,  0x00, 0xe3, 0x01, 0x2f,  0x90, 0x8f,  // 760  - th
            0x00, 0x04, 0x1e, 0x36,  0xa3, 0x6a, 0x27, 0x25,  0x51, 0x66, 0x00, 0x00,  0x00, 0xe3, 0x01, 0x2f,  0x90, 0x8f,  // 761  - th-th
            0x00, 0x00, 0x73, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x47, 0x11, 0x2f,  0xb0, 0x8f,  // 762  - ti
            0x00, 0x08, 0x73, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x47, 0x11, 0x2f,  0xb0, 0x8f,  // 763  - ti-er
            0x00, 0x04, 0x73, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x49, 0x11, 0x2f,  0xc0, 0x8f,  // 764  - ti-et
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x47, 0x11, 0x2f,  0xe0, 0xf0,  // 765  - tig
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x47, 0x11, 0x2f,  0xe0, 0xf0,  // 766  - tig-er
            0x00, 0x00, 0x42, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x51, 0x90, 0x00, 0x00,  0x00, 0xee, 0x11, 0x30,  0x03, 0x00,  // 767  - tk
            0x00, 0x04, 0x42, 0x4e,  0x23, 0x54, 0x27, 0x2d,  0x51, 0x90, 0x00, 0x00,  0x00, 0xee, 0x11, 0x30,  0x03, 0x00,  // 768  - tk-tm
            0x00, 0x00, 0x32, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x30,  0x33, 0x03,  // 769  - tn
            0x00, 0x08, 0x32, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x13, 0x11, 0x30,  0x23, 0x02,  // 770  - tn-bw
            0x00, 0x04, 0x32, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x30,  0x33, 0x03,  // 771  - tn-za
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xe7, 0x11, 0x30,  0x50, 0xf0,  // 772  - to
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xe7, 0x11, 0x30,  0x50, 0xf0,  // 773  - to-to
            0x00, 0x00, 0x1f, 0x4e,  0x63, 0x59, 0x27, 0x61,  0x51, 0xa9, 0x00, 0x00,  0x00, 0xeb, 0x11, 0x30,  0x83, 0x08,  // 774  - tr
            0x00, 0x10, 0x00, 0x4e,  0x63, 0x59, 0x27, 0x61,  0x51, 0xa9, 0x00, 0x00,  0x00, 0x3b, 0x11, 0x30,  0x70, 0xf0,  // 775  - tr-cy
            0x00, 0x04, 0x1f, 0x4e,  0x63, 0x59, 0x27, 0x61,  0x51, 0xa9, 0x00, 0x00,  0x00, 0xeb, 0x11, 0x30,  0x83, 0x08,  // 776  - tr-tr
            0x00, 0x00, 0x31, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x30,  0xa0, 0xf0,  // 777  - ts
            0x00, 0x04, 0x31, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x30,  0xa0, 0xf0,  // 778  - ts-za
            0x00, 0x00, 0x44, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0xcb, 0x11, 0x30,  0xc3, 0x0c,  // 779  - tt
            0x00, 0x04, 0x44, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0xcb, 0x11, 0x30,  0xc3, 0x0c,  // 780  - tt-ru
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xad, 0x11, 0x30,  0xe0, 0xf0,  // 781  - twq
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xad, 0x11, 0x30,  0xe0, 0xf0,  // 782  - twq-ne
            0x00, 0x00, 0x5f, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x04, 0x11, 0x31,  0x33, 0x13,  // 783  - tzm
            0x00, 0x10, 0x00, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x9f, 0x11, 0x31,  0x10, 0xf0,  // 784  - tzm-arab
            0x00, 0x04, 0x5f, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x9f, 0x11, 0x31,  0x10, 0xf0,  // 785  - tzm-arab-ma
            0x00, 0x7c, 0x5f, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x04, 0x11, 0x31,  0x33, 0x13,  // 786  - tzm-latn
            0x00, 0x08, 0x5f, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0x04, 0x11, 0x31,  0x33, 0x13,  // 787  - tzm-latn-dz
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9f, 0x11, 0x31,  0x40, 0xf0,  // 788  - tzm-latn-ma
            0x00, 0x78, 0x5f, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9f, 0x11, 0x31,  0x61, 0x3c,  // 789  - tzm-tfng
            0x00, 0x10, 0x5f, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9f, 0x11, 0x31,  0x61, 0x3c,  // 790  - tzm-tfng-ma
            0x00, 0x00, 0x80, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x2d, 0x01, 0x31,  0x80, 0x8f,  // 791  - ug
            0x00, 0x04, 0x80, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0x2d, 0x01, 0x31,  0x80, 0x8f,  // 792  - ug-cn
            0x00, 0x00, 0x22, 0x4e,  0x33, 0x62, 0x27, 0x21,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf1, 0x11, 0x31,  0xa3, 0x1a,  // 793  - uk
            0x00, 0x04, 0x22, 0x4e,  0x33, 0x62, 0x27, 0x21,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf1, 0x11, 0x31,  0xa3, 0x1a,  // 794  - uk-ua
            0x00, 0x00, 0x20, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xbe, 0x11, 0x31,  0xd0, 0x8f,  // 795  - ur
            0x00, 0x08, 0x20, 0x4e,  0x82, 0xd0, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x71, 0x12, 0x31,  0xc0, 0xf0,  // 796  - ur-in
            0x00, 0x04, 0x20, 0x4e,  0x82, 0xd0, 0x27, 0x14,  0x4f, 0xc4, 0x00, 0x00,  0x00, 0xbe, 0x11, 0x31,  0xd0, 0x8f,  // 797  - ur-pk
            0x00, 0x00, 0x43, 0x4e,  0x63, 0x59, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf7, 0x11, 0x32,  0x43, 0x24,  // 798  - uz
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x03, 0x12, 0x32,  0x00, 0xf0,  // 799  - uz-arab
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x03, 0x12, 0x32,  0x00, 0xf0,  // 800  - uz-arab-af
            0x00, 0x78, 0x43, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0xf7, 0x11, 0x32,  0x23, 0x22,  // 801  - uz-cyrl
            0x00, 0x08, 0x43, 0x4e,  0x33, 0x62, 0x27, 0x17,  0x51, 0x90, 0x00, 0x00,  0x00, 0xf7, 0x11, 0x32,  0x23, 0x22,  // 802  - uz-cyrl-uz
            0x00, 0x7c, 0x43, 0x4e,  0x63, 0x59, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf7, 0x11, 0x32,  0x43, 0x24,  // 803  - uz-latn
            0x00, 0x04, 0x43, 0x4e,  0x63, 0x59, 0x27, 0x2d,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf7, 0x11, 0x32,  0x43, 0x24,  // 804  - uz-latn-uz
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x8e, 0x11, 0x32,  0x90, 0xf0,  // 805  - vai
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x8e, 0x11, 0x32,  0x70, 0xf0,  // 806  - vai-latn
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x8e, 0x11, 0x32,  0x70, 0xf0,  // 807  - vai-latn-lr
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x8e, 0x11, 0x32,  0x90, 0xf0,  // 808  - vai-vaii
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x8e, 0x11, 0x32,  0x90, 0xf0,  // 809  - vai-vaii-lr
            0x00, 0x00, 0x33, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x32,  0xb0, 0xf0,  // 810  - ve
            0x00, 0x04, 0x33, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x32,  0xb0, 0xf0,  // 811  - ve-za
            0x00, 0x00, 0x2a, 0x4e,  0xa4, 0xea, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xfb, 0x01, 0x32,  0xd0, 0x8f,  // 812  - vi
            0x00, 0x04, 0x2a, 0x4e,  0xa4, 0xea, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xfb, 0x01, 0x32,  0xd0, 0x8f,  // 813  - vi-vn
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x98, 0x9e, 0x11, 0x32,  0xf0, 0xf0,  // 814  - vo
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x98, 0x9e, 0x11, 0x32,  0xf0, 0xf0,  // 815  - vo-001
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x33,  0x10, 0xf0,  // 816  - vun
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xef, 0x11, 0x33,  0x10, 0xf0,  // 817  - vun-tz
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xdf, 0x11, 0x33,  0x30, 0xf0,  // 818  - wae
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xdf, 0x11, 0x33,  0x30, 0xf0,  // 819  - wae-ch
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x49, 0x11, 0x33,  0x50, 0xf0,  // 820  - wal
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x49, 0x11, 0x33,  0x50, 0xf0,  // 821  - wal-et
            0x00, 0x00, 0x88, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xd2, 0x11, 0x33,  0x73, 0x37,  // 822  - wo
            0x00, 0x04, 0x88, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x4f, 0x49, 0x00, 0x00,  0x00, 0xd2, 0x11, 0x33,  0x73, 0x37,  // 823  - wo-sn
            0x01, 0x00, 0x7f, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0xf4, 0x01, 0xff,  0xff, 0xff,  // 824  - x-iv_mathan
            0x00, 0x00, 0x34, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x33,  0xa3, 0x3a,  // 825  - xh
            0x00, 0x04, 0x34, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x33,  0xa3, 0x3a,  // 826  - xh-za
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf0, 0x11, 0x33,  0xc0, 0xf0,  // 827  - xog
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xf0, 0x11, 0x33,  0xc0, 0xf0,  // 828  - xog-ug
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x33,  0xe0, 0xf0,  // 829  - yav
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x31, 0x11, 0x33,  0xe0, 0xf0,  // 830  - yav-cm
            0x00, 0x00, 0x3d, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x98, 0x9e, 0x11, 0x34,  0x00, 0xf0,  // 831  - yi
            0x00, 0x04, 0x3d, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x98, 0x9e, 0x11, 0x34,  0x00, 0xf0,  // 832  - yi-001
            0x00, 0x00, 0x6a, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0xaf, 0x11, 0x34,  0x33, 0x43,  // 833  - yo
            0x00, 0x10, 0x00, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x1c, 0x11, 0x34,  0x20, 0xf0,  // 834  - yo-bj
            0x00, 0x04, 0x6a, 0x4e,  0x41, 0xb5, 0x27, 0x10,  0x00, 0x25, 0x00, 0x00,  0x00, 0xaf, 0x11, 0x34,  0x33, 0x43,  // 835  - yo-ng
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x68, 0x01, 0x34,  0x50, 0xf0,  // 836  - yue
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x68, 0x01, 0x34,  0x50, 0xf0,  // 837  - yue-hk
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9f, 0x11, 0x34,  0x81, 0x3c,  // 838  - zgh
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9f, 0x11, 0x34,  0x81, 0x3c,  // 839  - zgh-tfng
            0x00, 0x10, 0x00, 0x00,  0x00, 0x01, 0x00, 0x02,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x9f, 0x11, 0x34,  0x81, 0x3c,  // 840  - zgh-tfng-ma
            0x00, 0x78, 0x04, 0x3a,  0x83, 0xa8, 0x27, 0x18,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2d, 0x01, 0x34,  0xc3, 0x4c,  // 841  - zh
            0x00, 0x00, 0x04, 0x3a,  0x83, 0xa8, 0x00, 0x00,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2d, 0x01, 0x34,  0xc3, 0x4c,  // 842  - zh-chs
            0x00, 0x7c, 0x04, 0x3b,  0x63, 0xb6, 0x00, 0x00,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x68, 0x01, 0x35,  0x33, 0x53,  // 843  - zh-cht
            0x00, 0x08, 0x04, 0x3a,  0x83, 0xa8, 0x27, 0x18,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2d, 0x01, 0x34,  0xc3, 0x4c,  // 844  - zh-cn
            0x05, 0x08, 0x04, 0x3a,  0x83, 0xa8, 0x27, 0x18,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2d, 0x01, 0x34,  0xc3, 0x4c,  // 845  - zh-cn_phoneb
            0x02, 0x08, 0x04, 0x3a,  0x83, 0xa8, 0x27, 0x18,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2d, 0x01, 0x34,  0xc3, 0x4c,  // 846  - zh-cn_stroke
            0x00, 0x00, 0x04, 0x3a,  0x83, 0xa8, 0x27, 0x18,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x2d, 0x01, 0x34,  0xc3, 0x4c,  // 847  - zh-hans
            0x00, 0x10, 0x00, 0x3a,  0x83, 0xa8, 0x27, 0x18,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x68, 0x11, 0x35,  0x00, 0xf0,  // 848  - zh-hans-hk
            0x00, 0x10, 0x00, 0x3a,  0x83, 0xa8, 0x27, 0x18,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x97, 0x11, 0x35,  0x10, 0xf0,  // 849  - zh-hans-mo
            0x00, 0x7c, 0x04, 0x3b,  0x63, 0xb6, 0x27, 0x12,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x68, 0x01, 0x35,  0x33, 0x53,  // 850  - zh-hant
            0x00, 0x0c, 0x04, 0x3b,  0x63, 0xb6, 0x27, 0x12,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x68, 0x01, 0x35,  0x33, 0x53,  // 851  - zh-hk
            0x04, 0x0c, 0x04, 0x3b,  0x63, 0xb6, 0x27, 0x12,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x68, 0x01, 0x35,  0x33, 0x53,  // 852  - zh-hk_radstr
            0x00, 0x14, 0x04, 0x3b,  0x63, 0xb6, 0x27, 0x12,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x97, 0x01, 0x35,  0x53, 0x55,  // 853  - zh-mo
            0x04, 0x14, 0x04, 0x3b,  0x63, 0xb6, 0x27, 0x12,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x97, 0x01, 0x35,  0x53, 0x55,  // 854  - zh-mo_radstr
            0x02, 0x14, 0x04, 0x3b,  0x63, 0xb6, 0x27, 0x12,  0x01, 0xf4, 0x00, 0x00,  0x00, 0x97, 0x01, 0x35,  0x53, 0x55,  // 855  - zh-mo_stroke
            0x00, 0x10, 0x04, 0x3a,  0x83, 0xa8, 0x27, 0x18,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd7, 0x01, 0x35,  0x83, 0x58,  // 856  - zh-sg
            0x05, 0x10, 0x04, 0x3a,  0x83, 0xa8, 0x27, 0x18,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd7, 0x01, 0x35,  0x83, 0x58,  // 857  - zh-sg_phoneb
            0x02, 0x10, 0x04, 0x3a,  0x83, 0xa8, 0x27, 0x18,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd7, 0x01, 0x35,  0x83, 0x58,  // 858  - zh-sg_stroke
            0x00, 0x04, 0x04, 0x3b,  0x63, 0xb6, 0x27, 0x12,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xed, 0x01, 0x35,  0xb3, 0x5b,  // 859  - zh-tw
            0x03, 0x04, 0x04, 0x3b,  0x63, 0xb6, 0x27, 0x12,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xed, 0x01, 0x35,  0xb3, 0x5b,  // 860  - zh-tw_pronun
            0x04, 0x04, 0x04, 0x3b,  0x63, 0xb6, 0x27, 0x12,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xed, 0x01, 0x35,  0xb3, 0x5b,  // 861  - zh-tw_radstr
            0x00, 0x00, 0x35, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x35,  0xf3, 0x5f,  // 862  - zu
            0x00, 0x04, 0x35, 0x4e,  0x43, 0x52, 0x27, 0x10,  0x01, 0xf4, 0x00, 0x00,  0x00, 0xd1, 0x11, 0x35,  0xf3, 0x5f,  // 863  - zu-za
        ];

        internal static string? LCIDToLocaleName(int culture)
        {
            uint sort = (uint)culture >> 16;
            culture = (ushort)culture;

            ReadOnlySpan<byte> indices = LcidToCultureNameIndices;

            (int start, int end) = sort switch
            {
                0 => (0, LcidSortPrefix1Index),
                1 => (LcidSortPrefix1Index, LcidSortPrefix2Index),
                2 => (LcidSortPrefix2Index, LcidSortPrefix3Index),
                3 => (LcidSortPrefix3Index, LcidSortPrefix4Index),
                4 => (LcidSortPrefix4Index, LcidSortPrefix5Index),
                5 => (LcidSortPrefix5Index, indices.Length),
                _ => default
            };

            indices = indices[start..end];

            int lo = 0;
            int hi = indices.Length / 4 - 1;

            // Binary search the array
            while (lo <= hi)
            {
                int i = lo + ((hi - lo) >> 1);
                int index = i * 4;

                int array_value = indices[index] << 8 | indices[index + 1];

                int order = array_value.CompareTo(culture);

                if (order == 0)
                {
                    start = (indices[index + 2] << 4) | indices[index + 3] >> 4;
                    int length = indices[index + 3] & 0xF;
                    return GetString(CultureNames.Slice(start, length));
                }

                if (order < 0)
                {
                    lo = i + 1;
                }
                else
                {
                    hi = i - 1;
                }
            }

            return null;
        }

        internal static int GetLocaleDataNumericPart(string cultureName, IcuLocaleDataParts part)
        {
            int index = SearchCultureName(cultureName);
            if (index < 0)
            {
                return -1;
            }

            ReadOnlySpan<byte> numericData = NameIndexToNumericData.Slice(index * NumericLocaleDataBytesPerRow, NumericLocaleDataBytesPerRow);

            return part switch
            {
                IcuLocaleDataParts.Lcid => numericData[2] | (numericData[1] << 8) | (numericData[0] << 16),
                IcuLocaleDataParts.AnsiCodePage => (numericData[4] & 0xf0) >> 4 | (numericData[3] & 0xff) << 4,
                IcuLocaleDataParts.OemCodePage => numericData[5] | (numericData[4] & 0xf) << 8,
                IcuLocaleDataParts.MacCodePage => numericData[7] | (numericData[6] << 8),
                IcuLocaleDataParts.EbcdicCodePage => numericData[9] | (numericData[8] << 8),
                IcuLocaleDataParts.GeoId => numericData[13] | (numericData[12] << 8) | (numericData[11] << 16) | (numericData[10] << 24),
                IcuLocaleDataParts.DigitSubstitutionOrListSeparator => ResolveDigitListSeparator(numericData[14]),
                IcuLocaleDataParts.SpecificLocaleIndex => ResolveIndex((numericData[16] & 0xf0) >> 4 | ((numericData[15] & 0xff) << 4)),
                IcuLocaleDataParts.ConsoleLocaleIndex => ResolveIndex(numericData[17] | (numericData[16] & 0xf) << 8),
                _ => -1
            };

            static int ResolveIndex(int value) => value == 0xfff ? -1 : value;
            static int ResolveDigitListSeparator(int value) => ((value & 0xf0) << 12) | (value & 0xf);
        }

        internal static string? GetThreeLetterWindowsLanguageName(string cultureName)
        {
            int index = SearchCultureName(cultureName);
            if (index < 0)
            {
                return null;
            }

            Debug.Assert(CulturesCount == (ThreeLetterWindowsLanguageName.Length / 3));
            return GetString(ThreeLetterWindowsLanguageName.Slice(index * 3, 3));
        }

        private static string GetLocaleDataMappedCulture(string cultureName, IcuLocaleDataParts part)
        {
            int indexToIndicesTable = GetLocaleDataNumericPart(cultureName, part);
            if (indexToIndicesTable < 0)
            {
                return ""; // fallback to invariant
            }

            return GetString(GetCultureName(indexToIndicesTable));
        }

        internal static string GetSpecificCultureName(string cultureName)
        {
            return GetLocaleDataMappedCulture(cultureName, IcuLocaleDataParts.SpecificLocaleIndex);
        }

        internal static string GetConsoleUICulture(string cultureName)
        {
            return GetLocaleDataMappedCulture(cultureName, IcuLocaleDataParts.ConsoleLocaleIndex);
        }

        // Returns index of the culture or less than 0 if it fail finding any match
        private static int SearchCultureName(string name)
        {
            if (name.Length > LocaleLongestName)
                return -1;

            Span<byte> lower_case = stackalloc byte[name.Length];
            for (int i = 0; i < name.Length; ++i)
            {
                char ch = name[i];

                Debug.Assert(ch <= 'z');
                lower_case[i] = char.IsAsciiLetterUpper(ch) ? (byte)(ch | 0x20) : (byte)ch;
            }

            ReadOnlySpan<byte> lname = lower_case;

            Debug.Assert(CulturesCount * 2 == LocalesNamesIndexes.Length);

            int lo = 0;
            int hi = CulturesCount - 1;

            // Binary search the array
            while (lo <= hi)
            {
                int i = lo + ((hi - lo) >> 1);

                int order = GetCultureName(i).SequenceCompareTo(lname);

                if (order == 0) return i;
                if (order < 0)
                {
                    lo = i + 1;
                }
                else
                {
                    hi = i - 1;
                }
            }

            return ~lo;
        }

        private static ReadOnlySpan<byte> GetCultureName(int localeNameIndice)
        {
            ReadOnlySpan<byte> localesNamesIndexes = LocalesNamesIndexes;
            int index = localeNameIndice * 2;

            int high = localesNamesIndexes[index];
            int low = localesNamesIndexes[index + 1];

            int start = (high << 4) | (low >> 4);
            int length = low & 0xF;

            return CultureNames.Slice(start, length);
        }

        private static string GetString(ReadOnlySpan<byte> buffer)
        {
            string result = string.FastAllocateString(buffer.Length);
            var s = new Span<char>(ref result.GetRawStringData(), buffer.Length);
            for (int i = 0; i < buffer.Length; i++)
            {
                s[i] = (char)buffer[i];
            }

            return result;
        }
    }
}
