Welcome to crosshurd!
=====================

crosshurd can now be used to install not only GNU, but also GNU/Linux and
GNU/kFreeBSD.

The instructions below apply only to Hurd-based GNU system.

1) Create a partition, and put a file system on it. If you are planning
on using ext2, the command:

	mke2fs -o hurd /dev/hda12

(substituting the right partition) is usually good. The -o hurd is
necessary to set appropriate inode and block size and so that the system know
that it's safe to setup translators.

2) Mount it somewhere.

3) Review /etc/crosshurd/sources.list/gnu. The Hurd often requires a few
secondary archives to be added to get all the needed packages. I've
tried to include sensible defaults.

4) Run /usr/sbin/crosshurd

This will ask where the partition is mounted.

Not all packages downloaded by apt will be installed, only Priority: required
ones will be.

5) Setup grub to boot from the new partition.
For a hurd-i386 installation on the first partition of the hd0 disk, you could
add the following to the file /etc/grub.d/40_custom

 menuentry "Debian GNU/Hurd" {
	set root='hd0,msdos1'
	echo	'Loading GNU Mach ...'
	multiboot	/boot/gnumach-1.8-486-up.gz root=part:1:device:hd0
	echo	'Loading the Hurd ...'
	module	/hurd/pci-arbiter.static pci-arbiter \
		--host-priv-port='${host-port}' --device-master-port='${device-port}' \
		--next-task='${acpi-task}' \
		'$(pci-task=task-create)' '$(task-resume)'
	module	/hurd/acpi.static acpi \
		--next-task='${disk-task}' \
		'$(acpi-task=task-create)'
	module	/hurd/rumpdisk.static rumpdisk \
		--next-task='${fs-task}' \
		'$(disk-task=task-create)'
	module	/hurd/ext2fs.static ext2fs \
		--multiboot-command-line='${kernel-command-line}' \
		--exec-server-task='${exec-task}' -T typed '${root}' \
		'$(fs-task=task-create)'
	module	/hurd/exec.static exec '$(exec-task=task-create)'
 }

Following this create a grub configuration file:

	grub-mkconfig > /boot/grub/grub.cfg

And then install to your disk, for example:

	grub-install /dev/sda

6) On the first boot, run :

	./native-install

And when it's done:

	reboot

You may see error messages about not being able to chown to root.  These
are being worked on and are safe to ignore.

7) Reboot, and enjoy.


