/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef INCLUDED_SVX_RULRITEM_HXX
#define INCLUDED_SVX_RULRITEM_HXX

#include <tools/gen.hxx>
#include <svl/poolitem.hxx>
#include <svx/svxdllapi.h>
#include <vector>

class SVX_DLLPUBLIC SvxLongLRSpaceItem : public SfxPoolItem
{
    long    mlLeft;         // nLeft or the negativ first-line indentation
    long    mlRight;        // the unproblematic right edge

  protected:

    virtual int              operator==( const SfxPoolItem& ) const;
    virtual bool             QueryValue( com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 ) const;
    virtual bool             PutValue( const com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 );

    virtual OUString         GetValueText() const;
    virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
                                    SfxMapUnit eCoreMetric,
                                    SfxMapUnit ePresMetric,
                                    OUString &rText, const IntlWrapper * = 0 ) const;

    virtual SfxPoolItem*     Clone( SfxItemPool *pPool = 0 ) const;

private:
    SVX_DLLPRIVATE const SvxLongLRSpaceItem& operator=(const SvxLongLRSpaceItem &); // n.i.

public:
    TYPEINFO();
    SvxLongLRSpaceItem(long lLeft, long lRight, sal_uInt16 nId);
    SvxLongLRSpaceItem(const SvxLongLRSpaceItem &);
    SvxLongLRSpaceItem();

    long GetLeft() const;
    long GetRight() const;
    void SetLeft(long lArgLeft);
    void SetRight(long lArgRight);
};

class SVX_DLLPUBLIC SvxLongULSpaceItem : public SfxPoolItem
{
    long    mlLeft;         // nLeft or the negative first-line indentation
    long    mlRight;        // the unproblematic right edge

  protected:

    virtual int              operator==( const SfxPoolItem& ) const;
    virtual bool             QueryValue( com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 ) const;
    virtual bool             PutValue( const com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 );

    virtual OUString         GetValueText() const;
    virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
                                    SfxMapUnit eCoreMetric,
                                    SfxMapUnit ePresMetric,
                                    OUString &rText, const IntlWrapper * = 0 ) const;

    virtual SfxPoolItem*     Clone( SfxItemPool *pPool = 0 ) const;

private:
    SVX_DLLPRIVATE const SvxLongULSpaceItem& operator=(const SvxLongULSpaceItem &); // n.i.

public:
    TYPEINFO();
    SvxLongULSpaceItem(long lUpper, long lLower, sal_uInt16 nId);
    SvxLongULSpaceItem(const SvxLongULSpaceItem &);
    SvxLongULSpaceItem();

    long GetUpper() const;
    long GetLower() const;
    void SetUpper(long lArgLeft);
    void SetLower(long lArgRight);
};

class SVX_DLLPUBLIC SvxPagePosSizeItem : public SfxPoolItem
{
    Point aPos;
    long lWidth;
    long lHeight;
protected:
    virtual int              operator==( const SfxPoolItem& ) const;
    virtual bool             QueryValue( com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 ) const;
    virtual bool             PutValue( const com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 );

    virtual OUString         GetValueText() const;
    virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
                                    SfxMapUnit eCoreMetric,
                                    SfxMapUnit ePresMetric,
                                    OUString &rText, const IntlWrapper * = 0 ) const;

    virtual SfxPoolItem*     Clone( SfxItemPool *pPool = 0 ) const;

private:
    SVX_DLLPRIVATE const SvxPagePosSizeItem& operator=(const SvxPagePosSizeItem &); // n.i.
public:
    TYPEINFO();
    SvxPagePosSizeItem(const Point &rPos, long lWidth, long lHeight);
    SvxPagePosSizeItem(const SvxPagePosSizeItem &);
    SvxPagePosSizeItem();

    const Point &GetPos() const { return aPos; }
    long    GetWidth() const { return lWidth; }
    long    GetHeight() const { return lHeight; }
};

struct SVX_DLLPUBLIC SvxColumnDescription
{
    long     nStart;    /* Start of the column */
    long     nEnd;      /* End of the column */
    sal_Bool bVisible;  /* Visibility */

    long nEndMin; //min. possible position of end
    long nEndMax; //max. possible position of end

    SvxColumnDescription();

    SvxColumnDescription(const SvxColumnDescription &rCopy);

    SvxColumnDescription(long start, long end, sal_Bool bVis = sal_True);

    SvxColumnDescription(long start, long end,
                         long endMin, long endMax, sal_Bool bVis = sal_True);

    int operator==(const SvxColumnDescription &rCmp) const;
    int operator!=(const SvxColumnDescription &rCmp) const;
    long GetWidth() const;
};

class SVX_DLLPUBLIC SvxColumnItem : public SfxPoolItem
{
    typedef std::vector<SvxColumnDescription> SvxColumnDescriptionVector;
    SvxColumnDescriptionVector aColumns; // Column array

    long nLeft;             // Left edge for the table
    long nRight;            // Right edge for the table; for columns always
                            // equal to the surrounding frame
    sal_uInt16 nActColumn;  // the current column
    sal_uInt8  bTable;      // table?
    sal_uInt8  bOrtho;      // evenly spread columns

protected:
    virtual int operator==( const SfxPoolItem& ) const;

    virtual OUString GetValueText() const;

    virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
                                                 SfxMapUnit eCoreMetric,
                                                 SfxMapUnit ePresMetric,
                                                 OUString &rText,
                                                 const IntlWrapper * = 0 ) const;

    virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0 ) const;
    virtual bool         QueryValue( com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 ) const;
    virtual bool         PutValue( const com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 );

public:
    TYPEINFO();
    // right edge of the surrounding frame
    // nLeft, nRight each the distance to the surrounding frame
    SvxColumnItem(sal_uInt16 nAct = 0);
    SvxColumnItem(sal_uInt16 nActCol, sal_uInt16 nLeft, sal_uInt16 nRight = 0); // Table with borders
    SvxColumnItem(const SvxColumnItem& aItem);
    ~SvxColumnItem();

    const SvxColumnItem &operator=(const SvxColumnItem &);

    SvxColumnDescription&       operator[](sal_uInt16 index);
    const SvxColumnDescription& operator[](sal_uInt16 index) const;
    SvxColumnDescription&       At(sal_uInt16 index);
    SvxColumnDescription&       GetActiveColumnDescription();

    sal_uInt16  Count() const;
    void        Insert(const SvxColumnDescription& rDesc, sal_uInt16 nPos);
    void        Append(const SvxColumnDescription& rDesc);
    void        SetLeft(long aLeft);
    void        SetRight(long aRight);
    sal_uInt16  GetActColumn() const;
    sal_Bool    IsFirstAct() const;
    sal_Bool    IsLastAct() const;
    long        GetLeft();
    long        GetRight();
    sal_Bool    IsTable() const;
    sal_Bool    CalcOrtho() const;
    void        SetOrtho(sal_Bool bVal);
    sal_Bool    IsConsistent() const;
};

// class SvxObjectItem ---------------------------------------------------

class SVX_DLLPUBLIC SvxObjectItem : public SfxPoolItem
{
private:
    long nStartX;   /* Start in x direction */
    long nEndX;     /* End in x direction */
    long nStartY;   /* Start in y direction */
    long nEndY;     /* Ende in y direction */
    sal_Bool bLimits; /* boundary limit control by the application */

protected:
    virtual int              operator==( const SfxPoolItem& ) const;

    virtual OUString         GetValueText() const;
    virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
                                    SfxMapUnit eCoreMetric,
                                    SfxMapUnit ePresMetric,
                                    OUString &rText, const IntlWrapper * = 0 ) const;

    virtual SfxPoolItem*     Clone( SfxItemPool *pPool = 0 ) const;
    virtual bool             QueryValue( com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 ) const;
    virtual bool             PutValue( const com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 );

private:
    SVX_DLLPRIVATE const SvxObjectItem &operator=(const SvxObjectItem &); // n.i.

public:
    TYPEINFO();
    SvxObjectItem(long nStartX, long nEndX,
                  long nStartY, long nEndY,
                  sal_Bool bLimits = sal_False);
    SvxObjectItem(const SvxObjectItem& rCopy);

    sal_Bool HasLimits() const;

    long GetStartX() const;
    long GetEndX() const;
    long GetStartY() const;
    long GetEndY() const;

    void SetStartX(long lValue);
    void SetEndX(long lValue);
    void SetStartY(long lValue);
    void SetEndY(long lValue);
};


#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
