#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Sherlock Holmes: The Devil's Daughter
# send your bug reports to contact@dotslashplay.it
###

script_version=20240826.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='sherlock-holmes-8-the-devils-daughter'
GAME_NAME='Sherlock Holmes: The Devilʼs Daughter'

ARCHIVE_BASE_1_NAME='setup_sherlock_holmes_the_devils_daughter_updated_version_(64bit)_(47726).exe'
ARCHIVE_BASE_1_MD5='a2ce34b1249b455c0bab0cde9f326ac2'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_sherlock_holmes_the_devils_daughter_updated_version_(64bit)_(47726)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='19479d302c3cb9f0fc7dd4900f6973c0'
ARCHIVE_BASE_1_PART2_NAME='setup_sherlock_holmes_the_devils_daughter_updated_version_(64bit)_(47726)-2.bin'
ARCHIVE_BASE_1_PART2_MD5='03a63eca21c2d9daa1575c4207aa7f72'
ARCHIVE_BASE_1_PART3_NAME='setup_sherlock_holmes_the_devils_daughter_updated_version_(64bit)_(47726)-3.bin'
ARCHIVE_BASE_1_PART3_MD5='a7984be1a7dd16f9de45a768d5b4ebd5'
ARCHIVE_BASE_1_PART4_NAME='setup_sherlock_holmes_the_devils_daughter_updated_version_(64bit)_(47726)-4.bin'
ARCHIVE_BASE_1_PART4_MD5='efe77f56083e306e09262b88bcd02f11'
ARCHIVE_BASE_1_SIZE='20000000'
ARCHIVE_BASE_1_VERSION='1.0-gog47726'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/sherlock_holmes_the_devils_daughter'

ARCHIVE_BASE_0_NAME='setup_sherlock_holmes_-_the_devils_daughter_gog-1_(18233).exe'
ARCHIVE_BASE_0_MD5='4832ade71deb5e113329a81f7c28ada3'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_sherlock_holmes_-_the_devils_daughter_gog-1_(18233)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='46292f406b40cdcbe1c49177132284c8'
ARCHIVE_BASE_0_PART2_NAME='setup_sherlock_holmes_-_the_devils_daughter_gog-1_(18233)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='dbffed9110dfb7743aaf2516b805e7cb'
ARCHIVE_BASE_0_PART3_NAME='setup_sherlock_holmes_-_the_devils_daughter_gog-1_(18233)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='68858920f4e670a8377c24c8a21e6733'
ARCHIVE_BASE_0_SIZE='16000000'
ARCHIVE_BASE_0_VERSION='1.0-gog18233'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
CONTENT_GAME_BIN_FILES='
binaries
engine
fdk'
CONTENT_GAME_DATA_TEXTURES_FILES='
sh8game/cookedpcconsole/*.tfc'
CONTENT_GAME_DATA_PART1_FILES='
sh8game/cookedpcconsole/sub_*'
CONTENT_GAME_DATA_PART2_FILES='
sh8game'

WINE_PERSISTENT_DIRECTORIES="
users/\${USER}/Documents/My Games/Sherlock Holmes - The Devil's Daughter GOG/SH8Game"
WINE_WINEPREFIX_TWEAKS='mono'
## Install required Visual C++ 2012 libraries.
WINE_WINETRICKS_VERBS='vcrun2012'

APP_MAIN_EXE='binaries/win64/sherlock.exe'
## The game crashes on launch if these runtime options are not set.
APP_MAIN_OPTIONS='-NOSCREENMESSAGES -SEEKFREELOADINGPCCONSOLE'
## Explicitly set the application type, to prevent it from being mistakingly identified as a Mono game.
APP_MAIN_TYPE='wine'

PACKAGES_LIST='
PKG_BIN
PKG_DATA_TEXTURES
PKG_DATA_PART1
PKG_DATA_PART2'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA_TEXTURES
PKG_DATA_PART1
PKG_DATA_PART2'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_PART1_ID="${PKG_DATA_ID}-part1"
PKG_DATA_PART2_ID="${PKG_DATA_ID}-part2"
PKG_DATA_TEXTURES_ID="${PKG_DATA_ID}-textures"
PKG_DATA_DESCRIPTION='data'
PKG_DATA_PART1_DESCRIPTION="$PKG_DATA_DESCRIPTION - part 1"
PKG_DATA_PART2_DESCRIPTION="$PKG_DATA_DESCRIPTION - part 2"
PKG_DATA_TEXTURES_DESCRIPTION="$PKG_DATA_DESCRIPTION - textures"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA_PART2'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
