#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Return to Mysterious Island 2
# send your bug reports to contact@dotslashplay.it
###

script_version=20240825.2

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='return-to-mysterious-island-2'
GAME_NAME='Return to Mysterious Island 2'

ARCHIVE_BASE_EN_0_NAME='setup_return_to_mysterious_island_2_1.06_(57220).exe'
ARCHIVE_BASE_EN_0_MD5='790c8d739ba367c690e2f22d82b67aac'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_PART1_NAME='setup_return_to_mysterious_island_2_1.06_(57220)-1.bin'
ARCHIVE_BASE_EN_0_PART1_MD5='48f4bef6406c13785014159432ce8cad'
ARCHIVE_BASE_EN_0_SIZE='3547391'
ARCHIVE_BASE_EN_0_VERSION='1.06-gog57220'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/return_to_mysterious_island_2'

ARCHIVE_BASE_FR_0_NAME='setup_return_to_mysterious_island_2_1.06_(french)_(57220).exe'
ARCHIVE_BASE_FR_0_MD5='d4781b8003efc975e92ea007b466c274'
ARCHIVE_BASE_FR_0_TYPE='innosetup'
ARCHIVE_BASE_FR_0_PART1_NAME='setup_return_to_mysterious_island_2_1.06_(french)_(57220)-1.bin'
ARCHIVE_BASE_FR_0_PART1_MD5='5f83e965c02dfc9badaa04347bfd57b7'
ARCHIVE_BASE_FR_0_SIZE='3547182'
ARCHIVE_BASE_FR_0_VERSION='1.06-gog57220'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/return_to_mysterious_island_2'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
ijl15.dll
ipworks8.dll
spr.dll
rtmi2.exe'
CONTENT_GAME_L10N_FILES='
datas/loc/??
datas/cd1/loc_??_cmn.bf
datas/cd1/loc_??_hig.bf
datas/cd1/cmn_cmn.bf
datas/cd2/loc_??_cmn.bf
datas/cd2/loc_??_hig.bf
datas/cd2/cmn_cmn.bf
datas/cmn/cmn/ins/install.ins'
CONTENT_GAME_DATA_FILES='
datas/cd1
datas/cd2
datas/cmn'
CONTENT_DOC_L10N_FILES='
manual.pdf
lisez-moi.txt
readme.txt'

WINE_PERSISTENT_DIRECTORIES='
ProgramData/RTMI2/Saves'

APP_MAIN_EXE='rtmi2.exe'

PACKAGES_LIST='
PKG_BIN
PKG_L10N
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N_BASE
PKG_DATA'
## Ensure easy upgrades from packages generated with pre-20240825.1 game scripts
PKG_BIN_PROVIDES="${PKG_BIN_PROVIDES:-}
retour-sur-lile-mysterieuse-2"

PKG_L10N_BASE_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_BASE_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_BASE_ID}-fr"
PKG_L10N_DESCRIPTION_EN='English localization'
PKG_L10N_DESCRIPTION_FR='French localization'
PKG_L10N_PROVIDES="
$PKG_L10N_BASE_ID"
## Ensure easy upgrades from packages generated with pre-20240825.1 game scripts
PKG_L10N_PROVIDES="${PKG_L10N_PROVIDES:-}
retour-sur-lile-mysterieuse-2-l10n"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
## Ensure easy upgrades from packages generated with pre-20240825.1 game scripts
PKG_DATA_PROVIDES="${PKG_DATA_PROVIDES:-}
retour-sur-lile-mysterieuse-2-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

## Install required configuration file.
config_file_source="${PLAYIT_WORKDIR}/gamedata/__support/app/config.ini"
config_file_destination="$(package_path 'PKG_L10N')$(path_game_data)/config.ini"
case "$(current_archive)" in
	('ARCHIVE_BASE_EN_'*)
		loc_string='UK'
	;;
	('ARCHIVE_BASE_FR_'*)
		loc_string='FR'
	;;
esac
mkdir --parents "$(dirname "$config_file_destination")"
sed "s/^LOC=../LOC=${loc_string}/" "$config_file_source" > "$config_file_destination"

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
