#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2020 macaron
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Broken Sword 2
# send your bug reports to contact@dotslashplay.it
###

script_version=20240822.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='broken-sword-2'
GAME_NAME='Broken Sword Ⅱ: The Smoking Mirror'

GAME_ID_REMASTERED="${GAME_ID}-remastered"
GAME_NAME_REMASTERED="$GAME_NAME - Remastered"

# Archives

## Broken Sword 2 (1997)

ARCHIVE_BASE_0_NAME='gog_broken_sword_2_the_smoking_mirror_1.0.0.2.tar.gz'
ARCHIVE_BASE_0_MD5='003e43babbdb7abc04c64f7482b27329'
ARCHIVE_BASE_0_SIZE='1200000'
ARCHIVE_BASE_0_VERSION='1.0-gog1.0.0.2'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/broken_sword_2__the_smoking_mirror'

## Broken Sword 2 Remastered (2011)

ARCHIVE_BASE_REMASTERED_1_NAME='broken_sword_2_remastered_3_3_0_59987.sh'
ARCHIVE_BASE_REMASTERED_1_MD5='7e9b9959778dfcf4b2e346dbe6657c3f'
ARCHIVE_BASE_REMASTERED_1_SIZE='810000'
ARCHIVE_BASE_REMASTERED_1_VERSION='3.3.0-gog59987'
ARCHIVE_BASE_REMASTERED_1_URL='https://www.gog.com/game/broken_sword_2__the_smoking_mirror'

ARCHIVE_BASE_REMASTERED_0_NAME='gog_broken_sword_2_remastered_2.0.0.3.sh'
ARCHIVE_BASE_REMASTERED_0_MD5='a67ce1d6a47b74281b6f230365fb296a'
ARCHIVE_BASE_REMASTERED_0_SIZE='1400000'
ARCHIVE_BASE_REMASTERED_0_VERSION='1.0.800-gog.2.0.0.3'

# Archive content

## Broken Sword 2 (1997)

CONTENT_PATH_DEFAULT='Broken Sword 2 - The Smoking Mirror/data'
CONTENT_GAME_MAIN_FILES='
*.clu
*.inf
*.tab
*.bmp'
CONTENT_GAME0_MAIN_PATH="${CONTENT_PATH_DEFAULT}/extras"
CONTENT_GAME0_MAIN_FILES='
*'
CONTENT_DOC_MAIN_FILES='
*.txt'
CONTENT_DOC0_MAIN_PATH="${CONTENT_PATH_DEFAULT}/../docs"
CONTENT_DOC0_MAIN_FILES='
*.txt'

## Broken Sword 2 Remastered (2011)

CONTENT_PATH_DEFAULT_REMASTERED='data/noarch/game'
CONTENT_GAME_BIN64_FILES_REMASTERED='
BrokenSword2_x86_64'
CONTENT_GAME_BIN32_FILES_REMASTERED='
BrokenSword2_i386'
CONTENT_GAME_BIN32_FILES_REMASTERED_0='
BS2Remastered_i386'
CONTENT_GAME_DATA_FILES_REMASTERED='
Audio
Comic
Game
Movies
Text
Data.dat
Legal.txt'
CONTENT_GAME_DATA_FILES_0_REMASTERED='
Fonts
PC
Text
icon.bmp
bs2.ico
*.BUK
*.clu
*.dat
*.DAT
*.DIC'

# Launchers

## Broken Sword 2 (1997)

APP_MAIN_SCUMMID='sword2'
APP_MAIN_ICON='../support/gog-broken-sword-2-the-smoking-mirror.png'

## Broken Sword 2 Remastered (2011)

APP_MAIN_EXE_BIN32_REMASTERED='BrokenSword2_i386'
APP_MAIN_EXE_BIN32_REMASTERED_0='BS2Remastered_i386'
APP_MAIN_EXE_BIN64_REMASTERED='BrokenSword2_x86_64'
APP_MAIN_ICON_REMASTERED='../support/icon.png'
APP_MAIN_ICON_REMASTERED_0='icon.bmp'

# Packages

## Broken Sword 2 Remastered (2011)

PACKAGES_LIST_REMASTERED='
PKG_BIN64
PKG_BIN32
PKG_DATA'
PACKAGES_LIST_REMASTERED_0='
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libstdc++.so.6'
PKG_BIN_DEPENDENCIES_LIBRARIES_REMASTERED_0='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libSDL-1.2.so.0
libstdc++.so.6'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES_REMASTERED_0="$PKG_BIN_DEPENDENCIES_LIBRARIES_REMASTERED_0"

PKG_DATA_ID="${GAME_ID_REMASTERED}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Broken Sword 2 (1997) - Convert all file paths to lowercase
	case "$(current_archive)" in
		('ARCHIVE_BASE_REMASTERED_'*) ;;
		(*)
			tolower .
		;;
	esac
)

# Include game data

case "$(current_archive)" in
	('ARCHIVE_BASE_REMASTERED_'*)
		content_inclusion_icons 'PKG_DATA'
	;;
	(*)
		content_inclusion_icons
	;;
esac
content_inclusion_default

# Write launchers

APP_MAIN_EXE_BIN64=$(context_value 'APP_MAIN_EXE_BIN64')
APP_MAIN_EXE_BIN32=$(context_value 'APP_MAIN_EXE_BIN32')
case "$(current_archive)" in
	('ARCHIVE_BASE_REMASTERED_0')
		launchers_generation 'PKG_BIN32'
	;;
	('ARCHIVE_BASE_REMASTERED_'*)
		launchers_generation 'PKG_BIN64'
		launchers_generation 'PKG_BIN32'
	;;
	(*)
		launchers_generation
	;;
esac

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
